/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.osgi;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleServiceTracker<T> {
    private static final Logger logger = LoggerFactory.getLogger(SingleServiceTracker.class);
    private final ServiceTrackerCustomizer<T, T> customizer = new ServiceTrackerCustomizer<T, T>(){

        public T addingService(ServiceReference<T> reference) {
            return SingleServiceTracker.this.adding(reference);
        }

        public void modifiedService(ServiceReference<T> reference, T service) {
            SingleServiceTracker.this.modified(reference, service);
        }

        public void removedService(ServiceReference<T> reference, T service) {
            SingleServiceTracker.this.removed(reference, service);
        }
    };
    private final BundleContext context;
    private final Consumer<T> consumer;
    private final ServiceTracker<T, T> tracker;
    private final LinkedList<Entry<T>> entries = new LinkedList();
    private Entry<T> currentEntry;

    public SingleServiceTracker(BundleContext context, Class<T> clazz, Consumer<T> consumer) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(consumer);
        this.context = context;
        this.consumer = consumer;
        this.tracker = new ServiceTracker(context, clazz, this.customizer);
    }

    public SingleServiceTracker(BundleContext context, Filter filter, Consumer<T> consumer) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(filter);
        Objects.requireNonNull(consumer);
        this.context = context;
        this.consumer = consumer;
        this.tracker = new ServiceTracker(context, filter, this.customizer);
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    private static int getRanking(ServiceReference<?> reference) {
        Object ranking = reference.getProperty("service.ranking");
        if (ranking instanceof Number) {
            return ((Number)ranking).intValue();
        }
        return 0;
    }

    private void insertEntry(Entry<T> entry) {
        if (this.entries.isEmpty()) {
            this.entries.add(entry);
        } else {
            ListIterator<Entry<T>> i = this.entries.listIterator();
            while (i.hasNext()) {
                if (!entry.isBetterThan((Entry)i.next())) continue;
                i.previous();
                break;
            }
            i.add(entry);
        }
    }

    private void updateEntry(ServiceReference<T> reference) {
        ListIterator i = this.entries.listIterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            if (!entry.reference.equals(reference)) continue;
            int ranking = SingleServiceTracker.getRanking(reference);
            if (entry.ranking == ranking) break;
            i.remove();
            entry.ranking = ranking;
            this.insertEntry(entry);
            break;
        }
    }

    protected T adding(ServiceReference<T> reference) {
        int ranking = SingleServiceTracker.getRanking(reference);
        Object service = this.context.getService(reference);
        Entry<Object> entry = new Entry<Object>(ranking, reference, service);
        this.insertEntry(entry);
        if (this.currentEntry == null || entry.isBetterThan(this.currentEntry)) {
            this.setBestEntry(entry);
        }
        return (T)service;
    }

    protected void modified(ServiceReference<T> reference, T service) {
        this.updateEntry(reference);
        Entry<T> bestEntry = this.entries.peekFirst();
        if (this.currentEntry != bestEntry) {
            this.setBestEntry(bestEntry);
        }
    }

    protected void removed(ServiceReference<T> reference, T service) {
        if (!this.entries.removeIf(entry -> ((Entry)entry).reference.equals(reference))) {
            return;
        }
        if (this.currentEntry == null || ((Entry)this.currentEntry).service != service) {
            return;
        }
        if (this.entries.isEmpty()) {
            this.setBestEntry(null);
        } else {
            this.setBestEntry(this.entries.peekFirst());
        }
    }

    private void setBestEntry(Entry<T> entry) {
        this.currentEntry = entry;
        this.notifyService(entry != null ? ((Entry)entry).service : null);
    }

    protected void notifyService(T service) {
        try {
            this.consumer.accept(service);
        }
        catch (Exception e) {
            logger.warn("Failed to notify changed service", (Throwable)e);
        }
    }

    public T getService() {
        Entry<T> entry = this.currentEntry;
        return (T)(entry != null ? ((Entry)entry).service : null);
    }

    private static final class Entry<T> {
        private int ranking;
        private final ServiceReference<T> reference;
        private final T service;

        public Entry(int ranking, ServiceReference<T> reference, T service) {
            this.ranking = ranking;
            this.reference = reference;
            this.service = service;
        }

        public boolean isBetterThan(Entry<T> other) {
            return this.ranking > other.ranking;
        }
    }
}

