/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.subscriber;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.subscriber.CloudSubscriberOptions;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEmitter;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class CloudSubscriber
implements WireEmitter,
ConfigurableComponent,
CloudSubscriberListener {
    private static final Logger logger = LogManager.getLogger(CloudSubscriber.class);
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber cloudSubscriber;
    private CloudSubscriberOptions options;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void setCloudSubscriber(org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber cloudSubscriber) {
        this.cloudSubscriber = cloudSubscriber;
        this.cloudSubscriber.registerCloudSubscriberListener((CloudSubscriberListener)this);
    }

    public void unsetCloudSubscriber(org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber cloudSubscriber) {
        cloudSubscriber.unregisterCloudSubscriberListener((CloudSubscriberListener)this);
        if (this.cloudSubscriber == cloudSubscriber) {
            this.cloudSubscriber = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Cloud Subscriber Wire Component...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.options = new CloudSubscriberOptions(properties);
        logger.debug("Activating Cloud Subscriber Wire Component... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Cloud Subscriber Wire Component...");
        this.options = new CloudSubscriberOptions(properties);
        logger.debug("Updating Cloud Subscriber Wire Component... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Cloud Subscriber Wire Component...");
        logger.debug("Deactivating Cloud Subscriber Wire Component... Done");
    }

    public void consumersConnected(Wire[] wires) {
        this.wireSupport.consumersConnected(wires);
    }

    public Object polled(Wire wires) {
        return this.wireSupport.polled(wires);
    }

    private List<WireRecord> buildWireRecord(KuraPayload payload) {
        Objects.requireNonNull(payload, "Payload cannot be null");
        Map kuraPayloadProperties = payload.metrics();
        HashMap wireProperties = new HashMap();
        for (Map.Entry entry : kuraPayloadProperties.entrySet()) {
            String entryKey = (String)entry.getKey();
            Object entryValue = entry.getValue();
            TypedValue convertedValue = TypedValues.newTypedValue(entryValue);
            wireProperties.put(entryKey, convertedValue);
        }
        Optional<String> bodyProperty = this.options.getBodyProperty();
        if (bodyProperty.isPresent()) {
            this.emitBody(wireProperties, payload, bodyProperty.get(), this.options.getBodyPropertyType());
        }
        WireRecord wireRecord = new WireRecord(wireProperties);
        return Arrays.asList(wireRecord);
    }

    private void emitBody(Map<String, TypedValue<?>> wireRecordProperties, KuraPayload payload, String property, DataType dataType) {
        try {
            byte[] body = payload.getBody();
            if (body == null) {
                return;
            }
            if (dataType == DataType.BYTE_ARRAY) {
                wireRecordProperties.put(property, (TypedValue<?>)new ByteArrayValue(body));
            } else {
                wireRecordProperties.put(property, (TypedValue<?>)new StringValue(new String(body, StandardCharsets.UTF_8)));
            }
        }
        catch (Exception e) {
            logger.warn("failed to emit body", (Throwable)e);
        }
    }

    public void onMessageArrived(KuraMessage message) {
        this.wireSupport.emit(this.buildWireRecord(message.getPayload()));
    }
}

