/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.usb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.kura.net.modem.ModemDevice;
import org.eclipse.kura.usb.AbstractUsbDevice;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class UsbModemDevice
extends AbstractUsbDevice
implements ModemDevice {
    private final ArrayList<TtyDev> ttyDevs = new ArrayList();
    private final ArrayList<String> blockDevs = new ArrayList();

    public UsbModemDevice(String vendorId, String productId, String manufacturerName, String productName, String usbBusNumber, String usbDevicePath) {
        super(vendorId, productId, manufacturerName, productName, usbBusNumber, usbDevicePath);
    }

    public UsbModemDevice(AbstractUsbDevice usbDevice) {
        super(usbDevice);
    }

    @Override
    public List<String> getSerialPorts() {
        ArrayList<String> serialPorts = new ArrayList<String>();
        for (TtyDev dev : this.ttyDevs) {
            serialPorts.add(dev.getPortName());
        }
        return serialPorts;
    }

    public List<String> getTtyDevs() {
        return this.getSerialPorts();
    }

    public List<String> getBlockDevs() {
        return Collections.unmodifiableList(this.blockDevs);
    }

    public void addTtyDev(String ttyDev, Integer interfaceNumber) {
        TtyDev dev = new TtyDev(ttyDev, interfaceNumber);
        if (!this.ttyDevs.contains(dev)) {
            this.ttyDevs.add(new TtyDev(ttyDev, interfaceNumber));
            Collections.sort(this.ttyDevs, new TtyDevComparator());
        }
    }

    @Deprecated
    public void addTtyDev(String ttyDev) {
        this.addTtyDev(ttyDev, null);
    }

    public void addBlockDev(String blockDev) {
        if (!this.blockDevs.contains(blockDev)) {
            this.blockDevs.add(blockDev);
            Collections.sort(this.blockDevs, new DevNameComparator());
        }
    }

    public boolean removeTtyDev(String ttyDev) {
        return this.ttyDevs.remove(new TtyDev(ttyDev));
    }

    public boolean removeBlockDev(String blockDev) {
        return this.blockDevs.remove(blockDev);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.ttyDevs == null ? 0 : this.ttyDevs.hashCode());
        result = 37 * result + (this.blockDevs == null ? 0 : this.blockDevs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsbModemDevice other = (UsbModemDevice)obj;
        if (this.ttyDevs == null ? other.ttyDevs != null : !this.ttyDevs.equals(other.ttyDevs)) {
            return false;
        }
        return !(this.blockDevs == null ? other.blockDevs != null : !this.blockDevs.equals(other.blockDevs));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UsbModem [");
        sb.append("vendorId=").append(this.getVendorId());
        sb.append(", productId=").append(this.getProductId());
        sb.append(", manufName=").append(this.getManufacturerName());
        sb.append(", productName=").append(this.getProductName());
        sb.append(", usbPort=").append(this.getUsbPort());
        sb.append(", ttyDevs=").append(this.ttyDevs.toString());
        sb.append(", blockDevs=").append(this.blockDevs.toString());
        sb.append("]");
        return sb.toString();
    }

    private class DevNameComparator
    implements Comparator<String> {
        private DevNameComparator() {
        }

        @Override
        public int compare(String dev1, String dev2) {
            int digitPos1 = this.getDigitPosition(dev1);
            int digitPos2 = this.getDigitPosition(dev2);
            String text1 = dev1.substring(0, digitPos1);
            String text2 = dev2.substring(0, digitPos2);
            String num1 = dev1.substring(digitPos1, dev1.length());
            String num2 = dev2.substring(digitPos2, dev2.length());
            int textCompare = text1.compareTo(text2);
            if (textCompare != 0) {
                return textCompare;
            }
            if (num1 == null || num1.isEmpty()) {
                if (num2 == null || num2.isEmpty()) {
                    return 0;
                }
                return -1;
            }
            if (num2 == null || num2.isEmpty()) {
                return 1;
            }
            Integer int1 = Integer.parseInt(num1);
            Integer int2 = Integer.parseInt(num2);
            return int1.compareTo(int2);
        }

        private int getDigitPosition(String devName) {
            int pos = devName.length();
            int i = devName.length() - 1;
            while (i >= 0) {
                if (!Character.isDigit(devName.charAt(i))) break;
                pos = i--;
            }
            return pos;
        }
    }

    private static class TtyDev {
        private final String portName;
        private Integer interfaceNumber;

        public TtyDev(String portName) {
            this.portName = portName;
        }

        public TtyDev(String portName, Integer interfaceNumber) {
            this.portName = portName;
            this.interfaceNumber = interfaceNumber;
        }

        public String getPortName() {
            return this.portName;
        }

        public Integer getInterfaceNumber() {
            return this.interfaceNumber;
        }

        public String toString() {
            String number = this.interfaceNumber != null ? this.interfaceNumber.toString() : "null";
            return "TtyDev [portName=" + this.portName + ", interfaceNumber=" + number + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.portName == null ? 0 : this.portName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TtyDev other = (TtyDev)obj;
            return !(this.portName == null ? other.portName != null : !this.portName.equals(other.portName));
        }
    }

    private class TtyDevComparator
    implements Comparator<TtyDev> {
        private TtyDevComparator() {
        }

        @Override
        public int compare(TtyDev dev1, TtyDev dev2) {
            if (dev1.getInterfaceNumber() != null && dev2.getInterfaceNumber() != null) {
                return dev1.getInterfaceNumber().compareTo(dev2.getInterfaceNumber());
            }
            return new DevNameComparator().compare(dev1.getPortName(), dev2.getPortName());
        }
    }
}

