/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.certificate;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class KuraPrivateKeyEntry {
    private final String privateKeyId;
    private final String keystoreId;
    private final String alias;
    private final KeyStore.PrivateKeyEntry privateKeyEntry;

    public KuraPrivateKeyEntry(String keystoreId, String alias, KeyStore.PrivateKeyEntry privateKeyEntry) {
        this.keystoreId = keystoreId;
        this.alias = alias;
        this.privateKeyEntry = privateKeyEntry;
        this.privateKeyId = String.valueOf(keystoreId) + ":" + alias;
    }

    public KuraPrivateKeyEntry(String keystoreId, String alias, PrivateKey privateKey, Certificate[] certificateChain) {
        this.keystoreId = keystoreId;
        this.alias = alias;
        this.privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, certificateChain);
        this.privateKeyId = String.valueOf(keystoreId) + ":" + alias;
    }

    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public String getKeystoreId() {
        return this.keystoreId;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStore.PrivateKeyEntry getPrivateKey() {
        return this.privateKeyEntry;
    }
}

