/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Optional;
import org.eclipse.kura.core.inventory.resources.DockerContainer;
import org.eclipse.kura.core.inventory.resources.DockerContainers;

public class JsonJavaDockerContainersMapper {
    private static final String SYSTEM_CONTAINERS = "containers";
    private static final String SYSTEM_CONTAINERS_CONTAINER_NAME = "name";
    private static final String SYSTEM_CONTAINERS_CONTAINER_VERSION = "version";
    private static final String SYSTEM_CONTAINERS_CONTAINER_TYPE = "type";
    private static final String SYSTEM_CONTAINERS_CONTAINER_STATE = "state";

    private JsonJavaDockerContainersMapper() {
    }

    public static DockerContainer unmarshal(String encoded) {
        JsonObject object = Json.parse((String)encoded).asObject();
        String name = JsonJavaDockerContainersMapper.getStringValue(object, SYSTEM_CONTAINERS_CONTAINER_NAME);
        String version = JsonJavaDockerContainersMapper.getStringValue(object, SYSTEM_CONTAINERS_CONTAINER_VERSION);
        return new DockerContainer(name, version);
    }

    public static String marshal(DockerContainers dockerContainers) {
        JsonObject json = Json.object();
        JsonArray containers = new JsonArray();
        dockerContainers.getDockerContainers().stream().forEach(p -> {
            JsonArray jsonArray2 = containers.add((JsonValue)JsonJavaDockerContainersMapper.getJsonPackage(p));
        });
        json.add(SYSTEM_CONTAINERS, (JsonValue)containers);
        return json.toString();
    }

    private static JsonObject getJsonPackage(DockerContainer p) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(SYSTEM_CONTAINERS_CONTAINER_NAME, p.getName());
        jsonObject.add(SYSTEM_CONTAINERS_CONTAINER_VERSION, p.getVersion());
        jsonObject.add(SYSTEM_CONTAINERS_CONTAINER_TYPE, p.getTypeString());
        jsonObject.add(SYSTEM_CONTAINERS_CONTAINER_STATE, p.getFrameworkContainerState());
        return jsonObject;
    }

    private static Optional<String> getOptionalStringValue(JsonObject object, String name) {
        return Optional.ofNullable(object.get(name)).map(s -> {
            if (s.isString()) {
                return s.asString();
            }
            throw new IllegalArgumentException(String.valueOf(name) + " must be a string");
        });
    }

    private static String getStringValue(JsonObject object, String name) {
        return JsonJavaDockerContainersMapper.getOptionalStringValue(object, name).orElseThrow(() -> new IllegalArgumentException(String.valueOf(name) + " is required"));
    }
}

