/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.shared.model.Gwt8021xConfig;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetRouterMode;
import org.eclipse.kura.web.shared.model.KuraBaseModel;

public class GwtNetInterfaceConfig
extends KuraBaseModel
implements Serializable {
    private static final String ROUTER_DNS_PASS = "routerDnsPass";
    private static final Logger logger = Logger.getLogger(GwtNetInterfaceConfig.class.getSimpleName());
    private static final long serialVersionUID = 7079533925979145804L;
    private Gwt8021xConfig enterpriseConfig = new Gwt8021xConfig();

    public void setEnterpriseConfig(Gwt8021xConfig enterpriseConfig) {
        this.enterpriseConfig = enterpriseConfig;
    }

    public Gwt8021xConfig get8021xConfig() {
        return this.enterpriseConfig;
    }

    public Map<String, Object> getEnterpriseConfigProps() {
        return this.enterpriseConfig.getProperties();
    }

    public String getName() {
        return (String)this.get("name");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getInterfaceName() {
        return (String)this.get("interfaceName");
    }

    public void setInterfaceName(String interfaceName) {
        this.set("interfaceName", interfaceName);
    }

    public GwtNetIfStatus getStatusEnum() {
        return GwtNetIfStatus.valueOf(this.getStatus());
    }

    public String getStatus() {
        return (String)this.get("status");
    }

    public void setStatus(String status) {
        this.set("status", status);
    }

    public Integer getWanPriority() {
        return (Integer)this.get("priority");
    }

    public void setWanPriority(Integer priority) {
        this.set("priority", priority);
    }

    public GwtNetIfConfigMode getConfigModeEnum() {
        return GwtNetIfConfigMode.valueOf(this.getConfigMode());
    }

    public String getConfigMode() {
        return (String)this.get("configMode");
    }

    public void setConfigMode(String configMode) {
        this.set("configMode", configMode);
    }

    public String getIpAddress() {
        return (String)this.get("ipAddress");
    }

    public void setIpAddress(String ipAddress) {
        this.set("ipAddress", ipAddress);
    }

    public String getSubnetMask() {
        return (String)this.get("subnetMask");
    }

    public void setSubnetMask(String subnetMask) {
        this.set("subnetMask", subnetMask);
    }

    public String getGateway() {
        return (String)this.get("gateway");
    }

    public void setGateway(String gateway) {
        this.set("gateway", gateway);
    }

    public String getDnsServers() {
        return (String)this.get("dnsServers");
    }

    public void setDnsServers(String dnsServers) {
        this.set("dnsServers", dnsServers);
    }

    public String getReadOnlyDnsServers() {
        return (String)this.get("dnsReadOnlyServers");
    }

    public void setReadOnlyDnsServers(String dnsServers) {
        this.set("dnsReadOnlyServers", dnsServers);
    }

    public Integer getMtu() {
        return (Integer)this.get("mtu");
    }

    public void setMtu(Integer mtu) {
        this.set("mtu", mtu);
    }

    public void setHwState(String hwState) {
        this.set("hwState", hwState);
    }

    public String getHwState() {
        return (String)this.get("hwState");
    }

    public void setHwName(String hwName) {
        this.set("hwName", hwName);
    }

    public String getHwName() {
        return (String)this.get("hwName");
    }

    public GwtNetIfType getHwTypeEnum() {
        GwtNetIfType typeEnum = GwtNetIfType.UNKNOWN;
        try {
            typeEnum = GwtNetIfType.valueOf(this.getHwType());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error getting HwType.", e);
        }
        return typeEnum;
    }

    public void setHwType(String hwType) {
        this.set("hwType", hwType);
    }

    public String getHwType() {
        return (String)this.get("hwType");
    }

    public void setHwAddress(String hwAddress) {
        this.set("hwAddress", hwAddress);
    }

    public String getHwAddress() {
        return (String)this.get("hwAddress");
    }

    public void setHwSerial(String hwSerial) {
        this.set("hwSerial", hwSerial);
    }

    public String getHwSerial() {
        return (String)this.get("hwSerial");
    }

    public void setHwDriver(String hwDriver) {
        this.set("hwDriver", hwDriver);
    }

    public String getHwDriver() {
        return (String)this.get("hwDriver");
    }

    public void setHwDriverVersion(String hwDriverVersion) {
        this.set("hwDriverVersion", hwDriverVersion);
    }

    public String getHwDriverVersion() {
        return (String)this.get("hwDriverVersion");
    }

    public void setHwFirmware(String hwFirmware) {
        this.set("hwFirmware", hwFirmware);
    }

    public String getHwFirmware() {
        return (String)this.get("hwFirmware");
    }

    public void setHwMTU(int mtu) {
        this.set("hwMTU", mtu);
    }

    public int getHwMTU() {
        if (this.get("hwMTU") != null) {
            return (Integer)this.get("hwMTU");
        }
        return 0;
    }

    public void setHwUsbDevice(String hwUsbDevice) {
        this.set("hwUsbDevice", hwUsbDevice);
    }

    public String getHwUsbDevice() {
        return (String)this.get("hwUsbDevice");
    }

    public String getHwRssi() {
        return (String)this.get("hwRssi");
    }

    public void setHwRssi(String rssi) {
        this.set("hwRssi", rssi);
    }

    public GwtNetRouterMode getRouterModeEnum() {
        return GwtNetRouterMode.valueOf(this.getRouterMode());
    }

    public String getRouterMode() {
        return (String)this.get("routerMode");
    }

    public void setRouterMode(String routerMode) {
        this.set("routerMode", routerMode);
    }

    public String getRouterDhcpBeginAddress() {
        return (String)this.get("routerDhcpBeginAddress");
    }

    public void setRouterDhcpBeginAddress(String routerDhcpBeginAddress) {
        this.set("routerDhcpBeginAddress", routerDhcpBeginAddress);
    }

    public String getRouterDhcpEndAddress() {
        return (String)this.get("routerDhcpEndAddress");
    }

    public void setRouterDhcpEndAddress(String routerDhcpEndAddress) {
        this.set("routerDhcpEndAddress", routerDhcpEndAddress);
    }

    public int getRouterDhcpDefaultLease() {
        if (this.get("routerDhcpDefaultLease") != null) {
            return (Integer)this.get("routerDhcpDefaultLease");
        }
        return 0;
    }

    public void setRouterDhcpDefaultLease(int routerDhcpDefaultLease) {
        this.set("routerDhcpDefaultLease", routerDhcpDefaultLease);
    }

    public int getRouterDhcpMaxLease() {
        if (this.get("routerDhcpMaxLease") != null) {
            return (Integer)this.get("routerDhcpMaxLease");
        }
        return 0;
    }

    public void setRouterDhcpMaxLease(int routerDhcpMaxLease) {
        this.set("routerDhcpMaxLease", routerDhcpMaxLease);
    }

    public String getRouterDhcpSubnetMask() {
        return (String)this.get("routerDhcpSubnetMask");
    }

    public void setRouterDhcpSubnetMask(String routerDhcpSubnetMask) {
        this.set("routerDhcpSubnetMask", routerDhcpSubnetMask);
    }

    public boolean getRouterDnsPass() {
        if (this.get(ROUTER_DNS_PASS) != null) {
            return (Boolean)this.get(ROUTER_DNS_PASS);
        }
        return false;
    }

    public void setRouterDnsPass(boolean routerDnsPass) {
        this.set(ROUTER_DNS_PASS, routerDnsPass);
    }

    public String getIpv6Status() {
        return (String)this.get("ipv6.status");
    }

    public void setIpv6Status(String status) {
        this.set("ipv6.status", status);
    }

    public Integer getIpv6WanPriority() {
        return (Integer)this.get("ipv6.priority");
    }

    public void setIpv6WanPriority(Integer priority) {
        this.set("ipv6.priority", priority);
    }

    public String getIpv6ConfigMode() {
        return (String)this.get("ipv6.configmode");
    }

    public void setIpv6ConfigMode(String configMode) {
        this.set("ipv6.configmode", configMode);
    }

    public String getIpv6AutoconfigurationMode() {
        return (String)this.get("ipv6.autoconfiguration");
    }

    public void setIpv6AutoconfigurationMode(String autoconfigMode) {
        this.set("ipv6.autoconfiguration", autoconfigMode);
    }

    public String getIpv6Address() {
        return (String)this.get("ipv6.address");
    }

    public void setIpv6Address(String ipAddress) {
        this.set("ipv6.address", ipAddress);
    }

    public Integer getIpv6SubnetMask() {
        return (Integer)this.get("ipv6.subnet");
    }

    public void setIpv6SubnetMask(Integer subnetMask) {
        this.set("ipv6.subnet", subnetMask);
    }

    public String getIpv6Gateway() {
        return (String)this.get("ipv6.gateway");
    }

    public void setIpv6Gateway(String gateway) {
        this.set("ipv6.gateway", gateway);
    }

    public String getIpv6DnsServers() {
        return (String)this.get("ipv6.dns");
    }

    public void setIpv6DnsServers(String dnsServers) {
        this.set("ipv6.dns", dnsServers);
    }

    public String getIpv6Privacy() {
        return (String)this.get("ipv6.privacy");
    }

    public void setIpv6Privacy(String privacy) {
        this.set("ipv6.privacy", privacy);
    }

    public String getIpv6ReadOnlyDnsServers() {
        return (String)this.get("ipv6.dnsReadOnly");
    }

    public void setIpv6ReadOnlyDnsServers(String dnsServers) {
        this.set("ipv6.dnsReadOnly", dnsServers);
    }

    public Integer getIpv6Mtu() {
        return (Integer)this.get("ipv6.mtu");
    }

    public void setIpv6Mtu(Integer mtu) {
        this.set("ipv6.mtu", mtu);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GwtNetInterfaceConfig)) {
            return false;
        }
        Map<String, Object> properties = this.getProperties();
        Map<String, Object> otherProps = ((GwtNetInterfaceConfig)o).getProperties();
        if (properties != null) {
            if (otherProps == null) {
                return false;
            }
            if (properties.size() != otherProps.size()) {
                logger.log(Level.FINER, "Sizes differ");
                return false;
            }
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Object oldVal = entry.getValue();
                Object newVal = otherProps.get(entry.getKey());
                if (oldVal != null) {
                    if (oldVal.equals(newVal)) continue;
                    logger.log(Level.FINER, () -> "Values differ - Key: " + (String)entry.getKey() + " oldVal: " + oldVal + ", newVal: " + newVal);
                    return false;
                }
                if (newVal == null) continue;
                return false;
            }
        } else if (otherProps != null) {
            return false;
        }
        return true;
    }
}

