/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.util.function.Predicate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RedirectServlet.class);
    private static final long serialVersionUID = 1L;
    private final Predicate<String> shouldRedirect;
    private final String location;

    public RedirectServlet(Predicate<String> shouldRedirect, String location) {
        this.shouldRedirect = shouldRedirect;
        this.location = location;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    private final void redirect(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String path = req.getRequestURI();
            if (this.shouldRedirect.test(path)) {
                resp.sendRedirect(this.location);
            } else {
                resp.sendError(404);
            }
        }
        catch (Exception e) {
            logger.warn("unexpected exception", (Throwable)e);
        }
    }
}

