/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.security.SecurityService;
import org.eclipse.kura.security.ThreatManagerService;
import org.eclipse.kura.security.tamper.detection.TamperDetectionService;
import org.eclipse.kura.security.tamper.detection.TamperStatus;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtSecurityCapabilities;
import org.eclipse.kura.web.shared.model.GwtTamperStatus;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityService;

public class GwtSecurityServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSecurityService {
    private static final long serialVersionUID = -7664408886756367054L;

    @Override
    public void reloadSecurityPolicyFingerprint(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SecurityService securityService = ServiceLocator.getInstance().getService(SecurityService.class);
        try {
            securityService.reloadSecurityPolicyFingerprint();
        }
        catch (KuraException e) {
            throw new GwtKuraException(e.getMessage());
        }
    }

    @Override
    public void reloadCommandLineFingerprint(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SecurityService securityService = ServiceLocator.getInstance().getService(SecurityService.class);
        try {
            securityService.reloadCommandLineFingerprint();
        }
        catch (KuraException e) {
            throw new GwtKuraException(e.getMessage());
        }
    }

    @Override
    public List<GwtTamperStatus> getTamperStatus(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        ArrayList<GwtTamperStatus> result = new ArrayList<GwtTamperStatus>();
        ServiceLocator.applyToAllServices(TamperDetectionService.class, s -> {
            try {
                TamperStatus tamperStatus = s.getTamperStatus();
                Map<String, String> properties = tamperStatus.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TypedValue)e.getValue()).getValue().toString()));
                result.add(new GwtTamperStatus(s.getDisplayName(), tamperStatus.isDeviceTampered(), properties));
            }
            catch (KuraException e2) {
                throw new GwtKuraException(e2.getMessage());
            }
        });
        return result;
    }

    @Override
    public void resetTamperStatus(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        AtomicReference e = new AtomicReference(Optional.empty());
        ServiceLocator.applyToAllServices(TamperDetectionService.class, s -> {
            try {
                s.resetTamperStatus();
            }
            catch (KuraException ex) {
                e.set(Optional.of(new GwtKuraException(ex.getMessage())));
            }
        });
        Optional ex = e.get();
        if (ex.isPresent()) {
            throw (GwtKuraException)ex.get();
        }
    }

    @Override
    public GwtSecurityCapabilities getCababilities() {
        return new GwtSecurityCapabilities(this.isDebugMode(), this.isSecurityServiceAvailable(), this.isThreatManagerAvailable(), this.isTamperDetectionAvailable());
    }

    private boolean isSecurityServiceAvailable() {
        try {
            SecurityService securityService = ServiceLocator.getInstance().getService(SecurityService.class);
            return securityService != null;
        }
        catch (GwtKuraException gwtKuraException) {
            return false;
        }
    }

    private boolean isTamperDetectionAvailable() {
        try {
            return !ServiceLocator.getInstance().getServiceReferences(TamperDetectionService.class, null).isEmpty();
        }
        catch (GwtKuraException gwtKuraException) {
            return false;
        }
    }

    private boolean isDebugMode() {
        try {
            SecurityService securityService = ServiceLocator.getInstance().getService(SecurityService.class);
            if (securityService != null) {
                return securityService.isDebugEnabled();
            }
        }
        catch (GwtKuraException gwtKuraException) {}
        return false;
    }

    private boolean isThreatManagerAvailable() {
        try {
            ThreatManagerService threatManagerService = ServiceLocator.getInstance().getService(ThreatManagerService.class);
            return threatManagerService != null;
        }
        catch (GwtKuraException gwtKuraException) {
            return false;
        }
    }
}

