/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(TryProcessor.class);
    protected String id;
    protected final Processor tryProcessor;
    protected final List<Processor> catchClauses;
    protected final Processor finallyProcessor;

    public TryProcessor(Processor tryProcessor, List<Processor> catchClauses, Processor finallyProcessor) {
        this.tryProcessor = tryProcessor;
        this.catchClauses = catchClauses;
        this.finallyProcessor = finallyProcessor;
    }

    public String toString() {
        String catchText = this.catchClauses == null || this.catchClauses.isEmpty() ? "" : " Catches {" + this.catchClauses + "}";
        String finallyText = this.finallyProcessor == null ? "" : " Finally {" + this.finallyProcessor + "}";
        return "Try {" + this.tryProcessor + "}" + catchText + finallyText;
    }

    @Override
    public String getTraceLabel() {
        return "doTry";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Iterator<Processor> processors = this.next().iterator();
        Object lastHandled = exchange.getProperty("CamelExceptionHandled");
        exchange.setProperty("CamelExceptionHandled", null);
        while (this.continueRouting(processors, exchange)) {
            exchange.setProperty("TryRouteBlock", true);
            ExchangeHelper.prepareOutToIn(exchange);
            Processor processor = processors.next();
            AsyncProcessor async = AsyncProcessorConverterHelper.convert(processor);
            boolean sync = this.process(exchange, callback, processors, async, lastHandled);
            if (!sync) {
                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                return false;
            }
            LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
        }
        ExchangeHelper.prepareOutToIn(exchange);
        exchange.removeProperty("TryRouteBlock");
        exchange.setProperty("CamelExceptionHandled", lastHandled);
        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        callback.done(true);
        return true;
    }

    protected boolean process(final Exchange exchange, final AsyncCallback callback, final Iterator<Processor> processors, AsyncProcessor processor, final Object lastHandled) {
        LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        boolean sync = processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                while (TryProcessor.this.continueRouting(processors, exchange)) {
                    exchange.setProperty("TryRouteBlock", true);
                    ExchangeHelper.prepareOutToIn(exchange);
                    AsyncProcessor processor = AsyncProcessorConverterHelper.convert((Processor)processors.next());
                    doneSync = TryProcessor.this.process(exchange, callback, processors, processor, lastHandled);
                    if (doneSync) continue;
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                    return;
                }
                ExchangeHelper.prepareOutToIn(exchange);
                exchange.removeProperty("TryRouteBlock");
                exchange.setProperty("CamelExceptionHandled", lastHandled);
                LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                callback.done(false);
            }
        });
        return sync;
    }

    protected boolean continueRouting(Iterator<Processor> it, Exchange exchange) {
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        return it.hasNext();
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.tryProcessor, this.catchClauses, this.finallyProcessor);
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (this.tryProcessor != null) {
            answer.add(this.tryProcessor);
        }
        if (this.catchClauses != null) {
            answer.addAll(this.catchClauses);
        }
        if (this.finallyProcessor != null) {
            answer.add(this.finallyProcessor);
        }
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.tryProcessor != null || this.catchClauses != null && !this.catchClauses.isEmpty() || this.finallyProcessor != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

