/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.auth;

import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.internal.rest.auth.SessionAttributes;
import org.eclipse.kura.util.useradmin.UserAdminHelper;

public class RestSessionHelper {
    private final UserAdminHelper userAdminHelper;

    public RestSessionHelper(UserAdminHelper userAdminHelper) {
        this.userAdminHelper = userAdminHelper;
    }

    public HttpSession createNewAuthenticatedSession(HttpServletRequest request, String user) {
        Optional<HttpSession> existingSession = this.getExistingSession(request);
        if (existingSession.isPresent()) {
            existingSession.get().invalidate();
        }
        HttpSession newSession = request.getSession(true);
        newSession.setAttribute(SessionAttributes.AUTORIZED_USER.getValue(), (Object)user);
        this.updateLastActivity(newSession);
        Optional credentialsHash = this.userAdminHelper.getCredentialsHash(user);
        if (credentialsHash.isPresent()) {
            newSession.setAttribute(SessionAttributes.CREDENTIALS_HASH.getValue(), credentialsHash.get());
        }
        this.getOrCreateXsrfToken(newSession);
        AuditContext.currentOrInternal().getProperties().put("session.id", newSession.getId());
        return newSession;
    }

    public void lockSession(HttpSession session) {
        session.setAttribute(SessionAttributes.LOCKED.getValue(), (Object)true);
    }

    public void unlockSession(HttpSession session) {
        session.setAttribute(SessionAttributes.LOCKED.getValue(), (Object)false);
    }

    public boolean isSessionLocked(HttpSession session) {
        return Objects.equals(true, session.getAttribute(SessionAttributes.LOCKED.getValue()));
    }

    public void updateLastActivity(HttpSession session) {
        session.setAttribute(SessionAttributes.LAST_ACTIVITY.getValue(), (Object)System.nanoTime());
    }

    public Optional<Principal> getPrincipalFromSession(HttpSession session) {
        Object authorized = session.getAttribute(SessionAttributes.AUTORIZED_USER.getValue());
        if (!(authorized instanceof String)) {
            return Optional.empty();
        }
        String userName = (String)authorized;
        return Optional.of(RestSessionHelper.principalForIdentity(userName));
    }

    public boolean credentialsChanged(HttpSession session, String userName) {
        return !Objects.equals(session.getAttribute(SessionAttributes.CREDENTIALS_HASH.getValue()), this.userAdminHelper.getCredentialsHash(userName).orElse(null));
    }

    public Optional<Principal> getCurrentPrincipal(ContainerRequestContext context) {
        return Optional.ofNullable(context.getSecurityContext()).flatMap(c -> Optional.ofNullable(c.getUserPrincipal()));
    }

    public boolean isSessionExpired(HttpSession session, int maxInactiveInterval) {
        long now = System.nanoTime();
        if (!session.isNew()) {
            long lastActivity = RestSessionHelper.getLastActivity(session);
            long delta = now - lastActivity;
            if (maxInactiveInterval > 0 && delta > TimeUnit.SECONDS.toNanos(maxInactiveInterval)) {
                session.invalidate();
                return true;
            }
        }
        return false;
    }

    public Optional<String> getXsrfToken(HttpSession httpSession) {
        return Optional.ofNullable(httpSession.getAttribute(SessionAttributes.XSRF_TOKEN.getValue())).flatMap(t -> t instanceof String ? Optional.of((String)t) : Optional.empty());
    }

    public String getOrCreateXsrfToken(HttpSession httpSession) {
        Optional<String> existiongToken = this.getXsrfToken(httpSession);
        if (existiongToken.isPresent()) {
            return existiongToken.get();
        }
        UUID token = UUID.randomUUID();
        String asString = token.toString();
        httpSession.setAttribute(SessionAttributes.XSRF_TOKEN.getValue(), (Object)asString);
        return asString;
    }

    public boolean isXsrfTokenValid(HttpServletRequest httpServletRequest) {
        return this.checkXsrfToken(Optional.ofNullable(httpServletRequest.getHeader("X-XSRF-Token")), httpServletRequest);
    }

    public boolean checkXsrfToken(Optional<String> userToken, HttpServletRequest httpServletRequest) {
        Optional<HttpSession> session = this.getExistingSession(httpServletRequest);
        if (!userToken.isPresent() || !session.isPresent()) {
            return false;
        }
        return Objects.equals(userToken, this.getXsrfToken(session.get()));
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        Optional<HttpSession> maybeSession = this.getExistingSession(request);
        if (!maybeSession.isPresent()) {
            return;
        }
        HttpSession session = maybeSession.get();
        session.invalidate();
        Cookie[] cookieArray = cookies = request.getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            cookie.setMaxAge(0);
            cookie.setValue(null);
            cookie.setPath("/");
            response.addCookie(cookie);
            ++n2;
        }
    }

    public Optional<HttpSession> getExistingSession(HttpServletRequest request) {
        return Optional.ofNullable(request.getSession(false));
    }

    private static Principal principalForIdentity(String name) {
        return () -> name;
    }

    private static long getLastActivity(HttpSession session) {
        Object lastActivityRaw = session.getAttribute(SessionAttributes.LAST_ACTIVITY.getValue());
        if (!(lastActivityRaw instanceof Long)) {
            return 0L;
        }
        return (Long)lastActivityRaw;
    }
}

