/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.download;

import java.io.File;
import java.io.IOException;
import org.eclipse.kura.core.deployment.install.DeploymentPackageInstallOptions;
import org.eclipse.kura.core.deployment.util.FileUtilities;

public class DownloadFileUtilities
extends FileUtilities {
    public static File getDpDownloadFile(DeploymentPackageInstallOptions options) throws IOException {
        String packageFilename;
        String downloadDirectory = options.getDownloadDirectory();
        if (!options.getSystemUpdate().booleanValue()) {
            String dpName = FileUtilities.getFileName(options.getDpName(), options.getDpVersion(), ".dp", "_");
            packageFilename = downloadDirectory + File.separator + dpName;
        } else {
            String shName = FileUtilities.getFileName(options.getDpName(), options.getDpVersion(), ".sh", "-");
            packageFilename = downloadDirectory + File.separator + shName;
        }
        File localFolder = new File(downloadDirectory);
        String fileName = DownloadFileUtilities.validateFileName(packageFilename, localFolder.getPath());
        return new File(fileName);
    }

    public static boolean deleteDownloadedFile(DeploymentPackageInstallOptions options) throws IOException {
        File file = DownloadFileUtilities.getDpDownloadFile(options);
        if (file != null && file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    private static String validateFileName(String destFileName, String intendedDir) throws IOException {
        File iD;
        String canonicalID;
        File destFile = new File(destFileName);
        String filePath = destFile.getCanonicalPath();
        if (filePath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return filePath;
        }
        throw new IOException();
    }
}

