/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.internal.utils;

import java.util.Set;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KuraServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(KuraServiceFactory.class);

    private KuraServiceFactory() {
    }

    public static <T> T retrieveService(Class<T> clazz, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry cannot be null.");
        }
        Set servicesFromRegistry = registry.findByType(clazz);
        if (servicesFromRegistry.size() == 1) {
            Object service = servicesFromRegistry.iterator().next();
            logger.info("Found Kura " + clazz.getCanonicalName() + " in the registry. Kura component will use that instance.");
            return (T)service;
        }
        if (servicesFromRegistry.size() > 1) {
            throw new IllegalStateException("Too many " + clazz.getCanonicalName() + " services found in a registry: " + servicesFromRegistry.size());
        }
        throw new IllegalArgumentException("No " + clazz.getCanonicalName() + " service instance found in a registry.");
    }
}

