/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Objects;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static byte[] intToBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static byte[] objectToByteArray(Object value) throws IOException {
        Objects.requireNonNull(value, "Value cannot be null.");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream o = new ObjectOutputStream(b);
        o.writeObject(value);
        return b.toByteArray();
    }

    public static byte[] parseHexBinary(String string) {
        int len = string.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + string);
        }
        byte[] out = new byte[len / 2];
        int i = 0;
        while (i < len) {
            int h = TypeUtil.hexToBin(string.charAt(i));
            int l = TypeUtil.hexToBin(string.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + string);
            }
            out[i / 2] = (byte)(h * 16 + l);
            i += 2;
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }
}

