/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.Map;
import org.eclipse.kura.internal.wire.asset.TimestampMode;

class WireAssetOptions {
    public static final String EMIT_ALL_CHANNELS_PROP_NAME = "emit.all.channels";
    public static final String TIMESTAMP_MODE_PROP_NAME = "timestamp.mode";
    public static final String EMIT_ERRORS_PROP_NAME = "emit.errors";
    private boolean emitAllChannels;
    private TimestampMode timestampMode;
    private boolean emitErrors;

    public WireAssetOptions() {
    }

    public WireAssetOptions(Map<String, Object> properties) {
        Object emitAllChannelsProp = properties.get(EMIT_ALL_CHANNELS_PROP_NAME);
        Object emitErrorsProp = properties.get(EMIT_ERRORS_PROP_NAME);
        this.emitAllChannels = emitAllChannelsProp instanceof Boolean && (Boolean)emitAllChannelsProp != false;
        this.emitErrors = emitErrorsProp instanceof Boolean && (Boolean)emitErrorsProp != false;
        this.timestampMode = WireAssetOptions.extractTimestampMode(properties);
    }

    public boolean emitAllChannels() {
        return this.emitAllChannels;
    }

    public TimestampMode getTimestampMode() {
        return this.timestampMode;
    }

    public boolean emitErrors() {
        return this.emitErrors;
    }

    private static TimestampMode extractTimestampMode(Map<String, Object> properties) {
        try {
            return TimestampMode.valueOf(properties.get(TIMESTAMP_MODE_PROP_NAME).toString());
        }
        catch (Exception exception) {
            return TimestampMode.PER_CHANNEL;
        }
    }
}

