/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.event.publisher;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.cloud.CloudPublisherDeliveryListener;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.message.MessageConstants;
import org.eclipse.kura.event.publisher.EventPublisherOptions;
import org.eclipse.kura.event.publisher.helper.CloudEndpointServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventPublisher
implements CloudPublisher,
ConfigurableComponent,
CloudConnectionListener,
CloudPublisherDeliveryListener {
    private static final Logger logger = LoggerFactory.getLogger(EventPublisher.class);
    private static final String TOPIC_PATTERN_STRING = "\\$([^\\s/]+)";
    private static final Pattern TOPIC_PATTERN = Pattern.compile("\\$([^\\s/]+)");
    private BundleContext bundleContext;
    private Set<CloudDeliveryListener> cloudDeliveryListeners = new HashSet<CloudDeliveryListener>();
    private Set<CloudConnectionListener> cloudConnectionListeners = new HashSet<CloudConnectionListener>();
    private EventPublisherOptions options;
    private final ExecutorService worker = Executors.newCachedThreadPool();
    private CloudEndpointServiceHelper cloudHelper;

    public void activate(ComponentContext componentContext, Map<String, Object> properties) throws InvalidSyntaxException {
        logger.debug("Activating ConfigurationChangePublisher...");
        this.bundleContext = componentContext.getBundleContext();
        this.updated(properties);
        logger.debug("Activating ConfigurationChangePublisher... Done.");
    }

    public void updated(Map<String, Object> properties) throws InvalidSyntaxException {
        logger.debug("Updating ConfigurationChangePublisher...");
        this.options = new EventPublisherOptions(properties);
        this.cloudHelper = new CloudEndpointServiceHelper(this.bundleContext, this.options.getCloudEndpointPid());
        logger.debug("Updating ConfigurationChangePublisher... Done.");
    }

    public void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating ConfigurationChangePublisher...");
        this.cloudHelper.close();
        logger.debug("Deactivating ConfigurationChangePublisher... Done.");
    }

    public String publish(KuraMessage message) throws KuraException {
        if (message == null) {
            throw new IllegalArgumentException("Kura message cannot be null");
        }
        String resolvedAppTopic = this.fillAppTopicPlaceholders(this.options.getTopic(), message);
        String fullTopic = this.encodeFullTopic(resolvedAppTopic);
        HashMap<String, Object> publishMessageProps = new HashMap<String, Object>();
        publishMessageProps.put(MessageConstants.FULL_TOPIC.name(), fullTopic);
        publishMessageProps.put(MessageConstants.QOS.name(), this.options.getQos());
        publishMessageProps.put(MessageConstants.RETAIN.name(), this.options.isRetain());
        publishMessageProps.put(MessageConstants.PRIORITY.name(), this.options.getPriority());
        publishMessageProps.put(MessageConstants.CONTROL.name(), true);
        return this.cloudHelper.publish(new KuraMessage(message.getPayload(), publishMessageProps));
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.cloudDeliveryListeners.remove(cloudDeliveryListener);
    }

    public void onDisconnected() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onDisconnected()));
    }

    public void onConnectionLost() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onConnectionLost()));
    }

    public void onConnectionEstablished() {
        this.cloudConnectionListeners.forEach(listener -> this.worker.execute(() -> ((CloudConnectionListener)listener).onConnectionEstablished()));
    }

    public void onMessageConfirmed(String messageId, String topic) {
        this.cloudDeliveryListeners.forEach(listener -> this.worker.execute(() -> listener.onMessageConfirmed(messageId)));
    }

    private String fillAppTopicPlaceholders(String appTopic, KuraMessage message) {
        Matcher matcher = TOPIC_PATTERN.matcher(appTopic);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            Map properties = message.getProperties();
            if (!properties.containsKey(matcher.group(1))) continue;
            String replacement = matcher.group(0);
            Object value = properties.get(matcher.group(1));
            if (replacement == null) continue;
            matcher.appendReplacement(buffer, value.toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String encodeFullTopic(String appTopic) {
        String accountName = CloudServiceOptions.getTopicAccountToken();
        String clientId = CloudServiceOptions.getTopicClientIdToken();
        String topicSeparator = CloudServiceOptions.getTopicSeparator();
        StringBuilder sb = new StringBuilder();
        Optional<String> topicPrefix = this.options.getTopicPrefix();
        if (topicPrefix.isPresent()) {
            sb.append(topicPrefix.get()).append(topicSeparator);
        }
        sb.append(accountName).append(topicSeparator);
        sb.append(clientId).append(topicSeparator).append(appTopic);
        return sb.toString();
    }
}

