/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.kura.util.configuration.Property;

public class RestServiceOptions {
    private static final Property<Integer[]> ALLOWED_PORTS = new Property("allowed.ports", (Object)new Integer[0]);
    private static final Property<Boolean> PASSWORD_AUTH_ENABLED = new Property("auth.password.enabled", (Object)true);
    private static final Property<Boolean> CERTIFICATE_ENABLED = new Property("auth.certificate.enabled", (Object)true);
    private final Set<Integer> allowedPorts;
    private final boolean passwordAuthEnabled;
    private final boolean certificateAuthEnabled;

    public RestServiceOptions(Map<String, Object> properties) {
        this.allowedPorts = RestServiceOptions.loadIntArrayProperty((Integer[])ALLOWED_PORTS.get(properties));
        this.passwordAuthEnabled = (Boolean)PASSWORD_AUTH_ENABLED.get(properties);
        this.certificateAuthEnabled = (Boolean)CERTIFICATE_ENABLED.get(properties);
    }

    public Set<Integer> getAllowedPorts() {
        return this.allowedPorts;
    }

    public boolean isPasswordAuthEnabled() {
        return this.passwordAuthEnabled;
    }

    public boolean isCertificateAuthEnabled() {
        return this.certificateAuthEnabled;
    }

    private static Set<Integer> loadIntArrayProperty(Integer[] list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        int i = 0;
        while (i < list.length) {
            Integer value = list[i];
            if (value != null) {
                result.add(value);
            }
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.allowedPorts, this.certificateAuthEnabled, this.passwordAuthEnabled);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RestServiceOptions)) {
            return false;
        }
        RestServiceOptions other = (RestServiceOptions)obj;
        return Objects.equals(this.allowedPorts, other.allowedPorts) && this.certificateAuthEnabled == other.certificateAuthEnabled && this.passwordAuthEnabled == other.passwordAuthEnabled;
    }
}

