/*
 * Decompiled with CFR 0.152.
 */
package com.codeminders.hidapplet;

import com.codeminders.hidapi.HIDDeviceInfo;
import com.codeminders.hidapi.HIDManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HidApplet
extends JApplet {
    private static final long serialVersionUID = 619732094067421147L;
    HIDManager hid_mgr = null;

    @Override
    public void init() {
        boolean x64;
        String os = System.getProperty("os.name", "win").toLowerCase();
        String arch = System.getProperty("os.arch", "x86");
        boolean bl = x64 = arch.indexOf("_64") != -1;
        String library = os.indexOf("win") != -1 ? "hidapi-windows.dll" : (os.indexOf("mac") != -1 ? "hidapi-mac.so" : "hidapi-unix.so");
        System.out.println("Using library: " + library);
        try {
            int l;
            InputStream libSrc = Thread.currentThread().getContextClassLoader().getResourceAsStream("native/" + library);
            if (libSrc == null) {
                System.err.println("No library found");
                return;
            }
            File libFile = File.createTempFile("hdapi", ".lib");
            System.out.println("Copying library to: " + libFile.getAbsolutePath());
            byte[] buf = new byte[16384];
            FileOutputStream libDest = new FileOutputStream(libFile);
            while ((l = libSrc.read(buf)) > 0) {
                ((OutputStream)libDest).write(buf, 0, l);
            }
            libSrc.close();
            ((OutputStream)libDest).close();
            System.out.println("Loading native library");
            System.load(libFile.getAbsolutePath());
            System.out.println("Native library loaded");
            System.out.println("Listing HID devices");
            JTextArea results = new JTextArea();
            results.setEditable(false);
            results.setEnabled(false);
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(results), "Center");
            StringBuilder b = new StringBuilder();
            this.hid_mgr = HIDManager.getInstance();
            for (HIDDeviceInfo info : this.hid_mgr.listDevices()) {
                b.append(info).append('\n');
            }
            results.setText(b.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        if (null != this.hid_mgr) {
            this.hid_mgr.release();
        }
    }
}

