/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.inventory;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraProcessExecutionErrorException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.container.orchestration.ContainerInstanceDescriptor;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.container.orchestration.ImageInstanceDescriptor;
import org.eclipse.kura.core.inventory.resources.ContainerImage;
import org.eclipse.kura.core.inventory.resources.ContainerImages;
import org.eclipse.kura.core.inventory.resources.DockerContainer;
import org.eclipse.kura.core.inventory.resources.DockerContainers;
import org.eclipse.kura.core.inventory.resources.SystemBundle;
import org.eclipse.kura.core.inventory.resources.SystemBundleRef;
import org.eclipse.kura.core.inventory.resources.SystemBundles;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackage;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackages;
import org.eclipse.kura.core.inventory.resources.SystemPackage;
import org.eclipse.kura.core.inventory.resources.SystemPackages;
import org.eclipse.kura.core.inventory.resources.SystemResourcesInfo;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.system.SystemResourceInfo;
import org.eclipse.kura.system.SystemResourceType;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryHandlerV1
implements ConfigurableComponent,
RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(InventoryHandlerV1.class);
    public static final String APP_ID = "INVENTORY-V1";
    public static final String RESOURCE_DEPLOYMENT_PACKAGES = "deploymentPackages";
    public static final String RESOURCE_BUNDLES = "bundles";
    public static final String RESOURCE_SYSTEM_PACKAGES = "systemPackages";
    public static final String RESOURCE_DOCKER_CONTAINERS = "containers";
    public static final String RESOURCE_CONTAINER_IMAGES = "images";
    public static final String INVENTORY = "inventory";
    private static final String START = "_start";
    private static final String STOP = "_stop";
    private static final String DELETE = "_delete";
    private static final List<String> START_BUNDLE = Arrays.asList("bundles", "_start");
    private static final List<String> STOP_BUNDLE = Arrays.asList("bundles", "_stop");
    private static final List<String> START_CONTAINER = Arrays.asList("containers", "_start");
    private static final List<String> STOP_CONTAINER = Arrays.asList("containers", "_stop");
    private static final List<String> DELETE_IMAGE = Arrays.asList("images", "_delete");
    private static final String CANNOT_FIND_RESOURCE_MESSAGE = "Cannot find resource with name: {}";
    private static final String NONE_RESOURCE_FOUND_MESSAGE = "Expected one resource but found none";
    private static final String BAD_REQUEST_TOPIC_MESSAGE = "Bad request topic: {}";
    private static final String ERROR_GETTING_RESOURCE = "Error getting resource {}";
    private static final String MISSING_MESSAGE_BODY = "missing message body";
    private DeploymentAdmin deploymentAdmin;
    private SystemService systemService;
    private BundleContext bundleContext;
    private ContainerOrchestrationService containerOrchestrationService;

    public void setContainerOrchestrationService(ContainerOrchestrationService containerOrchestrationService) {
        this.containerOrchestrationService = containerOrchestrationService;
    }

    public void unsetContainerOrchestrationService(ContainerOrchestrationService containerOrchestrationService) {
        if (this.containerOrchestrationService == containerOrchestrationService) {
            this.containerOrchestrationService = null;
        }
    }

    protected void setDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        this.deploymentAdmin = deploymentAdmin;
    }

    protected void unsetDeploymentAdmin(DeploymentAdmin deploymentAdmin) {
        if (this.deploymentAdmin == deploymentAdmin) {
            this.deploymentAdmin = null;
        }
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        if (this.systemService == systemService) {
            this.systemService = null;
        }
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    protected void activate(ComponentContext componentContext) {
        logger.info("Inventory v1 is starting");
        this.bundleContext = componentContext.getBundleContext();
    }

    protected void deactivate() {
        logger.info("Bundle {} is deactivating!", (Object)APP_ID);
        this.bundleContext = null;
    }

    public KuraMessage doGet(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload resPayload;
        List<String> resources = this.extractResources(reqMessage);
        if (resources.get(0).equals(INVENTORY)) {
            resPayload = this.doGetInventory();
        } else if (resources.get(0).equals(RESOURCE_DEPLOYMENT_PACKAGES)) {
            resPayload = this.doGetPackages();
        } else if (resources.get(0).equals(RESOURCE_BUNDLES)) {
            resPayload = this.doGetBundles();
        } else if (resources.get(0).equals(RESOURCE_SYSTEM_PACKAGES)) {
            resPayload = this.doGetSystemPackages();
        } else if (resources.get(0).equals(RESOURCE_DOCKER_CONTAINERS)) {
            resPayload = this.doGetDockerContainers();
        } else if (resources.get(0).equals(RESOURCE_CONTAINER_IMAGES)) {
            resPayload = this.doGetContainerImages();
        } else {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(CANNOT_FIND_RESOURCE_MESSAGE, (Object)resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return new KuraMessage(resPayload);
    }

    private List<String> extractResources(KuraMessage reqMessage) throws KuraException {
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        if (resources.isEmpty()) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, (Object)resources);
            logger.error(NONE_RESOURCE_FOUND_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        return resources;
    }

    public KuraMessage doExec(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        List<String> resources = this.extractResources(reqMessage);
        try {
            if (START_BUNDLE.equals(resources)) {
                this.findFirstMatchingBundle(this.extractBundleRef(reqMessage)).start();
                return InventoryHandlerV1.success();
            }
            if (STOP_BUNDLE.equals(resources)) {
                this.findFirstMatchingBundle(this.extractBundleRef(reqMessage)).stop();
                return InventoryHandlerV1.success();
            }
            if (START_CONTAINER.equals(resources)) {
                if (this.containerOrchestrationService == null) {
                    return InventoryHandlerV1.notFound();
                }
                this.containerOrchestrationService.startContainer(this.findFirstMatchingContainer(this.extractContainerRef(reqMessage)).getContainerId());
                return InventoryHandlerV1.success();
            }
            if (STOP_CONTAINER.equals(resources)) {
                if (this.containerOrchestrationService == null) {
                    return InventoryHandlerV1.notFound();
                }
                this.containerOrchestrationService.stopContainer(this.findFirstMatchingContainer(this.extractContainerRef(reqMessage)).getContainerId());
                return InventoryHandlerV1.success();
            }
            if (DELETE_IMAGE.equals(resources)) {
                if (this.containerOrchestrationService == null) {
                    return InventoryHandlerV1.notFound();
                }
                this.containerOrchestrationService.deleteImage(this.findFirstMatchingImage(this.extractContainerImageRef(reqMessage)).getImageId());
                return InventoryHandlerV1.success();
            }
        }
        catch (KuraException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug("unexpected exception dispatcing call", (Throwable)e);
            throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE);
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    public KuraMessage doDel(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    private KuraPayload doGetPackages() {
        DeploymentPackage[] dps = this.deploymentAdmin.listDeploymentPackages();
        SystemDeploymentPackages xdps = new SystemDeploymentPackages();
        SystemDeploymentPackage[] axdp = new SystemDeploymentPackage[dps.length];
        int i = 0;
        while (i < dps.length) {
            DeploymentPackage dp = dps[i];
            BundleInfo[] bis = dp.getBundleInfos();
            SystemBundle[] axbi = new SystemBundle[bis.length];
            boolean dpSigned = true;
            int j = 0;
            while (j < bis.length) {
                BundleInfo bi = bis[j];
                SystemBundle xb = new SystemBundle(bi.getSymbolicName(), bi.getVersion().toString());
                Bundle[] bundles = this.bundleContext.getBundles();
                Optional<Bundle> bundle = Arrays.asList(bundles).stream().filter(b -> b.getSymbolicName().equals(bi.getSymbolicName())).findFirst();
                if (bundle.isPresent()) {
                    boolean bundleSigned = true;
                    if (bundle.get().getSignerCertificates(1).isEmpty()) {
                        bundleSigned = false;
                        dpSigned = false;
                    }
                    xb.setId(bundle.get().getBundleId());
                    xb.setState(this.bundleStateToString(bundle.get().getState()));
                    xb.setSigned(bundleSigned);
                }
                axbi[j] = xb;
                ++j;
            }
            SystemDeploymentPackage xdp = new SystemDeploymentPackage(dp.getName(), dp.getVersion().toString());
            xdp.setBundleInfos(axbi);
            xdp.setSigned(dpSigned);
            axdp[i] = xdp;
            ++i;
        }
        xdps.setDeploymentPackages(axdp);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            String s = this.marshal(xdps);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error("Error getting resource {}: {}", (Object)RESOURCE_DEPLOYMENT_PACKAGES, (Object)e);
        }
        return respPayload;
    }

    private KuraPayload doGetBundles() {
        Bundle[] bundles = this.bundleContext.getBundles();
        SystemBundles systemBundles = new SystemBundles();
        SystemBundle[] axb = new SystemBundle[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            SystemBundle systemBundle = new SystemBundle(bundle.getSymbolicName(), bundle.getVersion().toString());
            systemBundle.setId(bundle.getBundleId());
            int state = bundle.getState();
            systemBundle.setState(this.bundleStateToString(state));
            axb[i] = systemBundle;
            ++i;
        }
        systemBundles.setBundles(axb);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            String s = this.marshal(systemBundles);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error(ERROR_GETTING_RESOURCE, (Object)RESOURCE_BUNDLES, (Object)e);
        }
        return respPayload;
    }

    private KuraPayload doGetInventory() {
        ArrayList<SystemResourceInfo> inventory = new ArrayList<SystemResourceInfo>();
        try {
            inventory.addAll(this.systemService.getSystemPackages());
        }
        catch (KuraProcessExecutionErrorException e) {
            logger.error(ERROR_GETTING_RESOURCE, (Object)RESOURCE_SYSTEM_PACKAGES, (Object)e);
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        Arrays.asList(bundles).stream().forEach(b -> {
            boolean bl = inventory.add(new SystemResourceInfo(b.getSymbolicName(), b.getVersion().toString(), SystemResourceType.BUNDLE));
        });
        DeploymentPackage[] dps = this.deploymentAdmin.listDeploymentPackages();
        Arrays.asList(dps).stream().forEach(dp -> {
            boolean bl = inventory.add(new SystemResourceInfo(dp.getName(), dp.getVersion().toString(), SystemResourceType.DP));
        });
        if (this.containerOrchestrationService != null) {
            try {
                logger.info("Creating docker invenetory");
                List containers = this.containerOrchestrationService.listContainerDescriptors();
                containers.stream().forEach(container -> {
                    boolean bl = inventory.add(new SystemResourceInfo(container.getContainerName().replace("/", ""), String.valueOf(container.getContainerImage()) + ":" + container.getContainerImageTag().split(":")[0], SystemResourceType.DOCKER));
                });
            }
            catch (Exception exception) {
                logger.error("Could not connect to docker");
            }
        }
        if (this.containerOrchestrationService != null) {
            try {
                logger.info("Creating container images invenetory");
                List images = this.containerOrchestrationService.listImageInstanceDescriptors();
                images.stream().forEach(image -> {
                    boolean bl = inventory.add(new SystemResourceInfo(image.getImageName(), image.getImageTag(), SystemResourceType.CONTAINER_IMAGE));
                });
            }
            catch (Exception exception) {
                logger.error("Could not connect to container-engine");
            }
        }
        inventory.sort(Comparator.comparing(SystemResourceInfo::getName));
        SystemResourcesInfo systemResourcesInfo = new SystemResourcesInfo(inventory);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            String s = this.marshal(systemResourcesInfo);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e1) {
            logger.error("Error getting inventory", (Throwable)e1);
            respPayload.setResponseCode(500);
        }
        return respPayload;
    }

    private KuraPayload doGetSystemPackages() {
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            List systemResourceList = this.systemService.getSystemPackages();
            ArrayList<SystemPackage> systemPackageList = new ArrayList<SystemPackage>();
            systemResourceList.stream().forEach(p -> {
                boolean bl = systemPackageList.add(new SystemPackage(p.getName(), p.getVersion(), p.getType()));
            });
            SystemPackages systemPackages = new SystemPackages(systemPackageList);
            String s = this.marshal(systemPackages);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error(ERROR_GETTING_RESOURCE, (Object)RESOURCE_SYSTEM_PACKAGES, (Object)e);
            respPayload.setResponseCode(500);
        }
        return respPayload;
    }

    private KuraPayload doGetDockerContainers() {
        if (this.containerOrchestrationService == null) {
            return new KuraResponsePayload(404);
        }
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            List containers = this.containerOrchestrationService.listContainerDescriptors();
            ArrayList<DockerContainer> containersList = new ArrayList<DockerContainer>();
            containers.stream().forEach(p -> {
                boolean bl = containersList.add(new DockerContainer((ContainerInstanceDescriptor)p));
            });
            DockerContainers dockerContainers = new DockerContainers(containersList);
            String s = this.marshal(dockerContainers);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error(ERROR_GETTING_RESOURCE, (Object)RESOURCE_SYSTEM_PACKAGES, (Object)e);
            respPayload.setResponseCode(500);
        }
        return respPayload;
    }

    private KuraPayload doGetContainerImages() {
        if (this.containerOrchestrationService == null) {
            return new KuraResponsePayload(404);
        }
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            List containers = this.containerOrchestrationService.listImageInstanceDescriptors();
            ArrayList<ContainerImage> imageList = new ArrayList<ContainerImage>();
            containers.stream().forEach(p -> {
                boolean bl = imageList.add(new ContainerImage((ImageInstanceDescriptor)p));
            });
            ContainerImages containerImages = new ContainerImages(imageList);
            String s = this.marshal(containerImages);
            respPayload.setTimestamp(new Date());
            respPayload.setBody(s.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error(ERROR_GETTING_RESOURCE, (Object)RESOURCE_SYSTEM_PACKAGES, (Object)e);
            respPayload.setResponseCode(500);
        }
        return respPayload;
    }

    private <T> ServiceReference<T>[] getJsonMarshallers(Class<T> classz) {
        String filterString = String.format("(kura.service.pid=%s)", "org.eclipse.kura.json.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, classz, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }

    protected String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = this.getJsonMarshallers(Marshaller.class);
        try {
            try {
                ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
                int n = marshallerSRs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)this.bundleContext.getService(marshallerSR);
                    result = marshaller.marshal(object);
                    if (result != null) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to marshal configuration.");
                this.ungetServiceReferences(marshallerSRs);
            }
        }
        finally {
            this.ungetServiceReferences(marshallerSRs);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T unmarshal(String str, Class<T> classz) throws KuraException {
        Object result = null;
        ServiceReference<Unmarshaller>[] unmarshallerSRs = this.getJsonMarshallers(Unmarshaller.class);
        try {
            ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
            int n = unmarshallerSRs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                Unmarshaller unmarshaller = (Unmarshaller)this.bundleContext.getService(unmarshallerSR);
                result = unmarshaller.unmarshal(str, classz);
                if (result != null) {
                    Object object = result;
                    this.ungetServiceReferences(unmarshallerSRs);
                    return (T)object;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            this.ungetServiceReferences(unmarshallerSRs);
            throw throwable;
        }
        {
            catch (Exception exception) {
                logger.warn("Failed to unmarshal request.");
                this.ungetServiceReferences(unmarshallerSRs);
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
                break;
            }
        }
        this.ungetServiceReferences(unmarshallerSRs);
        throw new KuraException(KuraErrorCode.BAD_REQUEST);
    }

    private String bundleStateToString(int state) {
        String stateString;
        switch (state) {
            case 1: {
                stateString = "UNINSTALLED";
                break;
            }
            case 2: {
                stateString = "INSTALLED";
                break;
            }
            case 4: {
                stateString = "RESOLVED";
                break;
            }
            case 8: {
                stateString = "STARTING";
                break;
            }
            case 16: {
                stateString = "STOPPING";
                break;
            }
            case 32: {
                stateString = "ACTIVE";
                break;
            }
            default: {
                stateString = String.valueOf(state);
            }
        }
        return stateString;
    }

    private SystemBundleRef extractBundleRef(KuraMessage message) throws KuraException {
        KuraPayload payload = message.getPayload();
        byte[] body = payload.getBody();
        if (body == null) {
            logger.warn(MISSING_MESSAGE_BODY);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        return this.unmarshal(new String(message.getPayload().getBody(), StandardCharsets.UTF_8), SystemBundleRef.class);
    }

    private ContainerInstanceDescriptor extractContainerRef(KuraMessage message) throws KuraException {
        KuraPayload payload = message.getPayload();
        byte[] body = payload.getBody();
        if (body == null) {
            logger.warn(MISSING_MESSAGE_BODY);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        DockerContainer dc = this.unmarshal(new String(message.getPayload().getBody(), StandardCharsets.UTF_8), DockerContainer.class);
        try {
            List containerList = this.containerOrchestrationService.listContainerDescriptors();
            for (ContainerInstanceDescriptor container : containerList) {
                if (!container.getContainerName().equals(dc.getContainerName())) continue;
                return container;
            }
            logger.warn("Failed to find container");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        catch (Exception exception) {
            logger.warn("failed to access docker service");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    private ImageInstanceDescriptor extractContainerImageRef(KuraMessage message) throws KuraException {
        KuraPayload payload = message.getPayload();
        byte[] body = payload.getBody();
        if (body == null) {
            logger.warn(MISSING_MESSAGE_BODY);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        ContainerImage dc = this.unmarshal(new String(message.getPayload().getBody(), StandardCharsets.UTF_8), ContainerImage.class);
        try {
            List imageList = this.containerOrchestrationService.listImageInstanceDescriptors();
            for (ImageInstanceDescriptor image : imageList) {
                if (!image.getImageName().equals(dc.getImageName()) || !image.getImageTag().equals(dc.getImageTag())) continue;
                return image;
            }
            logger.warn("Failed to find image");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        catch (Exception exception) {
            logger.warn("failed to access docker service");
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    private Bundle findFirstMatchingBundle(SystemBundleRef ref) throws KuraException {
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Optional<String> version;
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(ref.getName()) && (!(version = ref.getVersion()).isPresent() || version.get().equals(bundle.getVersion().toString()))) {
                return bundle;
            }
            ++n2;
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    private ContainerInstanceDescriptor findFirstMatchingContainer(ContainerInstanceDescriptor ref) throws KuraException {
        for (ContainerInstanceDescriptor container : this.containerOrchestrationService.listContainerDescriptors()) {
            if (!container.getContainerName().equals(ref.getContainerName())) continue;
            return container;
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    private ImageInstanceDescriptor findFirstMatchingImage(ImageInstanceDescriptor ref) throws KuraException {
        for (ImageInstanceDescriptor image : this.containerOrchestrationService.listImageInstanceDescriptors()) {
            if (!image.getImageName().equals(ref.getImageName()) || !image.getImageTag().equals(ref.getImageTag())) continue;
            return image;
        }
        throw new KuraException(KuraErrorCode.NOT_FOUND);
    }

    private static KuraMessage success() {
        KuraResponsePayload response = new KuraResponsePayload(200);
        response.setTimestamp(new Date());
        return new KuraMessage((KuraPayload)response);
    }

    private static KuraMessage notFound() {
        KuraResponsePayload response = new KuraResponsePayload(404);
        response.setTimestamp(new Date());
        return new KuraMessage((KuraPayload)response);
    }
}

