/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class PushEvent<T> {
    PushEvent() {
    }

    public abstract EventType getType();

    public T getData() {
        throw new IllegalStateException("Not a DATA event, the event type is " + (Object)((Object)this.getType()));
    }

    public Throwable getFailure() {
        throw new IllegalStateException("Not an ERROR event, the event type is " + (Object)((Object)this.getType()));
    }

    public boolean isTerminal() {
        return true;
    }

    public static <T> PushEvent<T> data(T payload) {
        return new DataEvent<T>(payload);
    }

    public static <T> PushEvent<T> error(Throwable t) {
        return new ErrorEvent(t);
    }

    public static <T> PushEvent<T> close() {
        return new CloseEvent();
    }

    public <X> PushEvent<X> nodata() {
        PushEvent result = this;
        return result;
    }

    static final class CloseEvent<T>
    extends PushEvent<T> {
        CloseEvent() {
        }

        @Override
        public EventType getType() {
            return EventType.CLOSE;
        }
    }

    static final class DataEvent<T>
    extends PushEvent<T> {
        private final T data;

        DataEvent(T data) {
            this.data = data;
        }

        @Override
        public T getData() {
            return this.data;
        }

        @Override
        public EventType getType() {
            return EventType.DATA;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }

        @Override
        public <X> PushEvent<X> nodata() {
            throw new IllegalStateException("This event is a DATA event");
        }
    }

    static final class ErrorEvent<T>
    extends PushEvent<T> {
        private final Throwable error;

        ErrorEvent(Throwable error) {
            this.error = error;
        }

        @Override
        public Throwable getFailure() {
            return this.error;
        }

        @Override
        public EventType getType() {
            return EventType.ERROR;
        }
    }

    public static enum EventType {
        DATA,
        ERROR,
        CLOSE;

    }
}

