/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Priority;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.provider.RestServiceOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestService
implements AuthenticationHandler,
AuthorizationHandler,
ConfigurableComponent,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);
    private static final String KURA_PASSWORD_CREDENTIAL = "kura.password";
    private static final String KURA_PERMISSION_PREFIX = "kura.permission.";
    private static final String KURA_PERMISSION_REST_PREFIX = "kura.permission.rest.";
    private static final String KURA_USER_PREFIX = "kura.user.";
    private static final String KURA_NEED_PASSWORD_CHANGE = "kura.need.password.change";
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Response UNAUTHORIZED_RESPONSE = Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"kura-rest-api\"").build();
    private static final Response NOT_FOUND_RESPONSE = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    private CryptoService cryptoService;
    private UserAdmin userAdmin;
    RestServiceOptions options;
    private final List<ServiceRegistration<?>> registeredServices = new ArrayList();
    @Context
    private HttpServletRequest sr;

    public void setUserAdmin(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void activate(Map<String, Object> properties) {
        logger.info("activating...");
        BundleContext bundleContext = FrameworkUtil.getBundle(RestService.class).getBundleContext();
        this.registeredServices.add(bundleContext.registerService(ContainerRequestFilter.class, (Object)new IncomingPortCheckFilter(), null));
        this.options = new RestServiceOptions(properties);
        logger.info("activating...done");
    }

    public void update(Map<String, Object> properties) {
        logger.info("updating...");
        this.options = new RestServiceOptions(properties);
        logger.info("updating...done");
    }

    public void deactivate() {
        logger.info("deactivating...");
        for (ServiceRegistration<?> reg : this.registeredServices) {
            reg.unregister();
        }
        logger.info("deactivating...done");
    }

    public boolean isUserInRole(Principal requestUser, String role) {
        try {
            User user = (User)this.userAdmin.getRole(KURA_USER_PREFIX + requestUser.getName());
            return RestService.containsBasicMember(this.userAdmin.getRole(KURA_PERMISSION_REST_PREFIX + role), user) || RestService.containsBasicMember(this.userAdmin.getRole("kura.permission.kura.admin"), user);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Principal authenticate(ContainerRequestContext request) {
        AuditContext auditContext = this.initAuditContext(request);
        try {
            Optional<Principal> fromCertificateAuth = this.performCertificateAuthentication(request);
            if (fromCertificateAuth.isPresent()) {
                return fromCertificateAuth.get();
            }
            Optional<Principal> principal = this.performBasicAuthentication(request);
            if (principal.isPresent()) {
                auditLogger.info("{} Rest - Success - Password Authentication succeeded", (Object)auditContext);
                return principal.get();
            }
            throw new IllegalStateException();
        }
        catch (Exception exception) {
            auditLogger.warn("{} Rest - Failure - Received unauthorized REST request", (Object)auditContext);
            request.abortWith(UNAUTHORIZED_RESPONSE);
            return null;
        }
    }

    public String getAuthenticationScheme() {
        return null;
    }

    private Optional<Principal> performBasicAuthentication(ContainerRequestContext request) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        AuditContext auditContext = AuditContext.currentOrInternal();
        String authHeader = request.getHeaderString("Authorization");
        if (authHeader == null) {
            return Optional.empty();
        }
        StringTokenizer tokens = new StringTokenizer(authHeader);
        String authScheme = tokens.nextToken();
        if (!"Basic".equals(authScheme)) {
            return Optional.empty();
        }
        String credentials = new String(BASE64_DECODER.decode(tokens.nextToken()), StandardCharsets.UTF_8);
        int colon = credentials.indexOf(58);
        String userName = credentials.substring(0, colon);
        String requestPassword = credentials.substring(colon + 1);
        auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), userName);
        User user = (User)this.userAdmin.getRole(KURA_USER_PREFIX + userName);
        if ("true".equals(user.getProperties().get(KURA_NEED_PASSWORD_CHANGE))) {
            return Optional.empty();
        }
        String passwordHash = (String)user.getCredentials().get(KURA_PASSWORD_CREDENTIAL);
        if (this.cryptoService.sha256Hash(requestPassword).equals(passwordHash)) {
            return Optional.of(() -> userName);
        }
        return Optional.empty();
    }

    private Optional<Principal> performCertificateAuthentication(ContainerRequestContext context) {
        AuditContext auditContext = AuditContext.currentOrInternal();
        try {
            Object clientCertificatesRaw = context.getProperty("javax.servlet.request.X509Certificate");
            if (!(clientCertificatesRaw instanceof X509Certificate[])) {
                return Optional.empty();
            }
            X509Certificate[] clientCertificates = (X509Certificate[])clientCertificatesRaw;
            if (clientCertificates.length == 0) {
                throw new IllegalArgumentException("Certificate chain is empty");
            }
            LdapName ldapName = new LdapName(clientCertificates[0].getSubjectX500Principal().getName());
            Optional<Rdn> commonNameRdn = ldapName.getRdns().stream().filter(r -> "cn".equalsIgnoreCase(r.getType())).findAny();
            if (!commonNameRdn.isPresent()) {
                throw new IllegalArgumentException("Certificate common name is not present");
            }
            String commonName = (String)commonNameRdn.get().getValue();
            auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), commonName);
            if (this.userAdmin.getRole(KURA_USER_PREFIX + commonName) instanceof User) {
                auditLogger.info("{} Rest - Success - Certificate Authentication succeeded", (Object)auditContext);
                return Optional.of(() -> commonName);
            }
            auditLogger.warn("{} Rest - Failure - Certificate Authentication failed", (Object)auditContext);
            return Optional.empty();
        }
        catch (Exception exception) {
            auditLogger.warn("{} Rest - Failure - Certificate Authentication failed", (Object)auditContext);
            return Optional.empty();
        }
    }

    private static boolean containsBasicMember(Role group, User user) {
        if (!(group instanceof Group)) {
            return false;
        }
        Group asGroup = (Group)group;
        Role[] members = asGroup.getMembers();
        if (members == null) {
            return false;
        }
        Role[] roleArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            Role member = roleArray[n2];
            if (member.getName().equals(user.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        int responseStatus = responseContext.getStatus();
        SecurityContext context = requestContext.getSecurityContext();
        AuditContext auditContext = this.initAuditContext(requestContext);
        try {
            if (responseContext.getStatus() == 404) {
                auditLogger.warn("{} Rest - Failure - Service not found", (Object)auditContext);
                return;
            }
            if (context == null) {
                auditLogger.warn("{} Rest - Failure - No security context", (Object)auditContext);
                return;
            }
            Principal principal = context.getUserPrincipal();
            if (principal == null) {
                auditLogger.warn("{} Rest - Failure - User not authenticated", (Object)auditContext);
                return;
            }
            if (responseStatus >= 200 && responseStatus < 400) {
                auditLogger.info("{} Rest - Success - Rest request succeeded", (Object)auditContext);
            } else {
                auditLogger.warn("{} Rest - Failure - Request failed", (Object)auditContext);
            }
        }
        finally {
            this.closeAuditContext(requestContext);
        }
    }

    private String getRequestPath(ContainerRequestContext request) {
        List pathSegments = request.getUriInfo().getPathSegments();
        Iterator iterator = pathSegments.iterator();
        StringBuilder pathBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            pathBuilder.append(((PathSegment)iterator.next()).getPath());
            if (!iterator.hasNext()) continue;
            pathBuilder.append("/");
        }
        return pathBuilder.toString();
    }

    private AuditContext initAuditContext(ContainerRequestContext request) {
        Object rawContext = request.getProperty("org.eclipse.kura.rest.audit.context");
        if (rawContext != null) {
            return (AuditContext)rawContext;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        String requestIp = request.getHeaderString("X-FORWARDED-FOR");
        if (requestIp == null) {
            requestIp = this.sr.getRemoteAddr();
        }
        properties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "RestService");
        properties.put(AuditConstants.KEY_IP.getValue(), requestIp);
        properties.put("rest.method", request.getMethod());
        properties.put("rest.path", this.getRequestPath(request));
        AuditContext result = new AuditContext(properties);
        AuditContext.Scope scope = AuditContext.openScope((AuditContext)result);
        request.setProperty("org.eclipse.kura.rest.audit.context", (Object)result);
        request.setProperty("org.eclipse.kura.rest.audit.scope", (Object)scope);
        return result;
    }

    private void closeAuditContext(ContainerRequestContext request) {
        Object rawScope = request.getProperty("org.eclipse.kura.rest.audit.scope");
        if (rawScope instanceof AuditContext.Scope) {
            ((AuditContext.Scope)rawScope).close();
        }
    }

    @Provider
    @Priority(value=900)
    private class IncomingPortCheckFilter
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest sr;

        private IncomingPortCheckFilter() {
        }

        public void filter(ContainerRequestContext request) throws IOException {
            RestService.this.initAuditContext(request);
            Set<Integer> allowedPorts = RestService.this.options.getAllowedPorts();
            if (allowedPorts.isEmpty()) {
                return;
            }
            int port = this.sr.getLocalPort();
            if (!allowedPorts.contains(port)) {
                request.abortWith(NOT_FOUND_RESPONSE);
            }
        }
    }
}

