/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.container.orchestration.ContainerConfiguration;
import org.eclipse.kura.container.orchestration.PasswordRegistryCredentials;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.eclipse.kura.util.configuration.Property;

public class ContainerInstanceOptions {
    private static final Property<Boolean> IS_ENABLED = new Property("container.enabled", (Object)false);
    private static final Property<String> CONTAINER_IMAGE = new Property("container.image", (Object)"nginx");
    private static final Property<String> CONTAINER_IMAGE_TAG = new Property("container.image.tag", (Object)"latest");
    private static final Property<String> CONTAINER_NAME = new Property("kura.service.pid", (Object)"kura_test_container");
    private static final Property<String> CONTAINER_PORTS_EXTERNAL = new Property("container.ports.external", (Object)"");
    private static final Property<String> CONTAINER_PORTS_INTERNAL = new Property("container.ports.internal", (Object)"");
    private static final Property<String> CONTAINER_ENV = new Property("container.env", (Object)"");
    private static final Property<String> CONTAINER_VOLUME = new Property("container.volume", (Object)"");
    private static final Property<String> CONTAINER_DEVICE = new Property("container.device", (Object)"");
    private static final Property<Boolean> CONTAINER_PRIVILEGED = new Property("container.privileged", (Object)false);
    private static final Property<Integer> CONTAINER_IMAGE_DOWNLOAD_RETRIES = new Property("container.image.download.retries", (Object)5);
    private static final Property<Integer> CONTAINER_IMAGE_DOWNLOAD_RETRY_INTERVAL = new Property("container.image.download.interval", (Object)30000);
    private static final Property<String> CONTAINER_LOGGER_PARAMETERS = new Property("container.loggerParameters", (Object)"");
    private static final Property<String> CONTAINER_LOGGING_TYPE = new Property("container.loggingType", (Object)"default");
    private static final Property<String> REGISTRY_URL = new Property("registry.hostname", (Object)"");
    private static final Property<String> REGISTRY_USERNAME = new Property("registry.username", (Object)"");
    private static final Property<String> REGISTRY_PASSWORD = new Property("registry.password", (Object)"");
    private static final Property<Integer> IMAGES_DOWNLOAD_TIMEOUT = new Property("container.image.download.timeout", (Object)500);
    private final boolean enabled;
    private final String image;
    private final String imageTag;
    private final String containerName;
    private final List<Integer> internalPorts;
    private final List<Integer> externalPorts;
    private final String containerEnv;
    private final String containerVolumeString;
    private final String containerDevice;
    private final boolean privilegedMode;
    private final Map<String, String> containerVolumes;
    private final int maxDownloadRetries;
    private final int retryInterval;
    private final Map<String, String> containerLoggingParameters;
    private final String containerLoggerType;
    private final Optional<String> registryURL;
    private final Optional<String> registryUsername;
    private final Optional<String> registryPassword;
    private final int imageDownloadTimeout;

    public ContainerInstanceOptions(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        this.enabled = (Boolean)IS_ENABLED.get(properties);
        this.image = (String)CONTAINER_IMAGE.get(properties);
        this.imageTag = (String)CONTAINER_IMAGE_TAG.get(properties);
        this.containerName = (String)CONTAINER_NAME.get(properties);
        this.internalPorts = this.parsePortString((String)CONTAINER_PORTS_INTERNAL.get(properties));
        this.externalPorts = this.parsePortString((String)CONTAINER_PORTS_EXTERNAL.get(properties));
        this.containerEnv = (String)CONTAINER_ENV.get(properties);
        this.containerVolumeString = (String)CONTAINER_VOLUME.get(properties);
        this.containerVolumes = this.parseVolume(this.containerVolumeString);
        this.containerDevice = (String)CONTAINER_DEVICE.get(properties);
        this.privilegedMode = (Boolean)CONTAINER_PRIVILEGED.get(properties);
        this.maxDownloadRetries = (Integer)CONTAINER_IMAGE_DOWNLOAD_RETRIES.get(properties);
        this.retryInterval = (Integer)CONTAINER_IMAGE_DOWNLOAD_RETRY_INTERVAL.get(properties);
        this.containerLoggerType = (String)CONTAINER_LOGGING_TYPE.get(properties);
        this.containerLoggingParameters = this.parseLoggingParams((String)CONTAINER_LOGGER_PARAMETERS.get(properties));
        this.registryURL = REGISTRY_URL.getOptional(properties);
        this.registryUsername = REGISTRY_USERNAME.getOptional(properties);
        this.registryPassword = REGISTRY_PASSWORD.getOptional(properties);
        this.imageDownloadTimeout = (Integer)IMAGES_DOWNLOAD_TIMEOUT.get(properties);
    }

    private Map<String, String> parseVolume(String volumeString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.containerVolumeString.isEmpty()) {
            return map;
        }
        String[] stringArray = volumeString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] tempEntry = entry.split(":");
            if (tempEntry.length == 2) {
                map.put(tempEntry[0].trim(), tempEntry[1].trim());
            }
            ++n2;
        }
        return map;
    }

    private Map<String, String> parseLoggingParams(String loggingString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (loggingString.isEmpty()) {
            return map;
        }
        String[] stringArray = loggingString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] tempEntry = entry.split("=");
            if (tempEntry.length == 2) {
                map.put(tempEntry[0].trim(), tempEntry[1].trim());
            }
            ++n2;
        }
        return map;
    }

    private List<String> parseEnvVars(String containerVolumeString) {
        LinkedList<String> envList = new LinkedList<String>();
        if (containerVolumeString.isEmpty()) {
            return envList;
        }
        String[] stringArray = containerVolumeString.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            envList.add(entry.trim());
            ++n2;
        }
        return envList;
    }

    private List<String> parseDeviceStrings(String containerDevice) {
        LinkedList<String> deviceList = new LinkedList<String>();
        if (containerDevice.isEmpty()) {
            return deviceList;
        }
        String[] stringArray = containerDevice.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            deviceList.add(entry.trim());
            ++n2;
        }
        return deviceList;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getContainerImage() {
        return this.image;
    }

    public String getContainerImageTag() {
        return this.imageTag;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public List<Integer> getContainerPortsInternal() {
        return this.internalPorts;
    }

    public List<Integer> getContainerPortsExternal() {
        return this.externalPorts;
    }

    public Map<String, String> getContainerVolumeList() {
        return this.parseVolume(this.containerVolumeString);
    }

    public List<String> getContainerEnvList() {
        return this.parseEnvVars(this.containerEnv);
    }

    public List<String> getContainerDeviceList() {
        return this.parseDeviceStrings(this.containerDevice);
    }

    public boolean getPrivilegedMode() {
        return this.privilegedMode;
    }

    public boolean isUnlimitedRetries() {
        return this.maxDownloadRetries == 0;
    }

    public int getMaxDownloadRetries() {
        return this.maxDownloadRetries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public String getLoggingType() {
        return this.containerLoggerType;
    }

    public Map<String, String> getLoggerParameters() {
        return this.containerLoggingParameters;
    }

    public Optional<RegistryCredentials> getRegistryCredentials() {
        if (this.registryUsername.isPresent() && this.registryPassword.isPresent()) {
            return Optional.of(new PasswordRegistryCredentials(this.registryURL, this.registryUsername.get(), new Password(this.registryPassword.get())));
        }
        return Optional.empty();
    }

    public int getImageDownloadTimeout() {
        return this.imageDownloadTimeout;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return ContainerConfiguration.builder().setContainerName(this.getContainerName()).setContainerImage(this.getContainerImage()).setContainerImageTag(this.getContainerImageTag()).setExternalPorts(this.getContainerPortsExternal()).setInternalPorts(this.getContainerPortsInternal()).setEnvVars(this.getContainerEnvList()).setVolumes(this.getContainerVolumeList()).setPrivilegedMode(Boolean.valueOf(this.privilegedMode)).setDeviceList(this.getContainerDeviceList()).setFrameworkManaged(Boolean.valueOf(true)).setLoggingType(this.getLoggingType()).setLoggerParameters(this.getLoggerParameters()).setRegistryCredentials(this.getRegistryCredentials()).setImageDownloadTimeoutSeconds(this.getImageDownloadTimeout()).build();
    }

    private List<Integer> parsePortString(String ports) {
        ArrayList<Integer> tempArray = new ArrayList<Integer>();
        if (!ports.isEmpty()) {
            String[] tempString;
            String[] stringArray = tempString = ports.trim().replace(" ", "").split(",");
            int n = tempString.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                tempArray.add(Integer.parseInt(element.trim().replace("-", "")));
                ++n2;
            }
        }
        return tempArray;
    }

    public int hashCode() {
        return Objects.hash(this.containerDevice, this.containerEnv, this.containerLoggerType, this.containerLoggingParameters, this.containerName, this.containerVolumeString, this.containerVolumes, this.enabled, this.externalPorts, this.image, this.imageDownloadTimeout, this.imageTag, this.internalPorts, this.maxDownloadRetries, this.privilegedMode, this.registryPassword, this.registryURL, this.registryUsername, this.retryInterval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainerInstanceOptions)) {
            return false;
        }
        ContainerInstanceOptions other = (ContainerInstanceOptions)obj;
        return Objects.equals(this.containerDevice, other.containerDevice) && Objects.equals(this.containerEnv, other.containerEnv) && Objects.equals(this.containerLoggerType, other.containerLoggerType) && Objects.equals(this.containerLoggingParameters, other.containerLoggingParameters) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerVolumeString, other.containerVolumeString) && Objects.equals(this.containerVolumes, other.containerVolumes) && this.enabled == other.enabled && Objects.equals(this.externalPorts, other.externalPorts) && Objects.equals(this.image, other.image) && this.imageDownloadTimeout == other.imageDownloadTimeout && Objects.equals(this.imageTag, other.imageTag) && Objects.equals(this.internalPorts, other.internalPorts) && this.maxDownloadRetries == other.maxDownloadRetries && this.privilegedMode == other.privilegedMode && Objects.equals(this.registryPassword, other.registryPassword) && Objects.equals(this.registryURL, other.registryURL) && Objects.equals(this.registryUsername, other.registryUsername) && this.retryInterval == other.retryInterval;
    }
}

