/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty.metrics;

import io.moquette.server.netty.metrics.BytesMetrics;
import java.util.concurrent.atomic.AtomicLong;

public class BytesMetricsCollector {
    private AtomicLong readBytes = new AtomicLong();
    private AtomicLong wroteBytes = new AtomicLong();

    public BytesMetrics computeMetrics() {
        BytesMetrics allMetrics = new BytesMetrics();
        allMetrics.incrementRead(this.readBytes.get());
        allMetrics.incrementWrote(this.wroteBytes.get());
        return allMetrics;
    }

    public void sumReadBytes(long count) {
        this.readBytes.getAndAdd(count);
    }

    public void sumWroteBytes(long count) {
        this.wroteBytes.getAndAdd(count);
    }
}

