/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.config;

import io.moquette.server.config.ConfigurationParser;
import io.moquette.server.config.IConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathConfig
implements IConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathConfig.class);
    private final Properties m_properties;

    public ClasspathConfig() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream("config/moquette.conf");
        if (is == null) {
            throw new RuntimeException("Can't locate the resource \"config/moquette.conf\"");
        }
        InputStreamReader configReader = new InputStreamReader(is);
        ConfigurationParser confParser = new ConfigurationParser();
        try {
            confParser.parse(configReader);
        }
        catch (ParseException pex) {
            LOG.warn("An error occurred in parsing configuration, fallback on default configuration", pex);
        }
        this.m_properties = confParser.getProperties();
    }

    @Override
    public void setProperty(String name, String value) {
        this.m_properties.setProperty(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.m_properties.getProperty(name, defaultValue);
    }
}

