/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import java.sql.SQLException;
import java.util.Map;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.db.H2DbServerOptions;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DbServer
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(H2DbServer.class);
    private Server server;

    protected void activate(Map<String, Object> properties) {
        logger.info("activating...");
        this.updated(properties);
        logger.info("activating...done");
    }

    protected void updated(Map<String, Object> properties) {
        logger.info("updating...");
        this.restartServer(new H2DbServerOptions(properties));
        logger.info("updating...done");
    }

    protected void deactivate() {
        logger.info("deactivating...");
        this.shutdownServer();
        logger.info("deactivating...done");
    }

    private void restartServer(H2DbServerOptions configuration) {
        this.shutdownServer();
        Server newServer = null;
        if (configuration.isServerEnabled().booleanValue()) {
            try {
                logger.info("Starting DB server...");
                String[] commandline = configuration.getServerCommandLine().split(" ");
                logger.debug("Server type: {}, commandline: {}", (Object)configuration.getServerType(), (Object)commandline);
                switch (configuration.getServerType()) {
                    case TCP: {
                        newServer = Server.createTcpServer((String[])commandline);
                        break;
                    }
                    case WEB: {
                        newServer = Server.createWebServer((String[])commandline);
                        break;
                    }
                    case PG: {
                        newServer = Server.createPgServer((String[])commandline);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown server type");
                    }
                }
                newServer.start();
                this.server = newServer;
                logger.info("Starting DB server...done");
            }
            catch (SQLException e) {
                logger.error("Failed to start server", (Throwable)e);
                this.shutdownServer(newServer);
            }
        }
    }

    private void shutdownServer() {
        this.shutdownServer(this.server);
        this.server = null;
    }

    private void shutdownServer(Server server) {
        if (server != null) {
            try {
                logger.info("Shutting down DB server...");
                server.stop();
                logger.info("Shutting down DB server...done");
            }
            catch (Exception e) {
                logger.error("failed to shutdown DB server", (Throwable)e);
            }
        }
    }

    static enum ServerType {
        WEB,
        TCP,
        PG;

    }
}

