/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnecton.raw.mqtt.util;

import java.util.function.Consumer;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static <T> Consumer<T> catchAll(Consumer<T> consumer) {
        return item -> {
            try {
                consumer.accept(item);
            }
            catch (Exception e) {
                logger.warn("unexpected exception", (Throwable)e);
            }
        };
    }

    public static Filter createFilter(Class<?> type, String kuraServicePid) throws InvalidSyntaxException {
        StringBuilder builder = new StringBuilder();
        builder.append("(&(").append("objectClass").append('=').append(type.getName()).append(")(").append("kura.service.pid").append('=').append(kuraServicePid).append("))");
        return FrameworkUtil.createFilter((String)builder.toString());
    }
}

