/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnection.raw.mqtt.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory;
import org.eclipse.kura.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class RawMqttCloudConnectionFactory
implements CloudConnectionFactory {
    private static final String FACTORY_PID = "org.eclipse.kura.cloudconnection.raw.mqtt.factory.RawMqttCloudConnectionFactory";
    private static final String CLOUD_ENDPOINT_FACTORY_PID = "org.eclipse.kura.cloudconnection.raw.mqtt.cloud.RawMqttCloudEndpoint";
    private static final String DATA_SERVICE_FACTORY_PID = "org.eclipse.kura.data.DataService";
    private static final String DATA_TRANSPORT_SERVICE_FACTORY_PID = "org.eclipse.kura.core.data.transport.mqtt.MqttDataTransport";
    private static final String CLOUD_SERVICE_PID = "org.eclipse.kura.cloudconnection.raw.mqtt.CloudEndpoint";
    private static final String DATA_SERVICE_PID = "org.eclipse.kura.cloudconnection.raw.mqtt.DataService";
    private static final String DATA_TRANSPORT_SERVICE_PID = "org.eclipse.kura.cloudconnection.raw.mqtt.MqttDataTransport";
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private static final String DATA_TRANSPORT_SERVICE_REFERENCE_NAME = "DataTransportService";
    private static final String REFERENCE_TARGET_VALUE_FORMAT = "(kura.service.pid=%s)";
    private static final Pattern MANAGED_CLOUD_SERVICE_PID_PATTERN = Pattern.compile("^org\\.eclipse\\.kura\\.cloudconnection\\.raw\\.mqtt\\.CloudEndpoint(-[a-zA-Z0-9]+)?$");
    private ConfigurationService configurationService;

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        if (configurationService == this.configurationService) {
            this.configurationService = null;
        }
    }

    public String getFactoryPid() {
        return CLOUD_ENDPOINT_FACTORY_PID;
    }

    public void createConfiguration(String pid) throws KuraException {
        String dataTransportServicePid;
        String dataServicePid;
        String[] parts = pid.split("-");
        if (parts.length != 0 && CLOUD_SERVICE_PID.equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            dataServicePid = DATA_SERVICE_PID;
            dataTransportServicePid = DATA_TRANSPORT_SERVICE_PID;
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
        } else {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Invalid PID '{}'", pid});
        }
        HashMap<String, String> cloudServiceProperties = new HashMap<String, String>();
        String name = "DataService.target";
        cloudServiceProperties.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, dataServicePid));
        cloudServiceProperties.put("kura.cloud.connection.factory.pid", FACTORY_PID);
        this.configurationService.createFactoryConfiguration(CLOUD_ENDPOINT_FACTORY_PID, pid, cloudServiceProperties, false);
        HashMap<String, String> dataServiceProperties = new HashMap<String, String>();
        name = "DataTransportService.target";
        dataServiceProperties.put(name, String.format(REFERENCE_TARGET_VALUE_FORMAT, dataTransportServicePid));
        this.configurationService.createFactoryConfiguration(DATA_SERVICE_FACTORY_PID, dataServicePid, dataServiceProperties, false);
        this.configurationService.createFactoryConfiguration(DATA_TRANSPORT_SERVICE_FACTORY_PID, dataTransportServicePid, null, true);
    }

    public void deleteConfiguration(String pid) throws KuraException {
        String[] parts = pid.split("-");
        if (parts.length != 0 && CLOUD_SERVICE_PID.equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            String dataServicePid = DATA_SERVICE_PID;
            String dataTransportServicePid = DATA_TRANSPORT_SERVICE_PID;
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
            this.configurationService.deleteFactoryConfiguration(pid, false);
            this.configurationService.deleteFactoryConfiguration(dataServicePid, false);
            this.configurationService.deleteFactoryConfiguration(dataTransportServicePid, true);
        }
    }

    public List<String> getStackComponentsPids(String pid) throws KuraException {
        ArrayList<String> componentPids = new ArrayList<String>();
        String[] parts = pid.split("-");
        if (parts.length != 0 && CLOUD_SERVICE_PID.equals(parts[0])) {
            String suffix = null;
            if (parts.length > 1) {
                suffix = parts[1];
            }
            String dataServicePid = DATA_SERVICE_PID;
            String dataTransportServicePid = DATA_TRANSPORT_SERVICE_PID;
            if (suffix != null) {
                dataServicePid = String.valueOf(dataServicePid) + "-" + suffix;
                dataTransportServicePid = String.valueOf(dataTransportServicePid) + "-" + suffix;
            }
            componentPids.add(pid);
            componentPids.add(dataServicePid);
            componentPids.add(dataTransportServicePid);
            return componentPids;
        }
        throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Invalid PID '{}'", pid});
    }

    public Set<String> getManagedCloudConnectionPids() throws KuraException {
        BundleContext context = FrameworkUtil.getBundle(RawMqttCloudConnectionFactory.class).getBundleContext();
        try {
            return context.getServiceReferences(CloudEndpoint.class, null).stream().filter(ref -> {
                Object kuraServicePid = ref.getProperty("kura.service.pid");
                if (!(kuraServicePid instanceof String)) {
                    return false;
                }
                return MANAGED_CLOUD_SERVICE_PID_PATTERN.matcher((String)kuraServicePid).matches() && FACTORY_PID.equals(ref.getProperty("kura.cloud.connection.factory.pid"));
            }).map(ref -> (String)ref.getProperty("kura.service.pid")).collect(Collectors.toSet());
        }
        catch (InvalidSyntaxException e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, (Throwable)e, new Object[0]);
        }
    }
}

