/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.kura.core.system.SuperSystemService;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.system.SystemAdminService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAdminServiceImpl
extends SuperSystemService
implements SystemAdminService {
    private static final Logger logger = LoggerFactory.getLogger(SystemAdminServiceImpl.class);
    private static final String OS_LINUX = "Linux";
    private static final String OS_MAC_OSX = "Mac OS X";
    private static final String OS_WINDOWS = "windows";
    private static final String UNKNOWN = "UNKNOWN";
    private ComponentContext ctx;
    private CommandExecutorService executorService;

    public void setExecutorService(CommandExecutorService executorService) {
        this.executorService = executorService;
    }

    public void unsetExecutorService(CommandExecutorService executorService) {
        this.executorService = null;
    }

    protected void activate(ComponentContext componentContext) {
        this.ctx = componentContext;
    }

    protected void deactivate(ComponentContext componentContext) {
        this.ctx = null;
    }

    public String getUptime() {
        String uptimeStr;
        block34: {
            uptimeStr = UNKNOWN;
            long uptime = 0L;
            if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) {
                try {
                    String[] lastBootUpTime = SystemAdminServiceImpl.runSystemCommand("wmic os get LastBootUpTime ", false, this.executorService).split("\n");
                    if (lastBootUpTime[0].toLowerCase().startsWith("lastbootuptime")) {
                        String lastBoot = lastBootUpTime[2];
                        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date bootDate = df.parse(lastBoot);
                        uptime = System.currentTimeMillis() - bootDate.getTime();
                        uptimeStr = Long.toString(uptime);
                    }
                }
                catch (Exception e) {
                    uptimeStr = "0";
                    logger.error("Could not read uptime", (Throwable)e);
                }
            } else if (OS_LINUX.equals(this.getOsName())) {
                InputStreamReader fr = null;
                BufferedReader br = null;
                try {
                    try {
                        File file = new File("/proc/uptime");
                        fr = new FileReader(file);
                        br = new BufferedReader(fr);
                        String line = br.readLine();
                        if (line != null) {
                            uptime = (long)(Double.parseDouble(line.substring(0, line.indexOf(" "))) * 1000.0);
                            uptimeStr = Long.toString(uptime);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Could not read uptime", (Throwable)e);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fr != null) {
                            try {
                                fr.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
            } else if (OS_MAC_OSX.equals(this.getOsName())) {
                try {
                    String lastBootupSysCmd = SystemAdminServiceImpl.runSystemCommand("sysctl -n kern.boottime", false, this.executorService);
                    if (!lastBootupSysCmd.isEmpty()) {
                        String[] uptimePairs = lastBootupSysCmd.substring(1, lastBootupSysCmd.indexOf("}")).replace(" ", "").split(",");
                        String[] uptimeSeconds = uptimePairs[0].split("=");
                        uptime = System.currentTimeMillis() - (long)Double.parseDouble(uptimeSeconds[1]);
                        uptimeStr = Long.toString(uptime);
                    }
                }
                catch (Exception e) {
                    uptimeStr = "0";
                    logger.error("Could not read uptime", (Throwable)e);
                }
            }
        }
        return uptimeStr;
    }

    public void reboot() {
        if (OS_LINUX.equals(this.getOsName()) || OS_MAC_OSX.equals(this.getOsName())) {
            this.executeCommand(new String[]{"reboot"});
        } else if (this.getOsName().toLowerCase().startsWith(OS_WINDOWS)) {
            this.executeCommand(new String[]{"shutdown", "-r"});
        } else {
            logger.error("Unsupported OS for reboot()");
        }
    }

    public void sync() {
        if (OS_LINUX.equals(this.getOsName()) || OS_MAC_OSX.equals(this.getOsName())) {
            this.executeCommand(new String[]{"sync"});
        } else {
            logger.error("Unsupported OS for sync()");
        }
    }

    private void executeCommand(String[] cmd) {
        Command command = new Command(cmd);
        command.setTimeout(60);
        CommandStatus status = this.executorService.execute(command);
        if (status.getExitStatus().isSuccessful()) {
            logger.error("failed to issue {} command", (Object)cmd[0]);
        }
    }

    private String getOsName() {
        return System.getProperty("os.name");
    }
}

