/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Arrays;
import org.eclipse.kura.core.inventory.resources.SystemBundle;
import org.eclipse.kura.core.inventory.resources.SystemBundles;

public class JsonJavaSystemBundlesMapper {
    private static final String SYSTEM_BUNDLES = "bundles";
    private static final String SYSTEM_BUNDLES_NAME = "name";
    private static final String SYSTEM_BUNDLES_VERSION = "version";
    private static final String SYSTEM_BUNDLES_ID = "id";
    private static final String SYSTEM_BUNDLES_STATE = "state";
    private static final String SYSTEM_BUNDLES_SIGNED = "signed";

    private JsonJavaSystemBundlesMapper() {
    }

    public static String marshal(SystemBundles systemBundles) {
        JsonObject json = Json.object();
        JsonArray bundles = new JsonArray();
        Arrays.asList(systemBundles.getBundles()).stream().forEach(sb -> {
            JsonArray jsonArray2 = bundles.add((JsonValue)JsonJavaSystemBundlesMapper.getJsonBundle(sb));
        });
        json.add(SYSTEM_BUNDLES, (JsonValue)bundles);
        return json.toString();
    }

    private static JsonObject getJsonBundle(SystemBundle sb) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(SYSTEM_BUNDLES_NAME, sb.getName());
        jsonObject.add(SYSTEM_BUNDLES_VERSION, sb.getVersion());
        jsonObject.add(SYSTEM_BUNDLES_ID, sb.getId());
        jsonObject.add(SYSTEM_BUNDLES_STATE, sb.getState());
        jsonObject.add(SYSTEM_BUNDLES_SIGNED, sb.isSigned());
        return jsonObject;
    }
}

