/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.service.GwtEventService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtEventServiceImpl
extends OsgiRemoteServiceServlet
implements GwtEventService,
EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(GwtEventServiceImpl.class);
    private static final long serialVersionUID = 4948177265652519828L;
    private static final int MAX_EVENT_COUNT = 50;
    private final ArrayList<String> topics = new ArrayList();
    private final Deque<GwtEventInfo> events = new LinkedList<GwtEventInfo>();
    private ServiceRegistration<EventHandler> registration;
    private boolean shutdown = false;

    public void destroy() {
        logger.info("destroying GwtEventService...");
        super.destroy();
        logger.info("destroying GwtEventService...done");
    }

    public GwtEventServiceImpl() {
        ForwardedEventTopic[] forwardedEventTopicArray = ForwardedEventTopic.values();
        int n = forwardedEventTopicArray.length;
        int n2 = 0;
        while (n2 < n) {
            ForwardedEventTopic topic = forwardedEventTopicArray[n2];
            this.topics.add(topic.toString());
            ++n2;
        }
    }

    public synchronized void handleEvent(Event event) {
        GwtEventInfo eventInfo = this.serialize(event);
        if (this.events.size() >= 50) {
            this.events.removeLast();
        }
        this.events.push(eventInfo);
        this.notifyAll();
    }

    private List<GwtEventInfo> getEvents(long fromTimestamp) {
        LinkedList<GwtEventInfo> result = new LinkedList<GwtEventInfo>();
        for (GwtEventInfo next : this.events) {
            String eventSession;
            String currentSession;
            if (next.getTopic().equals("org/eclipse/kura/core/configuration/event/CONF_CHANGE_EVENT_TOPIC") && this.getThreadLocalRequest().getSession(false) != null && (currentSession = this.getThreadLocalRequest().getSession().getId()).equals(eventSession = (String)next.get("session"))) break;
            if (Long.parseLong(next.getTimestamp()) <= fromTimestamp) continue;
            result.push(next);
        }
        return result;
    }

    public void start() {
        Hashtable<String, String[]> map = new Hashtable<String, String[]>();
        ((Dictionary)map).put("event.topics", this.topics.toArray(new String[this.topics.size()]));
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.registration = bundleContext.registerService(EventHandler.class, (Object)this, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        logger.info("stopping GwtEventService...");
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        GwtEventServiceImpl gwtEventServiceImpl = this;
        synchronized (gwtEventServiceImpl) {
            this.shutdown = true;
            this.notifyAll();
        }
        logger.info("stopping GwtEventService...done");
    }

    @Override
    public synchronized List<GwtEventInfo> getNextEvents(String fromTimestamp) {
        long timestamp = Long.parseLong(fromTimestamp);
        List<GwtEventInfo> result = this.getEvents(timestamp);
        if (!result.isEmpty()) {
            return result;
        }
        if (!this.shutdown) {
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                return new LinkedList<GwtEventInfo>();
            }
        }
        return this.getEvents(timestamp);
    }

    @Override
    public synchronized String getLastEventTimestamp() {
        if (this.events.isEmpty()) {
            return "0";
        }
        return this.events.getFirst().getTimestamp();
    }

    public GwtEventInfo serialize(Event event) {
        GwtEventInfo result = new GwtEventInfo(event.getTopic());
        String[] stringArray = event.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (!"event".equals(property)) {
                Object obj = event.getProperty(property);
                result.set(property, obj != null ? obj.toString() : null);
            }
            ++n2;
        }
        return result;
    }
}

