/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.crypto.CryptoService;

public class SelfConfiguringComponentProperty<T> {
    private static final Pattern COMMA = Pattern.compile(",");
    private final Tad ad;
    private final Class<?> valueType;
    private final Optional<CryptoService> cryptoService;
    private Optional<T> value;

    public SelfConfiguringComponentProperty(Tad ad, Class<T> classz, CryptoService cryptoService) {
        this(ad, classz, Optional.of(cryptoService));
    }

    public SelfConfiguringComponentProperty(Tad ad, Class<T> classz) {
        this(ad, classz, Optional.empty());
    }

    private SelfConfiguringComponentProperty(Tad ad, Class<T> classz, Optional<CryptoService> cryptoService) {
        this.ad = ad;
        this.cryptoService = cryptoService;
        this.valueType = classz;
        SelfConfiguringComponentProperty.check(ad.getType(), ad.getCardinality(), classz);
        this.value = this.extractDefault((AD)ad);
    }

    public Tad getAd() {
        return this.ad;
    }

    public void fillValue(Map<String, Object> properties) {
        if (this.value.isPresent() && !properties.containsKey(this.ad.getId())) {
            if (this.ad.getType() == Scalar.PASSWORD) {
                properties.put(this.ad.getId(), new Password(this.value.get().toString().toCharArray()));
            } else {
                properties.put(this.ad.getId(), this.value.get());
            }
        }
    }

    public void update(Map<String, Object> properties) {
        Object providedValue = properties.get(this.ad.getId());
        if (this.valueType.isInstance(providedValue)) {
            this.value = Optional.of(providedValue);
        } else if (this.ad.getType() == Scalar.PASSWORD && providedValue instanceof Password) {
            Password providedPassword = (Password)providedValue;
            this.value = Optional.of(new String(providedPassword.getPassword()));
        }
    }

    public T get() {
        return this.value.orElseThrow(() -> new IllegalStateException("property value has not been set"));
    }

    public Optional<T> getOptional() {
        return this.value;
    }

    private static void check(Scalar scalar, int cardinality, Class<?> clazz) {
        Class expected;
        if (scalar == Scalar.BOOLEAN) {
            expected = Boolean.class;
        } else if (scalar == Scalar.BYTE) {
            expected = Byte.class;
        } else if (scalar == Scalar.CHAR) {
            expected = Character.class;
        } else if (scalar == Scalar.DOUBLE) {
            expected = Double.class;
        } else if (scalar == Scalar.FLOAT) {
            expected = Float.class;
        } else if (scalar == Scalar.INTEGER) {
            expected = Integer.class;
        } else if (scalar == Scalar.LONG) {
            expected = Long.class;
        } else if (scalar == Scalar.PASSWORD) {
            expected = String.class;
        } else if (scalar == Scalar.SHORT) {
            expected = Short.class;
        } else if (scalar == Scalar.STRING) {
            expected = String.class;
        } else {
            throw new IllegalArgumentException(scalar == null ? null : scalar.toString());
        }
        if (cardinality != 0) {
            if (!clazz.isArray()) {
                throw new IllegalArgumentException("class must be an array");
            }
            if (clazz.getComponentType() != expected) {
                throw new IllegalArgumentException("AD type mismatch");
            }
        } else if (clazz != expected) {
            throw new IllegalArgumentException("AD type mismatch");
        }
    }

    private Object extractScalar(Scalar scalar, String value) {
        if (scalar == Scalar.BOOLEAN) {
            return Boolean.parseBoolean(value);
        }
        if (scalar == Scalar.BYTE) {
            return Boolean.parseBoolean(value);
        }
        if (scalar == Scalar.CHAR) {
            return Character.valueOf(value.charAt(0));
        }
        if (scalar == Scalar.DOUBLE) {
            return Double.parseDouble(value);
        }
        if (scalar == Scalar.FLOAT) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (scalar == Scalar.INTEGER) {
            return Integer.parseInt(value);
        }
        if (scalar == Scalar.LONG) {
            return Long.parseLong(value);
        }
        if (scalar == Scalar.PASSWORD) {
            try {
                return new String(this.unwrapCryptoService().encryptAes(value.toCharArray()));
            }
            catch (KuraException e) {
                throw new IllegalStateException("failed to encrypt password", e);
            }
        }
        if (scalar == Scalar.SHORT) {
            return Short.parseShort(value);
        }
        if (scalar == Scalar.STRING) {
            return value;
        }
        throw new IllegalArgumentException(scalar == null ? null : scalar.toString());
    }

    private CryptoService unwrapCryptoService() {
        if (!this.cryptoService.isPresent()) {
            throw new IllegalArgumentException("CryptoService is required for defining a password property");
        }
        return this.cryptoService.get();
    }

    private Optional<T> extractDefault(AD ad) {
        String defaultValue = ad.getDefault();
        if (defaultValue == null) {
            return Optional.empty();
        }
        Scalar scalar = ad.getType();
        int cardinality = ad.getCardinality();
        if (cardinality == 0) {
            return Optional.of(this.extractScalar(scalar, defaultValue));
        }
        List result = COMMA.splitAsStream(defaultValue).map(String::trim).filter(String::isEmpty).map(s -> this.extractScalar(scalar, (String)s)).collect(Collectors.toList());
        return Optional.of(result.toArray());
    }
}

