/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressConfigImpl;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemConnectionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModemConfigurationInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(ModemConfigurationInterpreter.class);
    private static final String NET_INTERFACE = "net.interface.";
    private static final Boolean DEFAULT_PERSIST_VALUE = true;
    private static final Integer DEFAULT_MAXFAIL_VALUE = 5;
    private static final Integer DEFAULT_RESET_TIMEOUT_VALUE = 5;
    private static final Integer DEFAULT_IDLE_VALUE = 95;
    private static final String DEFAULT_ACTIVE_FILTER_VALUE = "inbound";
    private static final Integer DEFAULT_LCP_ECHO_FAILURE_VALUE = 0;
    private static final Integer DEFAULT_LCP_ECHO_INTERVAL_VALUE = 0;
    private static final Boolean DEFAULT_GPS_ENABLED_VALUE = false;
    private static final Boolean DEFAULT_DIVERSITY_ENABLED_VALUE = false;
    private static final Boolean DEFAULT_ENABLED_VALUE = false;
    private static final Integer DEFAULT_PROFILE_ID_VALUE = 0;
    private static final Integer DEFAULT_DATA_COMPRESSION_VALUE = 0;
    private static final Integer DEFAULT_HEADER_COMPRESSION_VALUE = 0;

    private ModemConfigurationInterpreter() {
    }

    public static List<NetConfig> populateConfiguration(NetInterfaceAddressConfig netInterfaceAddress, Map<String, Object> props, String interfaceName, int pppNum) throws KuraException {
        String configConnStatus;
        ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
        if (Objects.isNull(props)) {
            return netConfigs;
        }
        StringBuilder sbPrefix = new StringBuilder();
        sbPrefix.append(NET_INTERFACE).append(interfaceName).append(".");
        String netIfPrefix = sbPrefix.append("config.").toString();
        ModemInterfaceAddressConfigImpl modemInterfaceAddressImpl = (ModemInterfaceAddressConfigImpl)netInterfaceAddress;
        String configConnType = String.valueOf(netIfPrefix) + "connection.type";
        if (props.containsKey(configConnType)) {
            ModemConnectionType connType = ModemConnectionType.PPP;
            String connTypeStr = (String)props.get(configConnType);
            if (connTypeStr != null && !connTypeStr.isEmpty()) {
                connType = ModemConnectionType.valueOf((String)connTypeStr);
            }
            logger.trace("Adding modem connection type: {}", (Object)connType);
            modemInterfaceAddressImpl.setConnectionType(connType);
        }
        if (props.containsKey(configConnStatus = String.valueOf(netIfPrefix) + "connection.status")) {
            ModemConnectionStatus connStatus = ModemConnectionStatus.UNKNOWN;
            String connStatusStr = (String)props.get(configConnStatus);
            if (connStatusStr != null && !connStatusStr.isEmpty()) {
                connStatus = ModemConnectionStatus.valueOf((String)connStatusStr);
            }
            logger.trace("Adding modem connection status: {}", (Object)connStatus);
            modemInterfaceAddressImpl.setConnectionStatus(connStatus);
        }
        ModemConfig modemConfig = ModemConfigurationInterpreter.getModemConfig(netIfPrefix, props);
        modemConfig.setPppNumber(pppNum);
        netConfigs.add((NetConfig)modemConfig);
        return netConfigs;
    }

    private static ModemConfig getModemConfig(String prefix, Map<String, Object> properties) throws KuraException {
        ModemConfig modemConfig = new ModemConfig();
        modemConfig.setApn(ModemConfigurationInterpreter.getApn(prefix, properties));
        modemConfig.setAuthType(ModemConfigurationInterpreter.getAuthenticationType(prefix, properties));
        modemConfig.setDataCompression(ModemConfigurationInterpreter.getDataCompression(prefix, properties));
        modemConfig.setDialString(ModemConfigurationInterpreter.getDialString(prefix, properties));
        modemConfig.setHeaderCompression(ModemConfigurationInterpreter.getHeaderCompression(prefix, properties));
        modemConfig.setIpAddress(ModemConfigurationInterpreter.getIpAddress(prefix, properties));
        modemConfig.setPassword(ModemConfigurationInterpreter.getPassword(prefix, properties));
        modemConfig.setPdpType(ModemConfigurationInterpreter.getPdpType(prefix, properties));
        modemConfig.setProfileID(ModemConfigurationInterpreter.getProfileId(prefix, properties));
        modemConfig.setPersist(ModemConfigurationInterpreter.isPersist(prefix, properties));
        modemConfig.setMaxFail(ModemConfigurationInterpreter.getMaximumFailures(prefix, properties));
        modemConfig.setResetTimeout(ModemConfigurationInterpreter.getResetTimeout(prefix, properties));
        modemConfig.setIdle(ModemConfigurationInterpreter.getIdle(prefix, properties));
        modemConfig.setActiveFilter(ModemConfigurationInterpreter.getActiveFilter(prefix, properties));
        modemConfig.setLcpEchoInterval(ModemConfigurationInterpreter.getLcpEchoInterval(prefix, properties));
        modemConfig.setLcpEchoFailure(ModemConfigurationInterpreter.getLcpEchoFailure(prefix, properties));
        modemConfig.setUsername((String)properties.get(String.valueOf(prefix) + "username"));
        modemConfig.setEnabled(ModemConfigurationInterpreter.isEnabled(prefix, properties));
        modemConfig.setGpsEnabled(ModemConfigurationInterpreter.isGpsEnabled(prefix, properties));
        modemConfig.setDiversityEnabled(ModemConfigurationInterpreter.isDiversityEnabled(prefix, properties));
        return modemConfig;
    }

    private static boolean isGpsEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "gpsEnabled";
        Object value = properties.getOrDefault(key, DEFAULT_GPS_ENABLED_VALUE);
        return value != null ? (Boolean)value : DEFAULT_GPS_ENABLED_VALUE;
    }

    private static boolean isDiversityEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "diversityEnabled";
        Object value = properties.getOrDefault(key, DEFAULT_DIVERSITY_ENABLED_VALUE);
        return value != null ? (Boolean)value : DEFAULT_DIVERSITY_ENABLED_VALUE;
    }

    private static boolean isEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "enabled";
        Object value = properties.getOrDefault(key, DEFAULT_ENABLED_VALUE);
        return value != null ? (Boolean)value : DEFAULT_ENABLED_VALUE;
    }

    private static int getLcpEchoFailure(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "lcpEchoFailure";
        Object value = properties.getOrDefault(key, DEFAULT_LCP_ECHO_FAILURE_VALUE);
        return value != null ? (Integer)value : DEFAULT_LCP_ECHO_FAILURE_VALUE;
    }

    private static int getLcpEchoInterval(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "lcpEchoInterval";
        Object value = properties.getOrDefault(key, DEFAULT_LCP_ECHO_INTERVAL_VALUE);
        return value != null ? (Integer)value : DEFAULT_LCP_ECHO_INTERVAL_VALUE;
    }

    private static String getActiveFilter(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "activeFilter";
        Object value = properties.getOrDefault(key, DEFAULT_ACTIVE_FILTER_VALUE);
        return value != null ? (String)value : DEFAULT_ACTIVE_FILTER_VALUE;
    }

    private static int getIdle(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "idle";
        Object value = properties.getOrDefault(key, DEFAULT_IDLE_VALUE);
        return value != null ? (Integer)value : DEFAULT_IDLE_VALUE;
    }

    private static int getResetTimeout(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "resetTimeout";
        Object value = properties.getOrDefault(key, DEFAULT_RESET_TIMEOUT_VALUE);
        return value != null ? (Integer)value : DEFAULT_RESET_TIMEOUT_VALUE;
    }

    private static int getMaximumFailures(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "maxFail";
        Object value = properties.getOrDefault(key, DEFAULT_MAXFAIL_VALUE);
        return value != null ? (Integer)value : DEFAULT_MAXFAIL_VALUE;
    }

    private static boolean isPersist(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "persist";
        Object value = properties.getOrDefault(key, DEFAULT_PERSIST_VALUE);
        return value != null ? (Boolean)value : DEFAULT_PERSIST_VALUE;
    }

    private static int getProfileId(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "profileId";
        Object value = properties.getOrDefault(key, DEFAULT_PROFILE_ID_VALUE);
        return value != null ? (Integer)value : DEFAULT_PROFILE_ID_VALUE;
    }

    private static ModemConfig.PdpType getPdpType(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "pdpType";
        Object value = properties.getOrDefault(key, ModemConfig.PdpType.IP.name());
        return value != null ? ModemConfigurationInterpreter.parsePdpType((String)value) : ModemConfig.PdpType.IP;
    }

    private static ModemConfig.PdpType parsePdpType(String pdpTypeString) {
        ModemConfig.PdpType pdpType = ModemConfig.PdpType.UNKNOWN;
        try {
            pdpType = ModemConfig.PdpType.valueOf((String)pdpTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pdpType = ModemConfig.PdpType.IP;
        }
        return pdpType;
    }

    private static Password getPassword(String prefix, Map<String, Object> properties) throws KuraException {
        Password password = null;
        String key = String.valueOf(prefix) + "password";
        Object psswdObj = properties.get(key);
        if (psswdObj instanceof Password) {
            password = (Password)psswdObj;
        } else if (psswdObj instanceof String) {
            password = new Password((String)psswdObj);
        } else if (psswdObj == null) {
            password = new Password("");
        } else {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Invalid password type.", key, psswdObj.getClass()});
        }
        return password;
    }

    private static IPAddress getIpAddress(String prefix, Map<String, Object> properties) throws KuraException {
        String ipAddressString = (String)properties.get(String.valueOf(prefix) + "ipAddress");
        IPAddress ipAddress = null;
        logger.trace("IP address is {}", (Object)ipAddressString);
        if (ipAddressString != null && !ipAddressString.isEmpty()) {
            ipAddress = ModemConfigurationInterpreter.parseIpAddress(ipAddressString);
        } else {
            logger.trace("IP address is null");
        }
        return ipAddress;
    }

    private static IPAddress parseIpAddress(String ipAddressString) throws KuraException {
        try {
            return IPAddress.parseHostAddress((String)ipAddressString);
        }
        catch (UnknownHostException unknownHostException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Could not parse ip address " + ipAddressString});
        }
    }

    private static int getHeaderCompression(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "headerCompression";
        Object value = properties.getOrDefault(key, DEFAULT_HEADER_COMPRESSION_VALUE);
        return value != null ? (Integer)value : DEFAULT_HEADER_COMPRESSION_VALUE;
    }

    private static String getDialString(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "dialString";
        return (String)properties.get(key);
    }

    private static int getDataCompression(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "dataCompression";
        Object value = properties.getOrDefault(key, DEFAULT_DATA_COMPRESSION_VALUE);
        return value != null ? (Integer)value : DEFAULT_DATA_COMPRESSION_VALUE;
    }

    private static ModemConfig.AuthType getAuthenticationType(String prefix, Map<String, Object> properties) throws KuraException {
        ModemConfig.AuthType authType;
        String key = String.valueOf(prefix) + "authType";
        String authTypeString = (String)properties.get(key);
        logger.trace("Auth type is {}", (Object)authTypeString);
        if (authTypeString != null && !authTypeString.isEmpty()) {
            authType = ModemConfigurationInterpreter.parseAuthenticationType(authTypeString);
        } else {
            logger.trace("Auth type is null");
            authType = ModemConfig.AuthType.NONE;
        }
        return authType;
    }

    private static ModemConfig.AuthType parseAuthenticationType(String authTypeString) throws KuraException {
        ModemConfig.AuthType authType = ModemConfig.AuthType.NONE;
        try {
            authType = ModemConfig.AuthType.valueOf((String)authTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Could not parse auth type " + authTypeString});
        }
        return authType;
    }

    private static String getApn(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "apn";
        return (String)properties.get(key);
    }
}

