/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth;

import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.BluetoothAdapter;
import org.eclipse.kura.bluetooth.BluetoothBeaconCommandListener;
import org.eclipse.kura.bluetooth.BluetoothService;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.linux.bluetooth.BluetoothAdapterImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothServiceImpl
implements BluetoothService {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothServiceImpl.class);
    private static ComponentContext componentContext;
    private CommandExecutorService executorService;

    public void setExecutorService(CommandExecutorService executorService) {
        this.executorService = executorService;
    }

    public void unsetExecutorService(CommandExecutorService executorService) {
        this.executorService = null;
    }

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Service...");
        componentContext = context;
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Service...");
    }

    public BluetoothAdapter getBluetoothAdapter() {
        return this.getBluetoothAdapter("hci0");
    }

    public BluetoothAdapter getBluetoothAdapter(String name) {
        try {
            return new BluetoothAdapterImpl(name, this.executorService);
        }
        catch (KuraException e) {
            logger.error("Could not get bluetooth adapter", (Throwable)e);
            return null;
        }
    }

    public BluetoothAdapter getBluetoothAdapter(String name, BluetoothBeaconCommandListener bbcl) {
        try {
            return new BluetoothAdapterImpl(name, bbcl, this.executorService);
        }
        catch (KuraException e) {
            logger.error("Could not get bluetooth beacon service", (Throwable)e);
            return null;
        }
    }

    public static BundleContext getBundleContext() {
        return componentContext.getBundleContext();
    }
}

