/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration.provider.impl;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public class ContainerOrchestrationServiceOptions {
    private static final Property<Boolean> IS_ENABLED = new Property("enabled", (Object)false);
    private static final Property<String> DOCKER_HOST_URL = new Property("container.engine.host", (Object)"unix:///var/run/docker.sock");
    private final boolean enabled;
    private final String hostUrl;

    public ContainerOrchestrationServiceOptions(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("Properties cannot be null!");
        }
        this.enabled = (Boolean)IS_ENABLED.get(properties);
        this.hostUrl = (String)DOCKER_HOST_URL.get(properties);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHostUrl() {
        return this.hostUrl;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.hostUrl);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerOrchestrationServiceOptions other = (ContainerOrchestrationServiceOptions)obj;
        return this.isEnabled() == other.isEnabled() && Objects.equals(this.getHostUrl(), other.getHostUrl());
    }
}

