/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble;

import com.github.hypfvieh.bluetooth.DeviceManager;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattCharacteristic;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.kura.KuraBluetoothIOException;
import org.eclipse.kura.KuraBluetoothNotificationException;
import org.eclipse.kura.KuraBluetoothResourceNotFoundException;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristic;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattCharacteristicProperties;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattDescriptor;
import org.eclipse.kura.bluetooth.le.BluetoothLeGattService;
import org.eclipse.kura.internal.ble.BluetoothLeGattDescriptorImpl;
import org.eclipse.kura.internal.ble.BluetoothLeGattServiceImpl;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.handlers.AbstractPropertiesChangedHandler;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;

public class BluetoothLeGattCharacteristicImpl
implements BluetoothLeGattCharacteristic {
    private final BluetoothGattCharacteristic characteristic;

    public BluetoothLeGattCharacteristicImpl(BluetoothGattCharacteristic characteristic) {
        this.characteristic = characteristic;
    }

    public BluetoothLeGattDescriptor findDescriptor(UUID uuid) throws KuraBluetoothResourceNotFoundException {
        BluetoothGattDescriptor descriptor = this.characteristic.getGattDescriptorByUuid(uuid.toString());
        if (descriptor != null) {
            return new BluetoothLeGattDescriptorImpl(descriptor);
        }
        throw new KuraBluetoothResourceNotFoundException((Object)"Descriptor not found");
    }

    public BluetoothLeGattDescriptor findDescriptor(UUID uuid, long timeout) throws KuraBluetoothResourceNotFoundException {
        return this.findDescriptor(uuid);
    }

    public List<BluetoothLeGattDescriptor> findDescriptors() throws KuraBluetoothResourceNotFoundException {
        List descriptorList = this.characteristic.getGattDescriptors();
        ArrayList<BluetoothLeGattDescriptor> descriptors = new ArrayList<BluetoothLeGattDescriptor>();
        if (descriptorList != null) {
            for (BluetoothGattDescriptor descriptor : descriptorList) {
                descriptors.add(new BluetoothLeGattDescriptorImpl(descriptor));
            }
        } else {
            throw new KuraBluetoothResourceNotFoundException((Object)"Descriptors not found");
        }
        return descriptors;
    }

    public byte[] readValue() throws KuraBluetoothIOException {
        byte[] value;
        try {
            value = this.characteristic.readValue(null);
        }
        catch (DBusException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Read characteristic value failed");
        }
        return value;
    }

    public void enableValueNotifications(final Consumer<byte[]> callback) throws KuraBluetoothNotificationException {
        try {
            this.getDeviceManager().registerPropertyHandler(new AbstractPropertiesChangedHandler(){

                public void handle(Properties.PropertiesChanged props) {
                    BluetoothLeGattCharacteristicImpl.this.handleValueNotification(callback, props);
                }
            });
            this.characteristic.startNotify();
        }
        catch (DBusException e) {
            throw new KuraBluetoothNotificationException((Throwable)e, (Object)"Notification can't be enabled");
        }
    }

    private void handleValueNotification(Consumer<byte[]> callback, Properties.PropertiesChanged props) {
        if (props != null) {
            if (!props.getPath().contains(this.characteristic.getDbusPath())) {
                return;
            }
            for (Map.Entry entry : props.getPropertiesChanged().entrySet()) {
                byte[] value;
                if (!((String)entry.getKey()).equals("Value") || (value = (byte[])((Variant)props.getPropertiesChanged().get("Value")).getValue()) == null) continue;
                callback.accept(value);
            }
        }
    }

    public void disableValueNotifications() throws KuraBluetoothNotificationException {
        try {
            this.characteristic.stopNotify();
        }
        catch (DBusException e) {
            throw new KuraBluetoothNotificationException((Throwable)e, (Object)"Notification can't be disabled");
        }
    }

    public void writeValue(byte[] value) throws KuraBluetoothIOException {
        try {
            this.characteristic.writeValue(value, null);
        }
        catch (DBusException e) {
            throw new KuraBluetoothIOException((Throwable)e, (Object)"Write characteristic value failed");
        }
    }

    public UUID getUUID() {
        String uuid = this.characteristic.getUuid();
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    public BluetoothLeGattService getService() {
        return new BluetoothLeGattServiceImpl(this.characteristic.getService());
    }

    public byte[] getValue() {
        return this.characteristic.getValue();
    }

    public boolean isNotifying() {
        Boolean notifying = this.characteristic.isNotifying();
        if (notifying != null) {
            return notifying;
        }
        return false;
    }

    public List<BluetoothLeGattCharacteristicProperties> getProperties() {
        ArrayList<BluetoothLeGattCharacteristicProperties> properties = new ArrayList<BluetoothLeGattCharacteristicProperties>();
        for (String flag : this.characteristic.getFlags()) {
            properties.add(BluetoothLeGattCharacteristicProperties.valueOf((String)flag.toUpperCase()));
        }
        return properties;
    }

    public DeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }
}

