/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.internal.wire.WireComponentTrackerCustomizer;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.util.service.ServiceUtil;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.graph.Constants;
import org.eclipse.kura.wire.graph.MultiportWireConfiguration;
import org.eclipse.kura.wire.graph.WireComponentConfiguration;
import org.eclipse.kura.wire.graph.WireGraphConfiguration;
import org.eclipse.kura.wire.graph.WireGraphService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireGraphServiceImpl
implements ConfigurableComponent,
WireGraphService {
    private static final String WIRE_ASSET_FACTORY_PID = "org.eclipse.kura.wire.WireAsset";
    private static final String NEW_WIRE_GRAPH_PROPERTY = "WireGraph";
    private static final String CONF_PID = "org.eclipse.kura.wire.graph.WireGraphService";
    private static final Logger logger = LoggerFactory.getLogger(WireGraphServiceImpl.class);
    private volatile WireAdmin wireAdmin;
    private ServiceTracker<WireComponent, WireComponent> wireComponentServiceTracker;
    private ConfigurationService configurationService;
    private BundleContext bundleContext;
    private WireGraphConfiguration currentConfiguration;
    private static final Filter WIRE_COMPONENT_FILTER = WireGraphServiceImpl.getWireComponentConfigurationFilter();

    public void bindWireAdmin(WireAdmin wireAdmin) {
        if (Objects.isNull(this.wireAdmin)) {
            this.wireAdmin = wireAdmin;
        }
    }

    public void unbindWireAdmin(WireAdmin wireAdmin) {
        if (this.wireAdmin == wireAdmin) {
            this.wireAdmin = null;
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("Activating Wire Service...");
        this.bundleContext = componentContext.getBundleContext();
        this.updated(properties);
        logger.info("Activating Wire Service...Done");
    }

    public synchronized void updated(Map<String, Object> properties) {
        try {
            logger.info("Updating Wire Graph Service Component...");
            this.currentConfiguration = this.loadWireGraphConfiguration(properties);
            if (this.wireComponentServiceTracker == null) {
                logger.info("Opening Wire Component Service tracker...");
                WireComponentTrackerCustomizer wireComponentTrackerCustomizer = new WireComponentTrackerCustomizer(this.bundleContext, this);
                this.wireComponentServiceTracker = new ServiceTracker(this.bundleContext, WireComponent.class, (ServiceTrackerCustomizer)wireComponentTrackerCustomizer);
                this.wireComponentServiceTracker.open();
                logger.info("Opening Wire Component Service tracker...done");
            }
            this.createWires();
            logger.info("Updating Wire Service Component...Done");
        }
        catch (Exception e) {
            logger.warn("Failed to update WireGraphServiceImpl", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Deactivating Wire Service Component...");
        this.bundleContext = null;
        if (this.wireComponentServiceTracker != null) {
            this.wireComponentServiceTracker.close();
        }
        this.deleteAllWires();
        logger.info("Deactivating Wire Service Component...Done");
    }

    private boolean checkWireExistence(String emitterServicePid, String receiverServicePid, int emitterPort, int receiverPort) throws InvalidSyntaxException {
        Objects.requireNonNull(emitterServicePid, "Emitter Service PID cannot be null");
        Objects.requireNonNull(receiverServicePid, "Receiver Service PID cannot be null");
        Wire[] wires = this.wireAdmin.getWires(null);
        if (Objects.nonNull(wires)) {
            Wire[] wireArray = wires;
            int n = wires.length;
            int n2 = 0;
            while (n2 < n) {
                Wire w = wireArray[n2];
                try {
                    Dictionary props = w.getProperties();
                    if (emitterServicePid.equals(props.get("wireadmin.producer.pid")) && receiverServicePid.equals(props.get("wireadmin.consumer.pid")) && emitterPort == (Integer)props.get(Constants.WIRE_EMITTER_PORT_PROP_NAME.value()) && receiverPort == (Integer)props.get(Constants.WIRE_RECEIVER_PORT_PROP_NAME.value())) {
                        return true;
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return false;
    }

    private void createConfiguration(MultiportWireConfiguration conf) {
        Objects.requireNonNull(conf, "Wire Configuration cannot be null");
        String emitterPid = conf.getEmitterPid();
        String receiverPid = conf.getReceiverPid();
        try {
            boolean found;
            String emitterServicePid = this.getServicePidByKuraServicePid(emitterPid);
            String receiverServicePid = this.getServicePidByKuraServicePid(receiverPid);
            int emitterPort = conf.getEmitterPort();
            int receiverPort = conf.getReceiverPort();
            if (Objects.nonNull(emitterServicePid) && Objects.nonNull(receiverServicePid) && !(found = this.checkWireExistence(emitterServicePid, receiverServicePid, emitterPort, receiverPort))) {
                logger.info("Creating wire between {}/{} and {}/{}...", new Object[]{emitterPid, emitterPort, receiverPid, receiverPort});
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                ((Dictionary)properties).put(Constants.WIRE_EMITTER_PORT_PROP_NAME.value(), emitterPort);
                ((Dictionary)properties).put(Constants.WIRE_RECEIVER_PORT_PROP_NAME.value(), receiverPort);
                ((Dictionary)properties).put(Constants.EMITTER_KURA_SERVICE_PID_PROP_NAME.value(), emitterPid);
                ((Dictionary)properties).put(Constants.RECEIVER_KURA_SERVICE_PID_PROP_NAME.value(), receiverPid);
                Wire wire = this.wireAdmin.createWire(emitterServicePid, receiverServicePid, properties);
                conf.setWire(wire);
                logger.info("Creating wire.....Done");
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error("Error while creating wires...", (Throwable)e);
        }
    }

    public MultiportWireConfiguration createWireConfigurationInternal(String emitterPid, String receiverPid, int emitterPort, int receiverPort) throws KuraException {
        if (!emitterPid.equals(receiverPid)) {
            logger.info("Creating wire between {} and {}....", (Object)emitterPid, (Object)receiverPid);
            String emitterServicePid = this.getServicePidByKuraServicePid(emitterPid);
            String receiverServicePid = this.getServicePidByKuraServicePid(receiverPid);
            if (Objects.isNull(emitterServicePid) || Objects.isNull(receiverServicePid)) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Unable to retrieve Factory PIDs of one of the provided Wire Components"});
            }
            MultiportWireConfiguration conf = new MultiportWireConfiguration(emitterPid, receiverPid, emitterPort, receiverPort);
            WireGraphConfiguration wireGraphConfiguration = this.get();
            ArrayList<MultiportWireConfiguration> wireConfigurations = new ArrayList<MultiportWireConfiguration>(wireGraphConfiguration.getWireConfigurations());
            wireConfigurations.add(conf);
            this.update(new WireGraphConfiguration(wireGraphConfiguration.getWireComponentConfigurations(), wireConfigurations));
            logger.info("Creating wire between {} and {}....Done", (Object)emitterPid, (Object)receiverPid);
            return conf;
        }
        return null;
    }

    synchronized void createWires() {
        for (MultiportWireConfiguration wireConfig : this.currentConfiguration.getWireConfigurations()) {
            this.createConfiguration(wireConfig);
        }
    }

    private static MultiportWireConfiguration toWireConfiguration(Wire wire) {
        Dictionary wireProps = wire.getProperties();
        Object emitterKuraServicePid = wireProps.get(Constants.EMITTER_KURA_SERVICE_PID_PROP_NAME.value());
        Object receiverKuraServicePid = wireProps.get(Constants.RECEIVER_KURA_SERVICE_PID_PROP_NAME.value());
        Object emitterPort = wireProps.get(Constants.WIRE_EMITTER_PORT_PROP_NAME.value());
        Object receiverPort = wireProps.get(Constants.WIRE_RECEIVER_PORT_PROP_NAME.value());
        if (!(emitterKuraServicePid instanceof String && receiverKuraServicePid instanceof String && emitterPort instanceof Integer && receiverPort instanceof Integer)) {
            return null;
        }
        return new MultiportWireConfiguration((String)emitterKuraServicePid, (String)receiverKuraServicePid, ((Integer)emitterPort).intValue(), ((Integer)receiverPort).intValue());
    }

    private void deleteNoLongerExistingWires(Set<MultiportWireConfiguration> newWires, Set<String> componentsToDelete) {
        try {
            Wire[] wiresList = this.wireAdmin.getWires(null);
            if (wiresList == null) {
                return;
            }
            Wire[] wireArray = wiresList;
            int n = wiresList.length;
            int n2 = 0;
            while (n2 < n) {
                Wire osgiWire = wireArray[n2];
                MultiportWireConfiguration wire = WireGraphServiceImpl.toWireConfiguration(osgiWire);
                if (wire != null && (!newWires.contains(wire) || componentsToDelete.contains(wire.getEmitterPid()) || componentsToDelete.contains(wire.getReceiverPid()))) {
                    logger.info("Removing wire between {} and {} ...", (Object)wire.getEmitterPid(), (Object)wire.getReceiverPid());
                    this.wireAdmin.deleteWire(osgiWire);
                    logger.info("Removing wire between {} and {} ... done", (Object)wire.getEmitterPid(), (Object)wire.getReceiverPid());
                }
                ++n2;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    private void deleteAllWires() {
        try {
            Wire[] wires = this.wireAdmin.getWires(null);
            if (wires == null) {
                return;
            }
            Wire[] wireArray = wires;
            int n = wires.length;
            int n2 = 0;
            while (n2 < n) {
                Wire w = wireArray[n2];
                if (WireGraphServiceImpl.toWireConfiguration(w) != null) {
                    this.wireAdmin.deleteWire(w);
                }
                ++n2;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public synchronized void update(WireGraphConfiguration newConfiguration) throws KuraException {
        logger.info("Closing Wire Component Service tracker...");
        if (this.wireComponentServiceTracker != null) {
            this.wireComponentServiceTracker.close();
            this.wireComponentServiceTracker = null;
        }
        logger.info("Closing Wire Component Service tracker...done");
        WireGraphConfiguration currentGraphConfiguration = this.get();
        List currentWireComponents = currentGraphConfiguration.getWireComponentConfigurations();
        ArrayList<ComponentConfiguration> componentConfigurations = new ArrayList<ComponentConfiguration>();
        List newWireComponentConfigurations = newConfiguration.getWireComponentConfigurations();
        HashSet<MultiportWireConfiguration> newWires = new HashSet<MultiportWireConfiguration>(newConfiguration.getWireConfigurations());
        Set<String> componentsToDeletePids = this.getComponentsToDelete(currentWireComponents, newWireComponentConfigurations);
        for (String pid : componentsToDeletePids) {
            this.configurationService.deleteFactoryConfiguration(pid, false);
        }
        this.deleteNoLongerExistingWires(newWires, componentsToDeletePids);
        List<WireComponentConfiguration> componentsToCreate = this.getComponentsToCreate(currentWireComponents, newWireComponentConfigurations);
        ArrayList<String> createdPids = new ArrayList<String>();
        for (WireComponentConfiguration componentToCreate : componentsToCreate) {
            ComponentConfiguration configToCreate = componentToCreate.getConfiguration();
            Map wireComponentProps = componentToCreate.getProperties();
            Map configurationProps = configToCreate.getConfigurationProperties();
            String factoryPid = (String)configurationProps.get("service.factoryPid");
            configurationProps.put(Constants.RECEIVER_PORT_COUNT_PROP_NAME.value(), wireComponentProps.get("inputPortCount"));
            configurationProps.put(Constants.EMITTER_PORT_COUNT_PROP_NAME.value(), wireComponentProps.get("outputPortCount"));
            try {
                this.configurationService.createFactoryConfiguration(factoryPid, configToCreate.getPid(), configurationProps, false);
            }
            catch (Exception e) {
                this.deleteConfigurations(createdPids);
                throw e;
            }
            createdPids.add(configToCreate.getPid());
        }
        List<WireComponentConfiguration> componentsToUpdate = this.getComponentsToUpdate(newWireComponentConfigurations, componentsToCreate);
        for (WireComponentConfiguration componentToUpdate : componentsToUpdate) {
            componentConfigurations.add(componentToUpdate.getConfiguration());
        }
        String jsonConfig = this.marshal(newConfiguration);
        ComponentConfiguration wireGraphServiceComponentConfig = this.configurationService.getComponentConfiguration(CONF_PID);
        wireGraphServiceComponentConfig.getConfigurationProperties().put(NEW_WIRE_GRAPH_PROPERTY, jsonConfig);
        componentConfigurations.add(wireGraphServiceComponentConfig);
        this.configurationService.updateConfigurations(componentConfigurations, true);
    }

    private void deleteConfigurations(List<String> createdPids) {
        for (String createdPid : createdPids) {
            try {
                this.configurationService.deleteFactoryConfiguration(createdPid, false);
            }
            catch (Exception e1) {
                logger.debug("Failed to delete factory configuration", (Throwable)e1);
            }
        }
    }

    private List<WireComponentConfiguration> getComponentsToUpdate(List<WireComponentConfiguration> newWireComponentConfigurations, List<WireComponentConfiguration> newComponents) {
        ArrayList<WireComponentConfiguration> componentsToUpdate = new ArrayList<WireComponentConfiguration>();
        for (WireComponentConfiguration newWireComponentConfiguration : newWireComponentConfigurations) {
            if (newWireComponentConfiguration.getConfiguration().getConfigurationProperties() == null) continue;
            componentsToUpdate.add(newWireComponentConfiguration);
        }
        componentsToUpdate.removeAll(newComponents);
        return componentsToUpdate;
    }

    private List<WireComponentConfiguration> getComponentsToCreate(List<WireComponentConfiguration> oldWireComponentConfigurations, List<WireComponentConfiguration> newWireComponentConfigurations) {
        Set oldPids = oldWireComponentConfigurations.stream().map(com -> com.getConfiguration().getPid()).collect(Collectors.toSet());
        return newWireComponentConfigurations.stream().filter(newCom -> {
            boolean isWireAsset;
            Optional<String> factoryPid = WireGraphServiceImpl.getFactoryPid(newCom);
            boolean isNewComponent = !oldPids.contains(newCom.getConfiguration().getPid());
            boolean bl = isWireAsset = factoryPid.isPresent() && WIRE_ASSET_FACTORY_PID.contentEquals(factoryPid.get());
            return isNewComponent || isWireAsset;
        }).collect(Collectors.toList());
    }

    private Set<String> getComponentsToDelete(List<WireComponentConfiguration> oldWireComponentConfigurations, List<WireComponentConfiguration> newWireComponentConfigurations) {
        Map<String, WireComponentConfiguration> newGrouped = newWireComponentConfigurations.stream().collect(Collectors.toMap(c -> c.getConfiguration().getPid(), c -> c));
        return Stream.concat(oldWireComponentConfigurations.stream().filter(comp -> {
            boolean hasChangedFactoryPid;
            ComponentConfiguration config = comp.getConfiguration();
            String pid = config.getPid();
            Optional<String> oldFactoryPid = WireGraphServiceImpl.getFactoryPid(comp);
            Optional newFactoryPid = Optional.ofNullable((WireComponentConfiguration)newGrouped.get(pid)).flatMap(WireGraphServiceImpl::getFactoryPid);
            boolean hasBeenRemoved = !newGrouped.containsKey(pid);
            boolean isWireAsset = oldFactoryPid.isPresent() && WIRE_ASSET_FACTORY_PID.equals(oldFactoryPid.get());
            boolean bl = hasChangedFactoryPid = newFactoryPid.isPresent() && oldFactoryPid.isPresent() && !oldFactoryPid.get().contentEquals((CharSequence)newFactoryPid.get());
            return hasChangedFactoryPid || hasBeenRemoved && !isWireAsset;
        }), newWireComponentConfigurations.stream().filter(WireGraphServiceImpl::isWireAsset)).map(c -> c.getConfiguration().getPid()).collect(Collectors.toSet());
    }

    public synchronized void delete() throws KuraException {
        this.deleteAllWires();
        for (WireComponentConfiguration config : this.currentConfiguration.getWireComponentConfigurations()) {
            this.configurationService.deleteFactoryConfiguration(config.getConfiguration().getPid(), false);
        }
        WireGraphConfiguration newWireGraphConfiguration = new WireGraphConfiguration(new ArrayList(), new ArrayList());
        String jsonConfig = this.marshal(newWireGraphConfiguration);
        ComponentConfiguration wireGraphServiceComponentConfig = this.configurationService.getComponentConfiguration(CONF_PID);
        wireGraphServiceComponentConfig.getConfigurationProperties().put(NEW_WIRE_GRAPH_PROPERTY, jsonConfig);
        this.configurationService.updateConfiguration(CONF_PID, wireGraphServiceComponentConfig.getConfigurationProperties(), true);
        this.currentConfiguration = newWireGraphConfiguration;
    }

    public WireGraphConfiguration get() throws KuraException {
        List configServiceComponentConfigurations = this.configurationService.getComponentConfigurations(WIRE_COMPONENT_FILTER);
        WireGraphConfiguration wireGraphConfiguration = this.currentConfiguration;
        List wireComponentConfigurations = wireGraphConfiguration.getWireComponentConfigurations();
        ArrayList<WireComponentConfiguration> completeWireComponentConfigurations = new ArrayList<WireComponentConfiguration>();
        for (WireComponentConfiguration wireComponentConfiguration : wireComponentConfigurations) {
            ComponentConfiguration wComponentConfiguration = wireComponentConfiguration.getConfiguration();
            Map wComponentProperties = wireComponentConfiguration.getProperties();
            String wComponentPid = wComponentConfiguration.getPid();
            for (ComponentConfiguration configServiceComponentConfiguration : configServiceComponentConfigurations) {
                if (!wComponentPid.equals(configServiceComponentConfiguration.getPid())) continue;
                wComponentConfiguration = new ComponentConfigurationImpl(wComponentPid, (Tocd)configServiceComponentConfiguration.getDefinition(), configServiceComponentConfiguration.getConfigurationProperties());
                break;
            }
            completeWireComponentConfigurations.add(new WireComponentConfiguration(wComponentConfiguration, wComponentProperties));
        }
        return new WireGraphConfiguration(completeWireComponentConfigurations, wireGraphConfiguration.getWireConfigurations());
    }

    private ServiceReference<Marshaller>[] getJsonMarshallers() {
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Marshaller.class, (String)"(kura.service.pid=org.eclipse.kura.json.marshaller.unmarshaller.provider)");
    }

    private ServiceReference<Unmarshaller>[] getJsonUnmarshallers() {
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Unmarshaller.class, (String)"(kura.service.pid=org.eclipse.kura.json.marshaller.unmarshaller.provider)");
    }

    protected <T> T unmarshal(String string, Class<T> clazz) throws KuraException {
        Object result = null;
        ServiceReference<Unmarshaller>[] unmarshallerSRs = this.getJsonUnmarshallers();
        try {
            ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
            int n = unmarshallerSRs.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                    Unmarshaller unmarshaller = (Unmarshaller)this.bundleContext.getService(unmarshallerSR);
                    try {
                        result = unmarshaller.unmarshal(string, clazz);
                        if (result == null) break block7;
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(unmarshallerSR);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to extract persisted configuration.", (Throwable)e);
        }
        if (result == null) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, new Object[]{"configuration"});
        }
        return (T)result;
    }

    protected String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = this.getJsonMarshallers();
        try {
            ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
            int n = marshallerSRs.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)this.bundleContext.getService(marshallerSR);
                    try {
                        result = marshaller.marshal(object);
                        if (result == null) break block6;
                        break;
                    }
                    finally {
                        this.bundleContext.ungetService(marshallerSR);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to marshal configuration.", (Throwable)e);
        }
        return result;
    }

    protected String getServicePidByKuraServicePid(String kuraServicePid) {
        try {
            return this.bundleContext.getServiceReferences(WireComponent.class, null).stream().filter(ref -> kuraServicePid.equals(ref.getProperty("kura.service.pid"))).map(ref -> (String)ref.getProperty("service.pid")).findAny().orElse(null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    private WireGraphConfiguration loadWireGraphConfiguration(Map<String, Object> properties) throws KuraException {
        String jsonWireGraph = (String)properties.get(NEW_WIRE_GRAPH_PROPERTY);
        return this.unmarshal(jsonWireGraph, WireGraphConfiguration.class);
    }

    private static boolean isWireAsset(WireComponentConfiguration config) {
        Optional<String> factoryPid = WireGraphServiceImpl.getFactoryPid(config);
        return factoryPid.isPresent() && WIRE_ASSET_FACTORY_PID.contentEquals(factoryPid.get());
    }

    private static Optional<String> getFactoryPid(WireComponentConfiguration config) {
        ComponentConfiguration compConfig = config.getConfiguration();
        if (compConfig == null) {
            return Optional.empty();
        }
        Map properties = compConfig.getConfigurationProperties();
        if (properties == null) {
            return Optional.empty();
        }
        Object rawFactoryPid = properties.get("service.factoryPid");
        if (!(rawFactoryPid instanceof String)) {
            return Optional.empty();
        }
        return Optional.of((String)rawFactoryPid);
    }

    private static Filter getWireComponentConfigurationFilter() {
        try {
            return FrameworkUtil.createFilter((String)"(|(objectClass=org.eclipse.kura.wire.WireComponent)(objectClass=org.eclipse.kura.wire.WireEmitter)(objectClass=org.eclipse.kura.wire.WireReceiver))");
        }
        catch (Exception e) {
            logger.warn("failed to init wire component configuration filter", (Throwable)e);
            return null;
        }
    }
}

