/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message;

import java.text.ParseException;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KuraRequestPayload
extends KuraPayload {
    public static final String METRIC_REQUEST_ID = "request.id";
    public static final String REQUESTER_CLIENT_ID = "requester.client.id";

    public KuraRequestPayload() {
    }

    public KuraRequestPayload(KuraPayload payload) {
        for (String name : payload.metricNames()) {
            Object value = payload.getMetric(name);
            this.addMetric(name, value);
        }
        this.setBody(payload.getBody());
        this.setPosition(payload.getPosition());
        this.setTimestamp(payload.getTimestamp());
    }

    public String getRequestId() {
        return (String)this.getMetric(METRIC_REQUEST_ID);
    }

    public void setRequestId(String requestId) {
        this.addMetric(METRIC_REQUEST_ID, requestId);
    }

    public String getRequesterClientId() {
        return (String)this.getMetric(REQUESTER_CLIENT_ID);
    }

    public void setRequesterClientId(String requesterClientId) {
        this.addMetric(REQUESTER_CLIENT_ID, requesterClientId);
    }

    public static KuraRequestPayload buildFromKuraPayload(KuraPayload payload) throws ParseException {
        if (payload.getMetric(METRIC_REQUEST_ID) == null) {
            throw new ParseException("Not a valid request payload", 0);
        }
        KuraRequestPayload requestPayload = new KuraRequestPayload(payload);
        return requestPayload;
    }
}

