/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceConfig;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.NetProtocol;
import org.eclipse.kura.net.NetworkAdminService;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.dhcp.DhcpServerCfg;
import org.eclipse.kura.net.dhcp.DhcpServerCfgIP4;
import org.eclipse.kura.net.dhcp.DhcpServerConfigIP4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.firewall.FirewallNatConfig;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfigIP4;
import org.eclipse.kura.net.firewall.FirewallPortForwardConfigIP4;
import org.eclipse.kura.net.firewall.RuleType;
import org.eclipse.kura.net.modem.CellularModem;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemDevice;
import org.eclipse.kura.net.modem.ModemInterface;
import org.eclipse.kura.net.modem.ModemInterfaceAddressConfig;
import org.eclipse.kura.net.modem.ModemManagerService;
import org.eclipse.kura.net.modem.ModemPdpContext;
import org.eclipse.kura.net.modem.ModemPdpContextType;
import org.eclipse.kura.net.modem.ModemTechnologyType;
import org.eclipse.kura.net.modem.SerialModemDevice;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiBgscanModule;
import org.eclipse.kura.net.wifi.WifiChannel;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiClientMonitorService;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiHotspotInfo;
import org.eclipse.kura.net.wifi.WifiInterfaceAddressConfig;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.usb.UsbDevice;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.KuraExceptionHandler;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.GwtSafeHtmlUtils;
import org.eclipse.kura.web.shared.model.GwtFirewallNatEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallOpenPortEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallPortForwardEntry;
import org.eclipse.kura.web.shared.model.GwtModemAuthType;
import org.eclipse.kura.web.shared.model.GwtModemInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtModemPdpEntry;
import org.eclipse.kura.web.shared.model.GwtModemPdpType;
import org.eclipse.kura.web.shared.model.GwtNetIfConfigMode;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetIfType;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtNetRouterMode;
import org.eclipse.kura.web.shared.model.GwtWifiBgscanModule;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.validator.PasswordStrengthValidators;
import org.eclipse.kura.web.shared.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtNetworkServiceImpl
extends OsgiRemoteServiceServlet
implements GwtNetworkService {
    private static final long serialVersionUID = -4188750359099902616L;
    private static final Logger logger = LoggerFactory.getLogger(GwtNetworkServiceImpl.class);

    @Override
    public List<GwtNetInterfaceConfig> findNetInterfaceConfigurations() throws GwtKuraException {
        List<GwtNetInterfaceConfig> result = this.privateFindNetInterfaceConfigurations();
        for (GwtNetInterfaceConfig netConfig : result) {
            if (netConfig instanceof GwtWifiNetInterfaceConfig) {
                GwtWifiConfig gwtStationWifiConfig;
                GwtWifiNetInterfaceConfig wifiConfig = (GwtWifiNetInterfaceConfig)netConfig;
                GwtWifiConfig gwtAPWifiConfig = wifiConfig.getAccessPointWifiConfig();
                if (gwtAPWifiConfig != null) {
                    gwtAPWifiConfig.setPassword("Placeholder");
                }
                if ((gwtStationWifiConfig = wifiConfig.getStationWifiConfig()) == null) continue;
                gwtStationWifiConfig.setPassword("Placeholder");
                continue;
            }
            if (!(netConfig instanceof GwtModemInterfaceConfig)) continue;
            GwtModemInterfaceConfig modemConfig = (GwtModemInterfaceConfig)netConfig;
            modemConfig.setPassword("Placeholder");
        }
        return result;
    }

    private List<GwtNetInterfaceConfig> privateFindNetInterfaceConfigurations() throws GwtKuraException {
        logger.debug("Starting");
        ArrayList<GwtNetInterfaceConfig> gwtNetConfigs = new ArrayList<GwtNetInterfaceConfig>();
        NetworkAdminService nas = null;
        try {
            nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        }
        catch (Throwable t) {
            logger.warn("Exception", t);
            return gwtNetConfigs;
        }
        ModemManagerService modemManagerService = null;
        try {
            modemManagerService = ServiceLocator.getInstance().getService(ModemManagerService.class);
        }
        catch (Throwable t) {
            logger.warn("{ModemManagerService} Exception", t);
        }
        WifiClientMonitorService wifiClientMonitorService = null;
        try {
            wifiClientMonitorService = ServiceLocator.getInstance().getService(WifiClientMonitorService.class);
        }
        catch (Throwable t) {
            logger.warn("{WifiClientMonitorService} Exception", t);
        }
        try {
            for (NetInterfaceConfig netIfConfig : nas.getNetworkInterfaceConfigs()) {
                logger.debug("Getting config for {} with type {}", (Object)netIfConfig.getName(), (Object)netIfConfig.getType());
                logger.debug("Interface State: {}", (Object)netIfConfig.getState());
                GwtNetInterfaceConfig gwtNetConfig = this.createGwtNetConfig((NetInterfaceConfig<? extends NetInterfaceAddressConfig>)netIfConfig);
                gwtNetConfig.setName(netIfConfig.getName());
                gwtNetConfig.setHwName(netIfConfig.getName());
                if (netIfConfig.getType() != null) {
                    gwtNetConfig.setHwType(netIfConfig.getType().name());
                }
                if (netIfConfig.getState() != null) {
                    gwtNetConfig.setHwState(netIfConfig.getState().name());
                }
                logger.debug("MAC: {}", (Object)NetUtil.hardwareAddressToString((byte[])netIfConfig.getHardwareAddress()));
                gwtNetConfig.setHwAddress(NetUtil.hardwareAddressToString((byte[])netIfConfig.getHardwareAddress()));
                gwtNetConfig.setHwDriver(netIfConfig.getDriver());
                gwtNetConfig.setHwDriverVersion(netIfConfig.getDriverVersion());
                gwtNetConfig.setHwFirmware(netIfConfig.getFirmwareVersion());
                gwtNetConfig.setHwMTU(netIfConfig.getMTU());
                if (netIfConfig.getUsbDevice() != null) {
                    gwtNetConfig.setHwUsbDevice(netIfConfig.getUsbDevice().getUsbDevicePath());
                } else {
                    gwtNetConfig.setHwUsbDevice("N/A");
                }
                NetInterfaceAddressConfig addressConfig = ((AbstractNetInterface)netIfConfig).getNetInterfaceAddressConfig();
                if (addressConfig != null) {
                    List netConfigs;
                    if (addressConfig.getAddress() != null) {
                        logger.debug("current address: {}", (Object)addressConfig.getAddress().getHostAddress());
                    }
                    if (addressConfig.getNetworkPrefixLength() >= 0 && addressConfig.getNetworkPrefixLength() <= 32) {
                        logger.debug("current prefix length: {}", (Object)addressConfig.getNetworkPrefixLength());
                    }
                    if (addressConfig.getNetmask() != null) {
                        logger.debug("current netmask: {}", (Object)addressConfig.getNetmask().getHostAddress());
                    }
                    if ((netConfigs = addressConfig.getConfigs()) != null) {
                        boolean isNatEnabled = false;
                        boolean isDhcpServerEnabled = false;
                        for (NetConfig netConfig : netConfigs) {
                            if (netConfig instanceof NetConfigIP4) {
                                List dnsServers;
                                StringBuffer sb;
                                logger.debug("Setting up NetConfigIP4 with status {}", (Object)((NetConfigIP4)netConfig).getStatus().toString());
                                if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusEnabledLAN) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusEnabledLAN.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusEnabledWAN) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusEnabledWAN.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusUnmanaged) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusUnmanaged.name());
                                } else if (((NetConfigIP4)netConfig).getStatus() == NetInterfaceStatus.netIPv4StatusL2Only) {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusL2Only.name());
                                } else {
                                    gwtNetConfig.setStatus(GwtNetIfStatus.netIPv4StatusDisabled.name());
                                }
                                if (((NetConfigIP4)netConfig).isDhcp() || netIfConfig.isLoopback()) {
                                    if (((NetConfigIP4)netConfig).isDhcp()) {
                                        gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name());
                                    }
                                    if (netIfConfig.isLoopback()) {
                                        gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeManual.name());
                                    }
                                    if (addressConfig.getAddress() != null) {
                                        gwtNetConfig.setIpAddress(addressConfig.getAddress().getHostAddress());
                                    } else {
                                        gwtNetConfig.setIpAddress("");
                                    }
                                    if (addressConfig.getNetworkPrefixLength() > 0 && addressConfig.getNetworkPrefixLength() <= 32) {
                                        gwtNetConfig.setSubnetMask(NetworkUtil.getNetmaskStringForm((int)addressConfig.getNetworkPrefixLength()));
                                    } else if (addressConfig.getNetmask() != null) {
                                        gwtNetConfig.setSubnetMask(addressConfig.getNetmask().getHostAddress());
                                    } else {
                                        gwtNetConfig.setSubnetMask("");
                                    }
                                    if (addressConfig.getGateway() != null) {
                                        gwtNetConfig.setGateway(addressConfig.getGateway().getHostAddress());
                                    } else {
                                        gwtNetConfig.setGateway("");
                                    }
                                    sb = new StringBuffer();
                                    dnsServers = addressConfig.getDnsServers();
                                    if (dnsServers != null && !dnsServers.isEmpty()) {
                                        String sep = "";
                                        for (IPAddress dnsServer : dnsServers) {
                                            sb.append(sep).append(dnsServer.getHostAddress());
                                            sep = "\n";
                                        }
                                        logger.debug("DNS Servers: {}", (Object)sb);
                                        gwtNetConfig.setReadOnlyDnsServers(sb.toString());
                                    } else {
                                        logger.debug("DNS Servers: [empty String]");
                                        gwtNetConfig.setReadOnlyDnsServers("");
                                    }
                                } else {
                                    gwtNetConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeManual.name());
                                    if (((NetConfigIP4)netConfig).getAddress() != null) {
                                        gwtNetConfig.setIpAddress(((IP4Address)((NetConfigIP4)netConfig).getAddress()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setIpAddress("");
                                    }
                                    if (((NetConfigIP4)netConfig).getSubnetMask() != null) {
                                        gwtNetConfig.setSubnetMask(((IP4Address)((NetConfigIP4)netConfig).getSubnetMask()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setSubnetMask("");
                                    }
                                    if (((NetConfigIP4)netConfig).getGateway() != null) {
                                        logger.debug("Gateway for {} is: {}", (Object)netIfConfig.getName(), (Object)((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                                        gwtNetConfig.setGateway(((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                                    } else {
                                        gwtNetConfig.setGateway("");
                                    }
                                }
                                sb = new StringBuffer();
                                dnsServers = ((NetConfigIP4)netConfig).getDnsServers();
                                if (dnsServers != null && !dnsServers.isEmpty()) {
                                    IPAddress dnsServer;
                                    dnsServer = dnsServers.iterator();
                                    while (dnsServer.hasNext()) {
                                        IP4Address dnsServer2 = (IP4Address)dnsServer.next();
                                        if (dnsServer2.getHostAddress().equals("127.0.0.1")) continue;
                                        sb.append(' ').append(dnsServer2.getHostAddress());
                                    }
                                    logger.debug("DNS Servers: {}", (Object)sb);
                                    gwtNetConfig.setDnsServers(sb.toString().trim());
                                } else {
                                    logger.debug("DNS Servers: [empty String]");
                                    gwtNetConfig.setDnsServers("");
                                }
                            }
                            if (netConfig instanceof WifiConfig) {
                                WifiMode activeWirelessMode;
                                int[] channels;
                                logger.debug("Setting up WifiConfigIP4");
                                WifiConfig wifiConfig = (WifiConfig)netConfig;
                                GwtWifiConfig gwtWifiConfig = new GwtWifiConfig();
                                if (wifiConfig.getMode() == WifiMode.MASTER) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setAccessPointWifiConfig(gwtWifiConfig);
                                } else if (wifiConfig.getMode() == WifiMode.INFRA) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setStationWifiConfig(gwtWifiConfig);
                                } else if (wifiConfig.getMode() == WifiMode.ADHOC) {
                                    gwtWifiConfig.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name());
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setAdhocWifiConfig(gwtWifiConfig);
                                }
                                gwtWifiConfig.setWirelessSsid(wifiConfig.getSSID());
                                gwtWifiConfig.setDriver(wifiConfig.getDriver());
                                if (wifiConfig.getSecurity() == WifiSecurity.SECURITY_WPA) {
                                    gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA.name());
                                } else if (wifiConfig.getSecurity() == WifiSecurity.SECURITY_WPA2) {
                                    gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA2.name());
                                } else if (wifiConfig.getSecurity() == WifiSecurity.SECURITY_WPA_WPA2) {
                                    gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWPA_WPA2.name());
                                } else if (wifiConfig.getSecurity() == WifiSecurity.SECURITY_WEP) {
                                    gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityWEP.name());
                                } else {
                                    gwtWifiConfig.setSecurity(GwtWifiSecurity.netWifiSecurityNONE.name());
                                }
                                if (wifiConfig.getPairwiseCiphers() == WifiCiphers.CCMP_TKIP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
                                } else if (wifiConfig.getPairwiseCiphers() == WifiCiphers.TKIP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
                                } else if (wifiConfig.getPairwiseCiphers() == WifiCiphers.CCMP) {
                                    gwtWifiConfig.setPairwiseCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
                                }
                                if (wifiConfig.getGroupCiphers() == WifiCiphers.CCMP_TKIP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
                                } else if (wifiConfig.getGroupCiphers() == WifiCiphers.TKIP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_TKIP.name());
                                } else if (wifiConfig.getGroupCiphers() == WifiCiphers.CCMP) {
                                    gwtWifiConfig.setGroupCiphers(GwtWifiCiphers.netWifiCiphers_CCMP.name());
                                }
                                WifiBgscan wifiBgscan = wifiConfig.getBgscan();
                                if (wifiBgscan != null) {
                                    if (wifiBgscan.getModule() == WifiBgscanModule.NONE) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_NONE.name());
                                    } else if (wifiBgscan.getModule() == WifiBgscanModule.SIMPLE) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_SIMPLE.name());
                                    } else if (wifiBgscan.getModule() == WifiBgscanModule.LEARN) {
                                        gwtWifiConfig.setBgscanModule(GwtWifiBgscanModule.netWifiBgscanMode_LEARN.name());
                                    }
                                    gwtWifiConfig.setBgscanRssiThreshold(wifiBgscan.getRssiThreshold());
                                    gwtWifiConfig.setBgscanShortInterval(wifiBgscan.getShortInterval());
                                    gwtWifiConfig.setBgscanLongInterval(wifiBgscan.getLongInterval());
                                }
                                gwtWifiConfig.setPingAccessPoint(wifiConfig.pingAccessPoint());
                                gwtWifiConfig.setIgnoreSSID(wifiConfig.ignoreSSID());
                                Password psswd = wifiConfig.getPasskey();
                                if (psswd != null) {
                                    String password = new String(psswd.getPassword());
                                    gwtWifiConfig.setPassword(password);
                                }
                                if ((channels = wifiConfig.getChannels()) != null) {
                                    ArrayList<Integer> alChannels = new ArrayList<Integer>();
                                    int[] nArray = channels;
                                    int n = channels.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        int channel = nArray[n2];
                                        alChannels.add(new Integer(channel));
                                        ++n2;
                                    }
                                    gwtWifiConfig.setChannels(alChannels);
                                }
                                Enum gwtWifiRadioMode = null;
                                if (wifiConfig.getRadioMode() != null) {
                                    switch (wifiConfig.getRadioMode()) {
                                        case RADIO_MODE_80211a: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeA;
                                            break;
                                        }
                                        case RADIO_MODE_80211b: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeB;
                                            break;
                                        }
                                        case RADIO_MODE_80211g: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeBG;
                                            break;
                                        }
                                        case RADIO_MODE_80211nHT20: 
                                        case RADIO_MODE_80211nHT40below: 
                                        case RADIO_MODE_80211nHT40above: {
                                            gwtWifiRadioMode = GwtWifiRadioMode.netWifiRadioModeBGN;
                                            break;
                                        }
                                    }
                                }
                                if (gwtWifiRadioMode != null) {
                                    gwtWifiConfig.setRadioMode(gwtWifiRadioMode.name());
                                }
                                if ((activeWirelessMode = ((WifiInterfaceAddressConfig)addressConfig).getMode()) == WifiMode.MASTER) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                } else if (activeWirelessMode == WifiMode.INFRA) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
                                    if (wifiClientMonitorService != null && wifiConfig.getMode().equals((Object)WifiMode.INFRA)) {
                                        if (gwtNetConfig.getStatus().equals(GwtNetIfStatus.netIPv4StatusDisabled.name()) || gwtNetConfig.getStatus().equals(GwtNetIfStatus.netIPv4StatusUnmanaged.name())) {
                                            gwtNetConfig.setHwRssi("N/A");
                                        } else {
                                            try {
                                                int rssi = wifiClientMonitorService.getSignalLevel(netIfConfig.getName(), wifiConfig.getSSID());
                                                logger.debug("Setting Received Signal Strength to {}", (Object)rssi);
                                                gwtNetConfig.setHwRssi(Integer.toString(rssi));
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed", (Throwable)e);
                                            }
                                        }
                                    }
                                } else if (activeWirelessMode == WifiMode.ADHOC) {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                } else {
                                    ((GwtWifiNetInterfaceConfig)gwtNetConfig).setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeDisabled.name());
                                    gwtNetConfig.setHwRssi("N/A");
                                }
                            }
                            if (netConfig instanceof ModemConfig) {
                                logger.debug("Setting up ModemConfig");
                                ModemConfig modemConfig = (ModemConfig)netConfig;
                                GwtModemInterfaceConfig gwtModemConfig = (GwtModemInterfaceConfig)gwtNetConfig;
                                if (modemManagerService != null) {
                                    UsbDevice usbDevice = netIfConfig.getUsbDevice();
                                    String modemServiceId = null;
                                    modemServiceId = usbDevice != null ? netIfConfig.getUsbDevice().getUsbPort() : (String)modemManagerService.withAllModemServices(modemServices -> {
                                        for (CellularModem modemService : modemServices) {
                                            ModemDevice modemDevice = modemService.getModemDevice();
                                            if (!(modemDevice instanceof SerialModemDevice)) continue;
                                            return modemDevice.getProductName();
                                        }
                                        return null;
                                    });
                                    if (modemServiceId != null) {
                                        GwtNetInterfaceConfig currentConfig = gwtNetConfig;
                                        modemManagerService.withModemService(modemServiceId, m -> {
                                            if (!m.isPresent()) {
                                                return null;
                                            }
                                            CellularModem cellModemService = (CellularModem)m.get();
                                            try {
                                                String imei = cellModemService.getSerialNumber();
                                                logger.debug("Setting IMEI/MEID to {}", (Object)imei);
                                                gwtModemConfig.setHwSerial(imei);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get IMEI from modem", (Throwable)e);
                                            }
                                            try {
                                                int rssi = cellModemService.getSignalStrength();
                                                logger.debug("Setting Received Signal Strength to {}", (Object)rssi);
                                                gwtModemConfig.setHwRssi(Integer.toString(rssi));
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get Received Signal Strength from modem", (Throwable)e);
                                            }
                                            try {
                                                String sModel = cellModemService.getModel();
                                                ((GwtModemInterfaceConfig)currentConfig).setModel(sModel);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get model information from modem", (Throwable)e);
                                            }
                                            try {
                                                boolean gpsSupported = cellModemService.isGpsSupported();
                                                logger.debug("Setting GPS supported to {}", (Object)gpsSupported);
                                                ((GwtModemInterfaceConfig)currentConfig).setGpsSupported(gpsSupported);
                                            }
                                            catch (KuraException e) {
                                                logger.warn("Failed to get GPS supported from modem", (Throwable)e);
                                            }
                                            return null;
                                        });
                                    }
                                }
                                gwtModemConfig.setConfigMode(GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name());
                                if (addressConfig.getAddress() != null) {
                                    gwtModemConfig.setIpAddress(addressConfig.getAddress().getHostAddress());
                                }
                                if (addressConfig.getNetmask() != null) {
                                    gwtModemConfig.setSubnetMask(addressConfig.getNetmask().getHostAddress());
                                }
                                gwtModemConfig.setDialString(modemConfig.getDialString());
                                ModemConfig.AuthType authType = modemConfig.getAuthType();
                                if (authType == ModemConfig.AuthType.AUTO) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthAUTO);
                                } else if (authType == ModemConfig.AuthType.CHAP) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthCHAP);
                                } else if (authType == ModemConfig.AuthType.PAP) {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthPAP);
                                } else {
                                    gwtModemConfig.setAuthType(GwtModemAuthType.netModemAuthNONE);
                                }
                                gwtModemConfig.setUsername(modemConfig.getUsername());
                                gwtModemConfig.setPassword(modemConfig.getPasswordAsPassword().toString());
                                gwtModemConfig.setPppNum(modemConfig.getPppNumber());
                                gwtModemConfig.setResetTimeout(modemConfig.getResetTimeout());
                                gwtModemConfig.setPersist(modemConfig.isPersist());
                                gwtModemConfig.setMaxFail(modemConfig.getMaxFail());
                                gwtModemConfig.setIdle(modemConfig.getIdle());
                                gwtModemConfig.setActiveFilter(modemConfig.getActiveFilter());
                                gwtModemConfig.setLcpEchoInterval(modemConfig.getLcpEchoInterval());
                                gwtModemConfig.setLcpEchoFailure(modemConfig.getLcpEchoFailure());
                                gwtModemConfig.setGpsEnabled(modemConfig.isGpsEnabled());
                                gwtModemConfig.setDiversityEnabled(modemConfig.isDiversityEnabled());
                                gwtModemConfig.setProfileID(modemConfig.getProfileID());
                                ModemConfig.PdpType pdpType = modemConfig.getPdpType();
                                if (pdpType == ModemConfig.PdpType.IP) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpIP);
                                } else if (pdpType == ModemConfig.PdpType.PPP) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpPPP);
                                } else if (pdpType == ModemConfig.PdpType.IPv6) {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpIPv6);
                                } else {
                                    gwtModemConfig.setPdpType(GwtModemPdpType.netModemPdpUnknown);
                                }
                                gwtModemConfig.setApn(modemConfig.getApn());
                                gwtModemConfig.setDataCompression(modemConfig.getDataCompression());
                                gwtModemConfig.setHeaderCompression(modemConfig.getHeaderCompression());
                                ModemConnectionStatus connectionStatus = ((ModemInterfaceAddressConfig)addressConfig).getConnectionStatus();
                                if (connectionStatus == ModemConnectionStatus.DISCONNECTED) {
                                    gwtModemConfig.setHwState(NetInterfaceState.DISCONNECTED.name());
                                } else if (connectionStatus == ModemConnectionStatus.CONNECTING) {
                                    gwtModemConfig.setHwState(NetInterfaceState.IP_CONFIG.name());
                                } else if (connectionStatus == ModemConnectionStatus.CONNECTED) {
                                    gwtModemConfig.setHwState(NetInterfaceState.ACTIVATED.name());
                                } else {
                                    gwtModemConfig.setHwState(NetInterfaceState.UNKNOWN.name());
                                }
                                gwtModemConfig.setConnectionType(((ModemInterfaceAddressConfig)addressConfig).getConnectionType().name());
                            }
                            if (netConfig instanceof DhcpServerConfigIP4) {
                                logger.debug("Setting up DhcpServerConfigIP4: {} to {}", (Object)((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeStart()).getHostAddress(), (Object)((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeEnd()).getHostAddress());
                                logger.debug("Setting up DhcpServerConfigIP4: {}", (Object)((DhcpServerConfigIP4)netConfig).toString());
                                isDhcpServerEnabled = ((DhcpServerConfigIP4)netConfig).isEnabled();
                                gwtNetConfig.setRouterDhcpBeginAddress(((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeStart()).getHostAddress());
                                gwtNetConfig.setRouterDhcpEndAddress(((IP4Address)((DhcpServerConfigIP4)netConfig).getRangeEnd()).getHostAddress());
                                gwtNetConfig.setRouterDhcpSubnetMask(((IP4Address)((DhcpServerConfigIP4)netConfig).getSubnetMask()).getHostAddress());
                                gwtNetConfig.setRouterDhcpDefaultLease(((DhcpServerConfigIP4)netConfig).getDefaultLeaseTime());
                                gwtNetConfig.setRouterDhcpMaxLease(((DhcpServerConfigIP4)netConfig).getMaximumLeaseTime());
                                gwtNetConfig.setRouterDnsPass(((DhcpServerConfigIP4)netConfig).isPassDns());
                            }
                            if (!(netConfig instanceof FirewallAutoNatConfig)) continue;
                            logger.debug("Setting up FirewallAutoNatConfig");
                            isNatEnabled = true;
                        }
                        if (isDhcpServerEnabled && isNatEnabled) {
                            logger.debug("setting router mode to DHCP and NAT");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterDchpNat.name());
                        } else if (isDhcpServerEnabled && !isNatEnabled) {
                            logger.debug("setting router mode to DHCP only");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterDchp.name());
                        } else if (!isDhcpServerEnabled && isNatEnabled) {
                            logger.debug("setting router mode to NAT only");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterNat.name());
                        } else {
                            logger.debug("setting router mode to disabled");
                            gwtNetConfig.setRouterMode(GwtNetRouterMode.netRouterOff.name());
                        }
                    }
                }
                gwtNetConfigs.add(gwtNetConfig);
            }
        }
        catch (Throwable t) {
            KuraExceptionHandler.handle(t);
        }
        logger.debug("Returning");
        return gwtNetConfigs;
    }

    private GwtNetInterfaceConfig createGwtNetConfig(NetInterfaceConfig<? extends NetInterfaceAddressConfig> netIfConfig) {
        GwtNetInterfaceConfig gwtNetConfig;
        if (netIfConfig.getType() == NetInterfaceType.WIFI) {
            gwtNetConfig = new GwtWifiNetInterfaceConfig();
        } else if (netIfConfig.getType() == NetInterfaceType.MODEM) {
            gwtNetConfig = new GwtModemInterfaceConfig();
            ((GwtModemInterfaceConfig)gwtNetConfig).setModemId(((ModemInterface)netIfConfig).getModemIdentifier());
            ((GwtModemInterfaceConfig)gwtNetConfig).setManufacturer(((ModemInterface)netIfConfig).getManufacturer());
            ((GwtModemInterfaceConfig)gwtNetConfig).setModel(((ModemInterface)netIfConfig).getModel());
            ArrayList<String> technologyList = new ArrayList<String>();
            List technologyTypes = ((ModemInterface)netIfConfig).getTechnologyTypes();
            if (technologyTypes != null) {
                for (ModemTechnologyType techType : technologyTypes) {
                    technologyList.add(techType.name());
                }
            }
            ((GwtModemInterfaceConfig)gwtNetConfig).setNetworkTechnology(technologyList);
        } else {
            gwtNetConfig = new GwtNetInterfaceConfig();
            gwtNetConfig.setHwRssi("N/A");
        }
        return gwtNetConfig;
    }

    @Override
    public void updateNetInterfaceConfigurations(GwtXSRFToken xsrfToken, GwtNetInterfaceConfig config) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        logger.debug("config.getStatus(): {}", (Object)GwtSafeHtmlUtils.htmlEscape(config.getStatus()));
        String status = config.getStatus();
        boolean autoConnect = true;
        if (GwtNetIfStatus.netIPv4StatusDisabled.name().equals(status)) {
            autoConnect = false;
        }
        try {
            NetInterfaceStatus netInterfaceStatus = config.getStatus().equals(GwtNetIfStatus.netIPv4StatusUnmanaged.name()) ? NetInterfaceStatus.netIPv4StatusUnmanaged : (config.getStatus().equals(GwtNetIfStatus.netIPv4StatusL2Only.name()) ? NetInterfaceStatus.netIPv4StatusL2Only : (config.getStatus().equals(GwtNetIfStatus.netIPv4StatusEnabledLAN.name()) ? NetInterfaceStatus.netIPv4StatusEnabledLAN : (config.getStatus().equals(GwtNetIfStatus.netIPv4StatusEnabledWAN.name()) ? NetInterfaceStatus.netIPv4StatusEnabledWAN : NetInterfaceStatus.netIPv4StatusDisabled)));
            ArrayList<Object> netConfigs = new ArrayList<Object>();
            NetConfigIP4 netConfig4 = new NetConfigIP4(netInterfaceStatus, autoConnect);
            if (config.getHwTypeEnum() == GwtNetIfType.ETHERNET || config.getHwTypeEnum() == GwtNetIfType.WIFI || config.getHwTypeEnum() == GwtNetIfType.MODEM) {
                List<NetConfig> dhcpConfigs;
                logger.debug("config.getConfigMode(): {}", (Object)config.getConfigMode());
                String regexp = "[\\s,;\\n\\t]+";
                if (GwtNetIfConfigMode.netIPv4ConfigModeDHCP.name().equals(config.getConfigMode())) {
                    logger.debug("mode is DHCP");
                    netConfig4.setDhcp(true);
                } else {
                    logger.debug("mode is STATIC");
                    netConfig4.setDhcp(false);
                    if (config.getIpAddress() != null && !config.getIpAddress().isEmpty()) {
                        logger.debug("setting address: {}", (Object)config.getIpAddress());
                        netConfig4.setAddress((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)config.getIpAddress())));
                    }
                    if (config.getSubnetMask() != null && !config.getSubnetMask().isEmpty()) {
                        logger.debug("setting subnet mask: {}", (Object)config.getSubnetMask());
                        netConfig4.setSubnetMask((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)config.getSubnetMask())));
                    }
                    if (config.getGateway() != null && !config.getGateway().isEmpty()) {
                        logger.debug("setting gateway: {}", (Object)config.getGateway());
                        netConfig4.setGateway((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)config.getGateway())));
                    }
                }
                String[] dnsServersString = config.getDnsServers().split(regexp);
                if (dnsServersString != null && dnsServersString.length > 0) {
                    ArrayList<IP4Address> dnsServers = new ArrayList<IP4Address>();
                    String[] stringArray = dnsServersString;
                    int n = dnsServersString.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dnsEntry = stringArray[n2];
                        if (!dnsEntry.trim().isEmpty()) {
                            logger.debug("setting DNS: {}", (Object)dnsEntry);
                            IP4Address dnsServer = (IP4Address)IPAddress.parseHostAddress((String)dnsEntry);
                            dnsServers.add(dnsServer);
                        }
                        ++n2;
                    }
                    netConfig4.setDnsServers(dnsServers);
                }
                netConfigs.add(netConfig4);
                if (GwtNetIfConfigMode.netIPv4ConfigModeManual.name().equals(config.getConfigMode()) && (dhcpConfigs = this.getDhcpConfig(config)) != null) {
                    logger.debug("Adding dhcp and/or nat configs to interface update config");
                    netConfigs.addAll(dhcpConfigs);
                }
                if (config.getHwTypeEnum() == GwtNetIfType.ETHERNET) {
                    nas.updateEthernetInterfaceConfig(GwtSafeHtmlUtils.htmlEscape(config.getName()), autoConnect, config.getHwMTU(), netConfigs);
                }
            }
            if (config.getHwTypeEnum() == GwtNetIfType.WIFI) {
                GwtWifiConfig gwtWifiConfig;
                if (config instanceof GwtWifiNetInterfaceConfig && (gwtWifiConfig = ((GwtWifiNetInterfaceConfig)config).getActiveWifiConfig()) != null) {
                    WifiConfig wifiConfig = this.getWifiConfig(gwtWifiConfig);
                    String passKey = new String(wifiConfig.getPasskey().getPassword());
                    if (passKey != null && passKey.equals("Placeholder")) {
                        List<GwtNetInterfaceConfig> result = this.privateFindNetInterfaceConfigurations();
                        for (GwtNetInterfaceConfig netConfig : result) {
                            if (!(netConfig instanceof GwtWifiNetInterfaceConfig) || !config.getName().equals(((GwtWifiNetInterfaceConfig)netConfig).getName())) continue;
                            GwtWifiNetInterfaceConfig oldWifiConfig = (GwtWifiNetInterfaceConfig)netConfig;
                            GwtWifiConfig oldGwtWifiConfig = gwtWifiConfig.getWirelessMode().equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name()) ? oldWifiConfig.getAccessPointWifiConfig() : oldWifiConfig.getStationWifiConfig();
                            if (oldGwtWifiConfig == null) continue;
                            wifiConfig.setPasskey(GwtSafeHtmlUtils.htmlUnescape(oldGwtWifiConfig.getPassword()));
                        }
                    } else if (passKey != null && wifiConfig.getMode() == WifiMode.MASTER) {
                        this.validateUserPassword(passKey);
                    }
                    netConfigs.add(wifiConfig);
                    nas.updateWifiInterfaceConfig(GwtSafeHtmlUtils.htmlEscape(config.getName()), autoConnect, null, netConfigs);
                }
            } else if (config.getHwTypeEnum() == GwtNetIfType.MODEM && config instanceof GwtModemInterfaceConfig) {
                GwtModemPdpType pdpType;
                GwtModemInterfaceConfig gwtModemConfig = (GwtModemInterfaceConfig)config;
                ModemConfig modemConfig = new ModemConfig();
                String serialNum = gwtModemConfig.getHwSerial();
                String modemId = gwtModemConfig.getModemId();
                int pppNum = gwtModemConfig.getPppNum();
                if (netInterfaceStatus.equals((Object)NetInterfaceStatus.netIPv4StatusEnabledWAN)) {
                    modemConfig.setEnabled(true);
                } else {
                    modemConfig.setEnabled(false);
                }
                modemConfig.setApn(gwtModemConfig.getApn());
                modemConfig.setPppNumber(gwtModemConfig.getPppNum());
                modemConfig.setDataCompression(gwtModemConfig.getDataCompression());
                modemConfig.setDialString(gwtModemConfig.getDialString());
                modemConfig.setHeaderCompression(gwtModemConfig.getHeaderCompression());
                String passKey = GwtSafeHtmlUtils.htmlUnescape(gwtModemConfig.getPassword());
                if (passKey != null && passKey.equals("Placeholder")) {
                    List<GwtNetInterfaceConfig> result = this.privateFindNetInterfaceConfigurations();
                    for (GwtNetInterfaceConfig netConfig : result) {
                        if (!(netConfig instanceof GwtModemInterfaceConfig)) continue;
                        GwtModemInterfaceConfig oldModemConfig = (GwtModemInterfaceConfig)netConfig;
                        if (!gwtModemConfig.getName().equals(oldModemConfig.getName())) continue;
                        modemConfig.setPassword(oldModemConfig.getPassword());
                    }
                } else if (passKey != null) {
                    modemConfig.setPassword(passKey);
                }
                modemConfig.setUsername(gwtModemConfig.getUsername());
                modemConfig.setResetTimeout(gwtModemConfig.getResetTimeout());
                modemConfig.setPersist(gwtModemConfig.isPersist());
                modemConfig.setMaxFail(gwtModemConfig.getMaxFail());
                modemConfig.setIdle(gwtModemConfig.getIdle());
                modemConfig.setActiveFilter(gwtModemConfig.getActiveFilter());
                modemConfig.setLcpEchoInterval(gwtModemConfig.getLcpEchoInterval());
                modemConfig.setLcpEchoFailure(gwtModemConfig.getLcpEchoFailure());
                modemConfig.setGpsEnabled(gwtModemConfig.isGpsEnabled());
                modemConfig.setDiversityEnabled(gwtModemConfig.isDiversityEnabled());
                GwtModemAuthType authType = gwtModemConfig.getAuthType();
                if (authType != null) {
                    if (authType.equals((Object)GwtModemAuthType.netModemAuthNONE)) {
                        modemConfig.setAuthType(ModemConfig.AuthType.NONE);
                    } else if (authType.equals((Object)GwtModemAuthType.netModemAuthAUTO)) {
                        modemConfig.setAuthType(ModemConfig.AuthType.AUTO);
                    } else if (authType.equals((Object)GwtModemAuthType.netModemAuthCHAP)) {
                        modemConfig.setAuthType(ModemConfig.AuthType.CHAP);
                    } else if (authType.equals((Object)GwtModemAuthType.netModemAuthPAP)) {
                        modemConfig.setAuthType(ModemConfig.AuthType.PAP);
                    }
                }
                if ((pdpType = gwtModemConfig.getPdpType()) != null) {
                    if (pdpType.equals((Object)GwtModemPdpType.netModemPdpIP)) {
                        modemConfig.setPdpType(ModemConfig.PdpType.IP);
                    } else if (pdpType.equals((Object)GwtModemPdpType.netModemPdpIPv6)) {
                        modemConfig.setPdpType(ModemConfig.PdpType.IPv6);
                    } else if (pdpType.equals((Object)GwtModemPdpType.netModemPdpPPP)) {
                        modemConfig.setPdpType(ModemConfig.PdpType.PPP);
                    } else {
                        modemConfig.setPdpType(ModemConfig.PdpType.UNKNOWN);
                    }
                }
                netConfigs.add(modemConfig);
                nas.updateModemInterfaceConfig(config.getName(), serialNum, modemId, pppNum, autoConnect, -1, netConfigs);
            }
        }
        catch (Exception e) {
            logger.warn("Failed", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public ArrayList<GwtFirewallOpenPortEntry> findDeviceFirewallOpenPorts(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallOpenPortEntry> gwtOpenPortEntries = new ArrayList<GwtFirewallOpenPortEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallOpenPortConfigIP4)) continue;
                    logger.debug("findDeviceFirewallOpenPorts() :: adding new Open Port Entry: {}", (Object)((FirewallOpenPortConfigIP4)netConfig).getPort());
                    GwtFirewallOpenPortEntry entry = new GwtFirewallOpenPortEntry();
                    if (((FirewallOpenPortConfigIP4)netConfig).getPortRange() != null) {
                        entry.setPortRange(((FirewallOpenPortConfigIP4)netConfig).getPortRange());
                    } else {
                        entry.setPortRange(String.valueOf(((FirewallOpenPortConfigIP4)netConfig).getPort()));
                    }
                    entry.setProtocol(((FirewallOpenPortConfigIP4)netConfig).getProtocol().toString());
                    entry.setPermittedNetwork(String.valueOf(((IP4Address)((FirewallOpenPortConfigIP4)netConfig).getPermittedNetwork().getIpAddress()).getHostAddress()) + "/" + ((FirewallOpenPortConfigIP4)netConfig).getPermittedNetwork().getPrefix());
                    entry.setPermittedInterfaceName(((FirewallOpenPortConfigIP4)netConfig).getPermittedInterfaceName());
                    entry.setUnpermittedInterfaceName(((FirewallOpenPortConfigIP4)netConfig).getUnpermittedInterfaceName());
                    entry.setPermittedMAC(((FirewallOpenPortConfigIP4)netConfig).getPermittedMac());
                    entry.setSourcePortRange(((FirewallOpenPortConfigIP4)netConfig).getSourcePortRange());
                    gwtOpenPortEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallOpenPortEntry>(gwtOpenPortEntries);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public ArrayList<GwtWifiHotspotEntry> findWifiHotspots(GwtXSRFToken xsrfToken, String interfaceName, String wirelessSsid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        ArrayList<GwtWifiHotspotEntry> gwtWifiHotspotsEntries = new ArrayList<GwtWifiHotspotEntry>();
        try {
            List wifiHotspotInfoList = nas.getWifiHotspotList(interfaceName);
            if (wifiHotspotInfoList != null) {
                for (WifiHotspotInfo wifiHotspotInfo : wifiHotspotInfoList) {
                    String ssid = GwtSafeHtmlUtils.htmlEscape(wifiHotspotInfo.getSsid());
                    if (wifiHotspotInfo.getChannel() > systemService.getKuraWifiTopChannel() || ssid == null || ssid.equals(wirelessSsid)) continue;
                    GwtWifiHotspotEntry gwtWifiHotspotEntry = new GwtWifiHotspotEntry();
                    gwtWifiHotspotEntry.setMacAddress(wifiHotspotInfo.getMacAddress());
                    gwtWifiHotspotEntry.setSSID(ssid);
                    gwtWifiHotspotEntry.setsignalStrength(wifiHotspotInfo.getSignalLevel());
                    gwtWifiHotspotEntry.setChannel(wifiHotspotInfo.getChannel());
                    gwtWifiHotspotEntry.setFrequency(wifiHotspotInfo.getFrequency());
                    if (wifiHotspotInfo.getSecurity() == WifiSecurity.NONE || wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_NONE) {
                        gwtWifiHotspotEntry.setSecurity("None");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WEP) {
                        gwtWifiHotspotEntry.setSecurity("WEP");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA) {
                        gwtWifiHotspotEntry.setSecurity("WPA");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA2) {
                        gwtWifiHotspotEntry.setSecurity("WPA2");
                    } else if (wifiHotspotInfo.getSecurity() == WifiSecurity.SECURITY_WPA_WPA2) {
                        gwtWifiHotspotEntry.setSecurity("WPA/WPA2");
                    }
                    GwtWifiCiphers gwtPairCiphers = null;
                    Enum gwtGroupCiphers = null;
                    EnumSet pairCiphers = wifiHotspotInfo.getPairCiphers();
                    for (WifiSecurity cipher : pairCiphers) {
                        if (gwtPairCiphers == null) {
                            if (cipher == WifiSecurity.PAIR_TKIP) {
                                gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_TKIP;
                                continue;
                            }
                            if (cipher != WifiSecurity.PAIR_CCMP) continue;
                            gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP;
                            continue;
                        }
                        if (gwtPairCiphers == GwtWifiCiphers.netWifiCiphers_TKIP) {
                            if (cipher != WifiSecurity.PAIR_CCMP) continue;
                            gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                            continue;
                        }
                        if (gwtPairCiphers != GwtWifiCiphers.netWifiCiphers_CCMP || cipher != WifiSecurity.PAIR_TKIP) continue;
                        gwtPairCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                    }
                    EnumSet groupCiphers = wifiHotspotInfo.getGroupCiphers();
                    for (WifiSecurity cipher : groupCiphers) {
                        if (gwtGroupCiphers == null) {
                            if (cipher == WifiSecurity.GROUP_TKIP) {
                                gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_TKIP;
                                continue;
                            }
                            if (cipher != WifiSecurity.GROUP_CCMP) continue;
                            gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP;
                            continue;
                        }
                        if (gwtGroupCiphers == GwtWifiCiphers.netWifiCiphers_TKIP) {
                            if (cipher != WifiSecurity.GROUP_CCMP) continue;
                            gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                            continue;
                        }
                        if (gwtGroupCiphers != GwtWifiCiphers.netWifiCiphers_CCMP || cipher != WifiSecurity.GROUP_TKIP) continue;
                        gwtGroupCiphers = GwtWifiCiphers.netWifiCiphers_CCMP_TKIP;
                    }
                    if (gwtPairCiphers != null) {
                        gwtWifiHotspotEntry.setPairwiseCiphers(gwtPairCiphers.name());
                    }
                    if (gwtGroupCiphers != null) {
                        gwtWifiHotspotEntry.setGroupCiphers(gwtGroupCiphers.name());
                    }
                    gwtWifiHotspotsEntries.add(gwtWifiHotspotEntry);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed", t);
            KuraExceptionHandler.handle(t);
        }
        return new ArrayList<GwtWifiHotspotEntry>(gwtWifiHotspotsEntries);
    }

    @Override
    public List<GwtModemPdpEntry> findPdpContextInfo(GwtXSRFToken xsrfToken, String interfaceName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ModemManagerService mms = ServiceLocator.getInstance().getService(ModemManagerService.class);
        try {
            return (List)this.withCellularModem(interfaceName, mms, m -> {
                GwtModemPdpEntry gwtModemPdpEntry;
                ArrayList<GwtModemPdpEntry> gwtModemPdpEntries = new ArrayList<GwtModemPdpEntry>();
                if (!m.isPresent()) {
                    return gwtModemPdpEntries;
                }
                CellularModem modem = (CellularModem)m.get();
                List pdpContextInfo = modem.getPdpContextInfo();
                int contextInd = 1;
                int firstAvailableContextNum = 0;
                for (ModemPdpContext pdpContextEntry : pdpContextInfo) {
                    gwtModemPdpEntry = new GwtModemPdpEntry();
                    gwtModemPdpEntry.setContextNumber(pdpContextEntry.getNumber());
                    gwtModemPdpEntry.setPdpType(pdpContextEntry.getType().getValue());
                    gwtModemPdpEntry.setApn(pdpContextEntry.getApn());
                    gwtModemPdpEntries.add(gwtModemPdpEntry);
                    if (firstAvailableContextNum == 0 && contextInd < pdpContextEntry.getNumber()) {
                        firstAvailableContextNum = contextInd;
                    }
                    ++contextInd;
                }
                if (firstAvailableContextNum == 0) {
                    firstAvailableContextNum = contextInd;
                }
                gwtModemPdpEntry = new GwtModemPdpEntry();
                gwtModemPdpEntry.setContextNumber(firstAvailableContextNum);
                gwtModemPdpEntry.setPdpType(ModemPdpContextType.IP.getValue());
                gwtModemPdpEntry.setApn("Please provide APN for this new PDP context ...");
                gwtModemPdpEntries.add(gwtModemPdpEntry);
                return gwtModemPdpEntries;
            });
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.WARNING, (Throwable)e);
        }
    }

    @Override
    public boolean verifyWifiCredentials(GwtXSRFToken xsrfToken, String interfaceName, GwtWifiConfig gwtWifiConfig) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (interfaceName == null || gwtWifiConfig == null) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_NULL_ARGUMENT);
        }
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        WifiConfig wifiConfig = this.getWifiConfig(gwtWifiConfig);
        return nas.verifyWifiCredentials(interfaceName, wifiConfig, 60);
    }

    public ArrayList<GwtFirewallPortForwardEntry> findDeviceFirewallPortForwards(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallPortForwardEntry> gwtPortForwardEntries = new ArrayList<GwtFirewallPortForwardEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallPortForwardConfigIP4)) continue;
                    logger.debug("findDeviceFirewallPortForwards() :: adding new Port Forward Entry");
                    GwtFirewallPortForwardEntry entry = new GwtFirewallPortForwardEntry();
                    entry.setInboundInterface(((FirewallPortForwardConfigIP4)netConfig).getInboundInterface());
                    entry.setOutboundInterface(((FirewallPortForwardConfigIP4)netConfig).getOutboundInterface());
                    entry.setAddress(((FirewallPortForwardConfigIP4)netConfig).getAddress().getHostAddress());
                    entry.setProtocol(((FirewallPortForwardConfigIP4)netConfig).getProtocol().toString());
                    entry.setInPort(((FirewallPortForwardConfigIP4)netConfig).getInPort());
                    entry.setOutPort(((FirewallPortForwardConfigIP4)netConfig).getOutPort());
                    String masquerade = ((FirewallPortForwardConfigIP4)netConfig).isMasquerade() ? "yes" : "no";
                    entry.setMasquerade(masquerade);
                    entry.setPermittedNetwork(((FirewallPortForwardConfigIP4)netConfig).getPermittedNetwork().toString());
                    entry.setPermittedMAC(((FirewallPortForwardConfigIP4)netConfig).getPermittedMac());
                    entry.setSourcePortRange(((FirewallPortForwardConfigIP4)netConfig).getSourcePortRange());
                    gwtPortForwardEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallPortForwardEntry>(gwtPortForwardEntries);
        }
        catch (KuraException e) {
            logger.warn("Failed", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public ArrayList<GwtFirewallNatEntry> findDeviceFirewallNATs(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<GwtFirewallNatEntry> gwtNatEntries = new ArrayList<GwtFirewallNatEntry>();
        try {
            List firewallConfigs = nas.getFirewallConfiguration();
            if (firewallConfigs != null && !firewallConfigs.isEmpty()) {
                for (NetConfig netConfig : firewallConfigs) {
                    if (!(netConfig instanceof FirewallNatConfig)) continue;
                    logger.debug("findDeviceFirewallNATs() :: adding new NAT Entry");
                    GwtFirewallNatEntry entry = new GwtFirewallNatEntry();
                    entry.setInInterface(((FirewallNatConfig)netConfig).getSourceInterface());
                    entry.setOutInterface(((FirewallNatConfig)netConfig).getDestinationInterface());
                    entry.setProtocol(((FirewallNatConfig)netConfig).getProtocol());
                    entry.setSourceNetwork(((FirewallNatConfig)netConfig).getSource());
                    entry.setDestinationNetwork(((FirewallNatConfig)netConfig).getDestination());
                    String masquerade = ((FirewallNatConfig)netConfig).isMasquerade() ? "yes" : "no";
                    entry.setMasquerade(masquerade);
                    gwtNatEntries.add(entry);
                }
            }
            return new ArrayList<GwtFirewallNatEntry>(gwtNatEntries);
        }
        catch (KuraException e) {
            logger.warn("Failed", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private List<NetConfig> getDhcpConfig(GwtNetInterfaceConfig config) throws KuraException {
        String routerMode = config.getRouterMode();
        if (routerMode.equals(GwtNetRouterMode.netRouterOff.name())) {
            logger.debug("DCHP and NAT are disabled");
            return null;
        }
        if (routerMode.equals(GwtNetRouterMode.netRouterDchp.name()) || routerMode.equals(GwtNetRouterMode.netRouterDchpNat.name()) || routerMode.equals(GwtNetRouterMode.netRouterNat.name())) {
            try {
                ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
                if (routerMode.equals(GwtNetRouterMode.netRouterDchp.name()) || routerMode.equals(GwtNetRouterMode.netRouterDchpNat.name())) {
                    int defaultLeaseTime = config.getRouterDhcpDefaultLease();
                    int maximumLeaseTime = config.getRouterDhcpMaxLease();
                    IP4Address routerAddress = (IP4Address)IPAddress.parseHostAddress((String)config.getIpAddress());
                    IP4Address rangeStart = (IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpBeginAddress());
                    IP4Address rangeEnd = (IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpEndAddress());
                    boolean passDns = config.getRouterDnsPass();
                    IP4Address subnetMask = (IP4Address)IPAddress.parseHostAddress((String)config.getRouterDhcpSubnetMask());
                    IP4Address subnet = (IP4Address)IPAddress.parseHostAddress((String)NetworkUtil.calculateNetwork((String)config.getIpAddress(), (String)config.getSubnetMask()));
                    short prefix = NetworkUtil.getNetmaskShortForm((String)subnetMask.getHostAddress());
                    ArrayList<IP4Address> dnsServers = new ArrayList<IP4Address>();
                    dnsServers.add((IP4Address)IPAddress.parseHostAddress((String)config.getIpAddress()));
                    logger.debug("DhcpServerConfigIP4 - start: {}, end: {}, prefix: {}, subnet: {}, subnetMask: {}", new Object[]{rangeStart.getHostAddress(), rangeEnd.getHostAddress(), prefix, subnet.getHostAddress(), subnetMask.getHostAddress()});
                    try {
                        DhcpServerCfg dhcpServerCfg = new DhcpServerCfg(config.getName(), true, defaultLeaseTime, maximumLeaseTime, passDns);
                        DhcpServerCfgIP4 dhcpServerCfgIP4 = new DhcpServerCfgIP4(subnet, subnetMask, prefix, routerAddress, rangeStart, rangeEnd, dnsServers);
                        netConfigs.add((NetConfig)new DhcpServerConfigIP4(dhcpServerCfg, dhcpServerCfgIP4));
                    }
                    catch (KuraException e) {
                        logger.error("Failed to create new DhcpServerConfigIP4 object. Please verify that DHCP pool IP addresses (see below) are in the {} subnet.", (Object)subnet.getHostAddress());
                        logger.error("DHCP Pool: range from {} to {}", (Object)rangeStart.getHostAddress(), (Object)rangeEnd.getHostAddress());
                        logger.error("Exception: ", (Throwable)e);
                    }
                }
                if (routerMode.equals(GwtNetRouterMode.netRouterDchpNat.name()) || routerMode.equals(GwtNetRouterMode.netRouterNat.name())) {
                    String sourceInterface = config.getName();
                    String destinationInterface = "unknown";
                    boolean masquerade = true;
                    FirewallAutoNatConfig natConfig = new FirewallAutoNatConfig(sourceInterface, destinationInterface, masquerade);
                    netConfigs.add((NetConfig)natConfig);
                }
                return netConfigs;
            }
            catch (Exception e) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
            }
        }
        logger.error("Unsupported routerMode: {}", (Object)routerMode);
        throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Unsupported routerMode: " + routerMode});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDeviceFirewallOpenPorts(GwtXSRFToken xsrfToken, List<GwtFirewallOpenPortEntry> entries) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<FirewallOpenPortConfigIP4> firewallOpenPortConfigIPs = new ArrayList<FirewallOpenPortConfigIP4>();
        logger.debug("updating open ports");
        try {
            for (GwtFirewallOpenPortEntry entry : entries) {
                String network = null;
                String prefix = null;
                if (entry.getPermittedNetwork() != null) {
                    String[] parts = entry.getPermittedNetwork().split("/");
                    network = parts[0];
                    prefix = parts[1];
                }
                FirewallOpenPortConfigIP4 firewallOpenPortConfigIP = new FirewallOpenPortConfigIP4();
                if (entry.getPortRange().indexOf(58) != -1) {
                    String[] parts = entry.getPortRange().split(":");
                    if (Integer.valueOf(parts[0].trim()) >= Integer.valueOf(parts[1].trim())) throw new KuraException(KuraErrorCode.BAD_REQUEST);
                    firewallOpenPortConfigIP.setPortRange(entry.getPortRange());
                } else {
                    firewallOpenPortConfigIP.setPort(Integer.parseInt(entry.getPortRange()));
                }
                firewallOpenPortConfigIP.setProtocol(NetProtocol.valueOf((String)GwtSafeHtmlUtils.htmlEscape(entry.getProtocol())));
                if (network != null && prefix != null) {
                    firewallOpenPortConfigIP.setPermittedNetwork(new NetworkPair((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)network)), Short.parseShort(prefix)));
                }
                firewallOpenPortConfigIP.setPermittedInterfaceName(GwtSafeHtmlUtils.htmlEscape(entry.getPermittedInterfaceName()));
                firewallOpenPortConfigIP.setUnpermittedInterfaceName(GwtSafeHtmlUtils.htmlEscape(entry.getUnpermittedInterfaceName()));
                firewallOpenPortConfigIP.setPermittedMac(GwtSafeHtmlUtils.htmlEscape(entry.getPermittedMAC()));
                firewallOpenPortConfigIP.setSourcePortRange(GwtSafeHtmlUtils.htmlEscape(entry.getSourcePortRange()));
                logger.debug("adding open port entry for {}", (Object)entry.getPortRange());
                firewallOpenPortConfigIPs.add(firewallOpenPortConfigIP);
            }
            nas.setFirewallOpenPortConfiguration(firewallOpenPortConfigIPs);
            return;
        }
        catch (NumberFormatException | UnknownHostException | KuraException e) {
            logger.warn("Exception while updating firewall open ports", e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    @Override
    public void updateDeviceFirewallPortForwards(GwtXSRFToken xsrfToken, List<GwtFirewallPortForwardEntry> entries) throws GwtKuraException {
        logger.debug("updateDeviceFirewallPortForwards() :: updating port forward entries");
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<FirewallPortForwardConfigIP4> firewallPortForwardConfigIPs = new ArrayList<FirewallPortForwardConfigIP4>();
        try {
            for (GwtFirewallPortForwardEntry entry : entries) {
                String network = null;
                String prefix = null;
                if (entry.getPermittedNetwork() != null) {
                    String[] parts = entry.getPermittedNetwork().split("/");
                    network = parts[0];
                    prefix = parts[1];
                }
                FirewallPortForwardConfigIP4 firewallPortForwardConfigIP = new FirewallPortForwardConfigIP4();
                firewallPortForwardConfigIP.setInboundInterface(GwtSafeHtmlUtils.htmlEscape(entry.getInboundInterface()));
                firewallPortForwardConfigIP.setOutboundInterface(GwtSafeHtmlUtils.htmlEscape(entry.getOutboundInterface()));
                firewallPortForwardConfigIP.setAddress((IP4Address)IPAddress.parseHostAddress((String)GwtSafeHtmlUtils.htmlEscape(entry.getAddress())));
                firewallPortForwardConfigIP.setProtocol(NetProtocol.valueOf((String)GwtSafeHtmlUtils.htmlEscape(entry.getProtocol())));
                firewallPortForwardConfigIP.setInPort(entry.getInPort().intValue());
                firewallPortForwardConfigIP.setOutPort(entry.getOutPort().intValue());
                boolean masquerade = entry.getMasquerade().equals("yes");
                firewallPortForwardConfigIP.setMasquerade(masquerade);
                if (network != null && prefix != null) {
                    firewallPortForwardConfigIP.setPermittedNetwork(new NetworkPair((IPAddress)((IP4Address)IPAddress.parseHostAddress((String)network)), Short.parseShort(prefix)));
                }
                firewallPortForwardConfigIP.setPermittedMac(GwtSafeHtmlUtils.htmlEscape(entry.getPermittedMAC()));
                firewallPortForwardConfigIP.setSourcePortRange(GwtSafeHtmlUtils.htmlEscape(entry.getSourcePortRange()));
                logger.debug("adding port forward entry for inbound iface {} - port {}", (Object)GwtSafeHtmlUtils.htmlEscape(entry.getInboundInterface()), (Object)entry.getInPort());
                firewallPortForwardConfigIPs.add(firewallPortForwardConfigIP);
            }
            nas.setFirewallPortForwardingConfiguration(firewallPortForwardConfigIPs);
        }
        catch (NumberFormatException | UnknownHostException | KuraException e) {
            logger.warn("Exception while updating firewall port forwards", e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, e);
        }
    }

    @Override
    public void updateDeviceFirewallNATs(GwtXSRFToken xsrfToken, List<GwtFirewallNatEntry> entries) throws GwtKuraException {
        logger.debug("updateDeviceFirewallNATs() :: updating NAT entries");
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        ArrayList<FirewallNatConfig> firewallNatConfigs = new ArrayList<FirewallNatConfig>();
        for (GwtFirewallNatEntry entry : entries) {
            String srcNetwork = GwtSafeHtmlUtils.htmlEscape(entry.getSourceNetwork());
            String dstNetwork = GwtSafeHtmlUtils.htmlEscape(entry.getDestinationNetwork());
            if (srcNetwork == null || "".equals(srcNetwork)) {
                srcNetwork = "0.0.0.0/0";
            }
            if (dstNetwork == null || "".equals(dstNetwork)) {
                dstNetwork = "0.0.0.0/0";
            }
            boolean masquerade = entry.getMasquerade().equals("yes");
            FirewallNatConfig firewallNatConfig = new FirewallNatConfig(GwtSafeHtmlUtils.htmlEscape(entry.getInInterface()), GwtSafeHtmlUtils.htmlEscape(entry.getOutInterface()), GwtSafeHtmlUtils.htmlEscape(entry.getProtocol()), srcNetwork, dstNetwork, masquerade, RuleType.IP_FORWARDING);
            firewallNatConfigs.add(firewallNatConfig);
        }
        try {
            nas.setFirewallNatConfiguration(firewallNatConfigs);
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public void renewDhcpLease(GwtXSRFToken xsrfToken, String interfaceName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            nas.renewDhcpLease(GwtSafeHtmlUtils.htmlEscape(interfaceName));
        }
        catch (KuraException e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private WifiConfig getWifiConfig(GwtWifiConfig gwtWifiConfig) {
        WifiCiphers wifiGroupCiphers;
        WifiConfig wifiConfig = new WifiConfig();
        WifiMode wifiMode = this.getWifiConfigWirelessMode(gwtWifiConfig.getWirelessMode());
        wifiConfig.setMode(wifiMode);
        wifiConfig.setSSID(GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getWirelessSsid()));
        wifiConfig.setDriver(gwtWifiConfig.getDriver());
        WifiRadioMode wifiRadioMode = this.getWifiConfigRadioMode(gwtWifiConfig.getRadioModeEnum());
        wifiConfig.setRadioMode(wifiRadioMode);
        String hardwareMode = this.getWifiConfigHardwareMode(gwtWifiConfig.getRadioModeEnum());
        wifiConfig.setHardwareMode(hardwareMode);
        int[] wifiConfigChannels = this.getWifiConfigChannels(gwtWifiConfig.getChannels());
        if (wifiConfigChannels.length > 0) {
            wifiConfig.setChannels(wifiConfigChannels);
        }
        WifiSecurity wifiSecurity = this.getWifiConfigSecurity(gwtWifiConfig.getSecurity());
        wifiConfig.setSecurity(wifiSecurity);
        WifiCiphers wifiPairwiseCiphers = this.getWifiConfigCiphers(gwtWifiConfig.getPairwiseCiphers());
        if (wifiPairwiseCiphers != null) {
            wifiConfig.setPairwiseCiphers(wifiPairwiseCiphers);
        }
        if ((wifiGroupCiphers = this.getWifiConfigCiphers(gwtWifiConfig.getGroupCiphers())) != null) {
            wifiConfig.setGroupCiphers(wifiGroupCiphers);
        }
        WifiBgscan wifiBgscan = this.getWifiConfigBgscan(gwtWifiConfig, gwtWifiConfig.getBgscanModule());
        wifiConfig.setBgscan(wifiBgscan);
        wifiConfig.setPasskey(GwtSafeHtmlUtils.htmlUnescape(gwtWifiConfig.getPassword()));
        wifiConfig.setPingAccessPoint(gwtWifiConfig.pingAccessPoint());
        wifiConfig.setIgnoreSSID(gwtWifiConfig.ignoreSSID());
        wifiConfig.setBroadcast(!gwtWifiConfig.ignoreSSID());
        return wifiConfig;
    }

    private WifiBgscan getWifiConfigBgscan(GwtWifiConfig gwtWifiConfig, String bgscanModule) {
        WifiBgscanModule wifiBgscanModule = null;
        if (GwtWifiBgscanModule.netWifiBgscanMode_NONE.name().equals(bgscanModule)) {
            wifiBgscanModule = WifiBgscanModule.NONE;
        } else if (GwtWifiBgscanModule.netWifiBgscanMode_SIMPLE.name().equals(bgscanModule)) {
            wifiBgscanModule = WifiBgscanModule.SIMPLE;
        } else if (GwtWifiBgscanModule.netWifiBgscanMode_LEARN.name().equals(bgscanModule)) {
            wifiBgscanModule = WifiBgscanModule.LEARN;
        }
        int bgscanRssiThreshold = gwtWifiConfig.getBgscanRssiThreshold();
        int bgscanShortInterval = gwtWifiConfig.getBgscanShortInterval();
        int bgscanLongInterval = gwtWifiConfig.getBgscanLongInterval();
        return new WifiBgscan(wifiBgscanModule, bgscanShortInterval, bgscanRssiThreshold, bgscanLongInterval);
    }

    private WifiCiphers getWifiConfigCiphers(String ciphers) {
        WifiCiphers wifiCiphers = null;
        if (GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name().equals(ciphers)) {
            wifiCiphers = WifiCiphers.CCMP_TKIP;
        } else if (GwtWifiCiphers.netWifiCiphers_TKIP.name().equals(ciphers)) {
            wifiCiphers = WifiCiphers.TKIP;
        } else if (GwtWifiCiphers.netWifiCiphers_CCMP.name().equals(ciphers)) {
            wifiCiphers = WifiCiphers.CCMP;
        }
        return wifiCiphers;
    }

    private WifiSecurity getWifiConfigSecurity(String security) {
        WifiSecurity wifiSecurity = GwtWifiSecurity.netWifiSecurityWPA.name().equals(security) ? WifiSecurity.SECURITY_WPA : (GwtWifiSecurity.netWifiSecurityWPA2.name().equals(security) ? WifiSecurity.SECURITY_WPA2 : (GwtWifiSecurity.netWifiSecurityWPA_WPA2.name().equals(security) ? WifiSecurity.SECURITY_WPA_WPA2 : (GwtWifiSecurity.netWifiSecurityWEP.name().equals(security) ? WifiSecurity.SECURITY_WEP : WifiSecurity.SECURITY_NONE)));
        return wifiSecurity;
    }

    private int[] getWifiConfigChannels(List<Integer> alChannels) {
        if (alChannels == null) {
            return new int[0];
        }
        int[] channels = new int[alChannels.size()];
        int i = 0;
        while (i < channels.length) {
            channels[i] = alChannels.get(i);
            ++i;
        }
        return channels;
    }

    private WifiRadioMode getWifiConfigRadioMode(GwtWifiRadioMode radioMode) {
        WifiRadioMode wifiRadioMode = radioMode == GwtWifiRadioMode.netWifiRadioModeA ? WifiRadioMode.RADIO_MODE_80211a : (radioMode.equals((Object)GwtWifiRadioMode.netWifiRadioModeB) ? WifiRadioMode.RADIO_MODE_80211b : (radioMode.equals((Object)GwtWifiRadioMode.netWifiRadioModeBG) ? WifiRadioMode.RADIO_MODE_80211g : WifiRadioMode.RADIO_MODE_80211nHT20));
        return wifiRadioMode;
    }

    private String getWifiConfigHardwareMode(GwtWifiRadioMode radioMode) {
        String hardwareMode = radioMode == GwtWifiRadioMode.netWifiRadioModeA ? "a" : (radioMode == GwtWifiRadioMode.netWifiRadioModeB ? "b" : (radioMode == GwtWifiRadioMode.netWifiRadioModeBG ? "g" : "n"));
        return hardwareMode;
    }

    private WifiMode getWifiConfigWirelessMode(String mode) {
        WifiMode wifiMode = mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name()) ? WifiMode.MASTER : (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeStation.name()) ? WifiMode.INFRA : (mode != null && mode.equals(GwtWifiWirelessMode.netWifiWirelessModeAdHoc.name()) ? WifiMode.ADHOC : WifiMode.UNKNOWN));
        return wifiMode;
    }

    private <T> T withCellularModem(String interfaceName, ModemManagerService modemManagerService, ModemManagerService.ModemFunction<Optional<CellularModem>, T> function) throws KuraException {
        Optional result = (Optional)modemManagerService.withModemService(interfaceName, m -> {
            if (m.isPresent()) {
                return Optional.of(function.apply(m));
            }
            return Optional.empty();
        });
        if (result.isPresent()) {
            return result.get();
        }
        return (T)modemManagerService.withAllModemServices(m -> {
            for (CellularModem modem : m) {
                if (!this.isModemForNetworkInterface(interfaceName, modem)) continue;
                return function.apply(Optional.of(modem));
            }
            return function.apply(Optional.empty());
        });
    }

    private boolean isModemForNetworkInterface(String ifaceName, CellularModem modemService) {
        List netConfigs = modemService.getConfiguration();
        for (NetConfig netConfig : netConfigs) {
            ModemConfig modemConfig;
            String interfaceName;
            if (!(netConfig instanceof ModemConfig) || !(interfaceName = "ppp" + (modemConfig = (ModemConfig)netConfig).getPppNumber()).equals(ifaceName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<GwtWifiHotspotEntry> findFrequencies(GwtXSRFToken xsrfToken, String interfaceName) throws GwtKuraException {
        logger.debug("Find Frequency Network Service impl");
        ArrayList<GwtWifiHotspotEntry> channels = new ArrayList<GwtWifiHotspotEntry>();
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            List frequencies = nas.getWifiFrequencies(interfaceName);
            for (WifiChannel freq : frequencies) {
                logger.debug(freq.toString());
                GwtWifiHotspotEntry channelFrequency = new GwtWifiHotspotEntry();
                channelFrequency.setChannel(freq.getChannel());
                channelFrequency.setFrequency(freq.getFrequency());
                channels.add(channelFrequency);
            }
            return channels;
        }
        catch (KuraException e) {
            logger.error("Find Frequency exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public String getWifiCountryCode(GwtXSRFToken xsrfToken) throws GwtKuraException {
        logger.info("Get Wifi Country Code impl");
        NetworkAdminService nas = ServiceLocator.getInstance().getService(NetworkAdminService.class);
        try {
            return nas.getWifiCountryCode();
        }
        catch (KuraException e) {
            logger.error("Get Wifi Country Code exception");
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void validateUserPassword(String password) throws GwtKuraException {
        List<Validator<String>> validators = PasswordStrengthValidators.fromConfig(Console.getConsoleOptions().getUserOptions());
        ArrayList errors = new ArrayList();
        for (Validator<String> validator : validators) {
            validator.validate(password, errors::add);
        }
        if (!errors.isEmpty()) {
            logger.warn("password strenght requirements not satisfied: {}", errors);
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }
}

