/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.exceptions.IdConversionException;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpCodec;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.jms.provider.amqp.message.AmqpHeader;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessagePropertyIntercepter;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageIdHelper;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public class AmqpJmsMessageFacade
implements JmsMessageFacade {
    private static final long UINT_MAX = 0xFFFFFFFFL;
    protected AmqpConnection connection;
    private Properties properties;
    private final AmqpHeader header = new AmqpHeader();
    private Section body;
    private Map<Symbol, Object> messageAnnotationsMap;
    private Map<String, Object> applicationPropertiesMap;
    private Map<Symbol, Object> deliveryAnnotationsMap;
    private Map<Symbol, Object> footerMap;
    private JmsDestination replyTo;
    private JmsDestination destination;
    private JmsDestination consumerDestination;
    private Long syntheticExpiration;
    private long syntheticDeliveryTime;
    private Long userSpecifiedTTL = null;

    public void initialize(AmqpConnection connection) {
        this.connection = connection;
        this.setMessageAnnotation("x-opt-jms-msg-type", this.getJmsMsgType());
        this.setPersistent(true);
        this.initializeEmptyBody();
    }

    public void initialize(AmqpConsumer consumer) {
        this.connection = consumer.getConnection();
        this.consumerDestination = consumer.getDestination();
        Long ttl = this.getTtl();
        Long absoluteExpiryTime = this.getAbsoluteExpiryTime();
        if (absoluteExpiryTime == null && ttl != null) {
            this.syntheticExpiration = System.currentTimeMillis() + ttl;
        }
        if (this.getMessageAnnotation("x-opt-delivery-time") == null) {
            this.syntheticDeliveryTime = this.getTimestamp();
        }
    }

    protected void initializeEmptyBody() {
    }

    public byte getJmsMsgType() {
        return 0;
    }

    public String getContentType() {
        if (this.properties != null && this.properties.getContentType() != null) {
            return this.properties.getContentType().toString();
        }
        return null;
    }

    public void setContentType(String value) {
        if (this.properties == null) {
            if (value == null) {
                return;
            }
            this.lazyCreateProperties();
        }
        this.properties.setContentType(Symbol.valueOf((String)value));
    }

    @Override
    public boolean propertyExists(String key) throws JMSException {
        return AmqpJmsMessagePropertyIntercepter.propertyExists(this, key);
    }

    public boolean applicationPropertyExists(String key) throws JMSException {
        if (this.applicationPropertiesMap != null) {
            return this.applicationPropertiesMap.containsKey(key);
        }
        return false;
    }

    @Override
    public Set<String> getPropertyNames() {
        return AmqpJmsMessagePropertyIntercepter.getPropertyNames(this);
    }

    public Set<String> getApplicationPropertyNames(Set<String> propertyNames) {
        if (this.applicationPropertiesMap != null) {
            propertyNames.addAll(this.applicationPropertiesMap.keySet());
        }
        return propertyNames;
    }

    @Override
    public Object getProperty(String key) throws JMSException {
        return AmqpJmsMessagePropertyIntercepter.getProperty(this, key);
    }

    public Object getApplicationProperty(String key) throws JMSException {
        if (this.applicationPropertiesMap != null) {
            return this.applicationPropertiesMap.get(key);
        }
        return null;
    }

    @Override
    public void setProperty(String key, Object value) throws JMSException {
        if (key == null) {
            throw new IllegalArgumentException("Property key must not be null");
        }
        AmqpJmsMessagePropertyIntercepter.setProperty(this, key, value);
    }

    public void setApplicationProperty(String key, Object value) throws JMSException {
        this.lazyCreateApplicationProperties();
        this.applicationPropertiesMap.put(key, value);
    }

    @Override
    public void onSend(long producerTtl) throws JMSException {
        long ttl = 0L;
        ttl = this.hasAmqpTimeToLiveOverride() ? this.getAmqpTimeToLiveOverride() : producerTtl;
        this.header.setTimeToLive(ttl);
        this.setMessageAnnotation("x-opt-jms-msg-type", this.getJmsMsgType());
    }

    @Override
    public void onDispatch() throws JMSException {
    }

    @Override
    public void clearBody() {
        this.setBody(null);
    }

    @Override
    public void clearProperties() throws JMSException {
        AmqpJmsMessagePropertyIntercepter.clearProperties(this);
    }

    @Override
    public AmqpJmsMessageFacade copy() throws JMSException {
        AmqpJmsMessageFacade copy = new AmqpJmsMessageFacade();
        this.copyInto(copy);
        return copy;
    }

    protected void copyInto(AmqpJmsMessageFacade target) {
        target.connection = this.connection;
        target.consumerDestination = this.consumerDestination;
        target.syntheticExpiration = this.syntheticExpiration;
        target.syntheticDeliveryTime = this.syntheticDeliveryTime;
        target.userSpecifiedTTL = this.userSpecifiedTTL;
        if (this.destination != null) {
            target.setDestination(this.destination);
        }
        if (this.replyTo != null) {
            target.setReplyTo(this.replyTo);
        }
        target.setAmqpHeader(this.header);
        if (this.properties != null) {
            target.setProperties(new Properties(this.properties));
        }
        target.setBody(this.body);
        if (this.deliveryAnnotationsMap != null) {
            target.lazyCreateDeliveryAnnotations();
            target.deliveryAnnotationsMap.putAll(this.deliveryAnnotationsMap);
        }
        if (this.applicationPropertiesMap != null) {
            target.lazyCreateApplicationProperties();
            target.applicationPropertiesMap.putAll(this.applicationPropertiesMap);
        }
        if (this.messageAnnotationsMap != null) {
            target.lazyCreateMessageAnnotations();
            target.messageAnnotationsMap.putAll(this.messageAnnotationsMap);
        }
        if (this.footerMap != null) {
            target.lazyCreateFooter();
            target.footerMap.putAll(this.footerMap);
        }
    }

    @Override
    public String getMessageId() {
        Object underlying = null;
        if (this.properties != null) {
            underlying = this.properties.getMessageId();
        }
        return AmqpMessageIdHelper.INSTANCE.toMessageIdString(underlying);
    }

    @Override
    public Object getProviderMessageIdObject() {
        return this.properties == null ? null : this.properties.getMessageId();
    }

    @Override
    public void setProviderMessageIdObject(Object messageId) {
        if (this.properties == null) {
            if (messageId == null) {
                return;
            }
            this.lazyCreateProperties();
        }
        this.properties.setMessageId(messageId);
    }

    @Override
    public void setMessageId(String messageId) throws IdConversionException {
        Object value = AmqpMessageIdHelper.INSTANCE.toIdObject(messageId);
        if (this.properties == null) {
            if (value == null) {
                return;
            }
            this.lazyCreateProperties();
        }
        this.properties.setMessageId(value);
    }

    @Override
    public long getTimestamp() {
        Date timestamp;
        if (this.properties != null && (timestamp = this.properties.getCreationTime()) != null) {
            return timestamp.getTime();
        }
        return 0L;
    }

    @Override
    public void setTimestamp(long timestamp) {
        if (this.properties == null) {
            if (timestamp == 0L) {
                return;
            }
            this.lazyCreateProperties();
        }
        if (timestamp == 0L) {
            this.properties.setCreationTime(null);
        } else {
            this.properties.setCreationTime(new Date(timestamp));
        }
    }

    @Override
    public String getCorrelationId() {
        if (this.properties == null) {
            return null;
        }
        return AmqpMessageIdHelper.INSTANCE.toCorrelationIdString(this.properties.getCorrelationId());
    }

    @Override
    public void setCorrelationId(String correlationId) throws IdConversionException {
        Object idObject = null;
        if (correlationId != null) {
            idObject = AmqpMessageIdHelper.INSTANCE.hasMessageIdPrefix(correlationId) ? AmqpMessageIdHelper.INSTANCE.toIdObject(correlationId) : correlationId;
        }
        if (this.properties == null) {
            if (idObject == null) {
                return;
            }
            this.lazyCreateProperties();
        }
        this.properties.setCorrelationId(idObject);
    }

    @Override
    public byte[] getCorrelationIdBytes() throws JMSException {
        Object correlationId = null;
        if (this.properties != null) {
            correlationId = this.properties.getCorrelationId();
        }
        if (correlationId == null) {
            return null;
        }
        if (correlationId instanceof Binary) {
            ByteBuffer dup = ((Binary)correlationId).asByteBuffer();
            byte[] bytes = new byte[dup.remaining()];
            dup.get(bytes);
            return bytes;
        }
        throw new JMSException("The underlying correlation-id is not binary and so can't be returned");
    }

    @Override
    public void setCorrelationIdBytes(byte[] correlationId) {
        Binary binaryIdValue = null;
        if (correlationId != null) {
            binaryIdValue = new Binary(Arrays.copyOf(correlationId, correlationId.length));
        }
        if (this.properties == null) {
            if (binaryIdValue == null) {
                return;
            }
            this.lazyCreateProperties();
        }
        this.properties.setCorrelationId(binaryIdValue);
    }

    @Override
    public boolean isPersistent() {
        return this.header.isDurable();
    }

    @Override
    public void setPersistent(boolean value) {
        this.header.setDurable(value);
    }

    @Override
    public int getDeliveryCount() {
        return this.getRedeliveryCount() + 1;
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.setRedeliveryCount(deliveryCount - 1);
    }

    @Override
    public int getRedeliveryCount() {
        return this.header.getDeliveryCount();
    }

    @Override
    public void setRedeliveryCount(int redeliveryCount) {
        this.header.setDeliveryCount(redeliveryCount);
    }

    @Override
    public boolean isRedelivered() {
        return this.getRedeliveryCount() > 0;
    }

    @Override
    public void setRedelivered(boolean redelivered) {
        if (redelivered) {
            if (!this.isRedelivered()) {
                this.setRedeliveryCount(1);
            }
        } else if (this.isRedelivered()) {
            this.setRedeliveryCount(0);
        }
    }

    @Override
    public String getType() {
        if (this.properties != null) {
            return this.properties.getSubject();
        }
        return null;
    }

    @Override
    public void setType(String type) {
        if (type != null) {
            this.lazyCreateProperties();
            this.properties.setSubject(type);
        } else if (this.properties != null) {
            this.properties.setSubject(null);
        }
    }

    @Override
    public int getPriority() {
        return this.header.getPriority();
    }

    @Override
    public void setPriority(int priority) {
        this.header.setPriority(priority);
    }

    @Override
    public long getExpiration() {
        Long absoluteExpiry = this.getAbsoluteExpiryTime();
        if (absoluteExpiry != null) {
            return absoluteExpiry;
        }
        if (this.syntheticExpiration != null) {
            return this.syntheticExpiration;
        }
        return 0L;
    }

    @Override
    public void setExpiration(long expiration) {
        this.syntheticExpiration = null;
        if (expiration != 0L) {
            this.setAbsoluteExpiryTime(expiration);
        } else {
            this.setAbsoluteExpiryTime(null);
        }
    }

    @Override
    public long getDeliveryTime() {
        Object deliveryTime = this.getMessageAnnotation("x-opt-delivery-time");
        if (deliveryTime != null) {
            return (Long)deliveryTime;
        }
        return this.syntheticDeliveryTime;
    }

    @Override
    public void setDeliveryTime(long deliveryTime, boolean transmit) {
        if (deliveryTime != 0L && transmit) {
            this.syntheticDeliveryTime = 0L;
            this.setMessageAnnotation("x-opt-delivery-time", deliveryTime);
        } else {
            this.syntheticDeliveryTime = deliveryTime;
            this.removeMessageAnnotation("x-opt-delivery-time");
        }
    }

    @Override
    public boolean isDeliveryTimeTransmitted() {
        return this.getMessageAnnotation("x-opt-delivery-time") != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAmqpTimeToLiveOverride(Long ttl) throws MessageFormatException {
        if (ttl != null) {
            if (ttl < 0L || ttl > 0xFFFFFFFFL) throw new MessageFormatException("JMS_AMQP_TTL must be a long with value in range 0 to 2^32 - 1");
            this.userSpecifiedTTL = ttl;
            return;
        } else {
            this.userSpecifiedTTL = null;
        }
    }

    public boolean hasAmqpTimeToLiveOverride() {
        return this.userSpecifiedTTL != null;
    }

    public long getAmqpTimeToLiveOverride() {
        return this.userSpecifiedTTL != null ? this.userSpecifiedTTL : 0L;
    }

    @Override
    public JmsDestination getDestination() {
        if (this.destination == null) {
            this.destination = AmqpDestinationHelper.INSTANCE.getJmsDestination(this, this.consumerDestination);
        }
        return this.destination;
    }

    @Override
    public void setDestination(JmsDestination destination) {
        this.destination = destination;
        this.lazyCreateMessageAnnotations();
        AmqpDestinationHelper.INSTANCE.setToAddressFromDestination(this, destination);
    }

    @Override
    public JmsDestination getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = AmqpDestinationHelper.INSTANCE.getJmsReplyTo(this, this.consumerDestination);
        }
        return this.replyTo;
    }

    @Override
    public void setReplyTo(JmsDestination replyTo) {
        this.replyTo = replyTo;
        this.lazyCreateMessageAnnotations();
        AmqpDestinationHelper.INSTANCE.setReplyToAddressFromDestination(this, replyTo);
    }

    public void setReplyToGroupId(String replyToGroupId) {
        if (replyToGroupId != null) {
            this.lazyCreateProperties();
            this.properties.setReplyToGroupId(replyToGroupId);
        } else if (this.properties != null) {
            this.properties.setReplyToGroupId(null);
        }
    }

    public String getReplyToGroupId() {
        if (this.properties != null) {
            return this.properties.getReplyToGroupId();
        }
        return null;
    }

    @Override
    public String getUserId() {
        Binary userIdBytes;
        String userId = null;
        if (this.properties != null && this.properties.getUserId() != null && (userIdBytes = this.properties.getUserId()).getLength() != 0) {
            userId = new String(userIdBytes.getArray(), userIdBytes.getArrayOffset(), userIdBytes.getLength(), StandardCharsets.UTF_8);
        }
        return userId;
    }

    @Override
    public void setUserId(String userId) {
        byte[] bytes = null;
        if (userId != null) {
            bytes = userId.getBytes(StandardCharsets.UTF_8);
        }
        if (bytes == null) {
            if (this.properties != null) {
                this.properties.setUserId(null);
            }
        } else {
            this.lazyCreateProperties();
            this.properties.setUserId(new Binary(bytes));
        }
    }

    @Override
    public byte[] getUserIdBytes() {
        if (this.properties == null || this.properties.getUserId() == null) {
            return null;
        }
        Binary userId = this.properties.getUserId();
        byte[] id = new byte[userId.getLength()];
        System.arraycopy(userId.getArray(), userId.getArrayOffset(), id, 0, userId.getLength());
        return id;
    }

    @Override
    public void setUserIdBytes(byte[] userId) {
        if (userId == null || userId.length == 0) {
            if (this.properties != null) {
                this.properties.setUserId(null);
            }
        } else {
            this.lazyCreateProperties();
            byte[] id = new byte[userId.length];
            System.arraycopy(userId, 0, id, 0, userId.length);
            this.properties.setUserId(new Binary(id));
        }
    }

    @Override
    public String getGroupId() {
        if (this.properties != null) {
            return this.properties.getGroupId();
        }
        return null;
    }

    @Override
    public void setGroupId(String groupId) {
        if (groupId != null) {
            this.lazyCreateProperties();
            this.properties.setGroupId(groupId);
        } else if (this.properties != null) {
            this.properties.setGroupId(null);
        }
    }

    @Override
    public int getGroupSequence() {
        UnsignedInteger groupSeqUint;
        if (this.properties != null && (groupSeqUint = this.properties.getGroupSequence()) != null) {
            return groupSeqUint.intValue();
        }
        return 0;
    }

    @Override
    public void setGroupSequence(int groupSequence) {
        if (groupSequence != 0) {
            this.lazyCreateProperties();
            this.properties.setGroupSequence(UnsignedInteger.valueOf((int)groupSequence));
        } else if (this.properties != null) {
            this.properties.setGroupSequence(null);
        }
    }

    @Override
    public boolean hasBody() {
        return this.body != null;
    }

    AmqpConnection getConnection() {
        return this.connection;
    }

    boolean messageAnnotationExists(String key) {
        if (this.messageAnnotationsMap == null) {
            return false;
        }
        return this.messageAnnotationsMap.containsKey(AmqpMessageSupport.getSymbol(key));
    }

    Object getMessageAnnotation(String key) {
        if (this.messageAnnotationsMap == null) {
            return null;
        }
        return this.messageAnnotationsMap.get(AmqpMessageSupport.getSymbol(key));
    }

    void removeMessageAnnotation(String key) {
        if (this.messageAnnotationsMap == null) {
            return;
        }
        this.messageAnnotationsMap.remove(AmqpMessageSupport.getSymbol(key));
    }

    void setMessageAnnotation(String key, Object value) {
        this.lazyCreateMessageAnnotations();
        this.messageAnnotationsMap.put(AmqpMessageSupport.getSymbol(key), value);
    }

    void clearMessageAnnotations() {
        this.messageAnnotationsMap = null;
    }

    void clearAllApplicationProperties() {
        this.applicationPropertiesMap = null;
    }

    String getToAddress() {
        if (this.properties != null) {
            return this.properties.getTo();
        }
        return null;
    }

    void setToAddress(String address) {
        if (address != null) {
            this.lazyCreateProperties();
            this.properties.setTo(address);
        } else if (this.properties != null) {
            this.properties.setTo(null);
        }
    }

    String getReplyToAddress() {
        if (this.properties != null) {
            return this.properties.getReplyTo();
        }
        return null;
    }

    void setReplyToAddress(String address) {
        if (address != null) {
            this.lazyCreateProperties();
            this.properties.setReplyTo(address);
        } else if (this.properties != null) {
            this.properties.setReplyTo(null);
        }
    }

    JmsDestination getConsumerDestination() {
        return this.consumerDestination;
    }

    public JmsMessage asJmsMessage() {
        return new JmsMessage(this);
    }

    public ByteBuf encodeMessage() {
        return AmqpCodec.encodeMessage(this);
    }

    AmqpHeader getAmqpHeader() {
        return this.header;
    }

    void setAmqpHeader(AmqpHeader header) {
        this.header.setHeader(header);
    }

    Header getHeader() {
        return this.header.getHeader();
    }

    void setHeader(Header header) {
        this.header.setHeader(header);
    }

    Properties getProperties() {
        return this.properties;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    Section getBody() {
        return this.body;
    }

    void setBody(Section body) {
        this.body = body;
    }

    MessageAnnotations getMessageAnnotations() {
        MessageAnnotations result = null;
        if (this.messageAnnotationsMap != null && !this.messageAnnotationsMap.isEmpty()) {
            result = new MessageAnnotations(this.messageAnnotationsMap);
        }
        return result;
    }

    void setMessageAnnotations(MessageAnnotations messageAnnotations) {
        if (messageAnnotations != null) {
            this.messageAnnotationsMap = messageAnnotations.getValue();
        }
    }

    DeliveryAnnotations getDeliveryAnnotations() {
        DeliveryAnnotations result = null;
        if (this.deliveryAnnotationsMap != null && !this.deliveryAnnotationsMap.isEmpty()) {
            result = new DeliveryAnnotations(this.deliveryAnnotationsMap);
        }
        return result;
    }

    void setDeliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
        if (deliveryAnnotations != null) {
            this.deliveryAnnotationsMap = deliveryAnnotations.getValue();
        }
    }

    ApplicationProperties getApplicationProperties() {
        ApplicationProperties result = null;
        if (this.applicationPropertiesMap != null && !this.applicationPropertiesMap.isEmpty()) {
            result = new ApplicationProperties(this.applicationPropertiesMap);
        }
        return result;
    }

    void setApplicationProperties(ApplicationProperties applicationProperties) {
        if (applicationProperties != null) {
            this.applicationPropertiesMap = applicationProperties.getValue();
        }
    }

    Footer getFooter() {
        Footer result = null;
        if (this.footerMap != null && !this.footerMap.isEmpty()) {
            result = new Footer(this.footerMap);
        }
        return result;
    }

    void setFooter(Footer footer) {
        if (footer != null) {
            this.footerMap = footer.getValue();
        }
    }

    private Long getAbsoluteExpiryTime() {
        Date date;
        Long result = null;
        if (this.properties != null && (date = this.properties.getAbsoluteExpiryTime()) != null) {
            result = date.getTime();
        }
        return result;
    }

    private Long getTtl() {
        Long result = null;
        if (this.header.nonDefaultTimeToLive()) {
            result = this.header.getTimeToLive();
        }
        return result;
    }

    private void setAbsoluteExpiryTime(Long expiration) {
        if (expiration == null || expiration == 0L) {
            if (this.properties != null) {
                this.properties.setAbsoluteExpiryTime(null);
            }
        } else {
            this.lazyCreateProperties();
            this.properties.setAbsoluteExpiryTime(new Date(expiration));
        }
    }

    private void lazyCreateProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
    }

    private void lazyCreateMessageAnnotations() {
        if (this.messageAnnotationsMap == null) {
            this.messageAnnotationsMap = new HashMap<Symbol, Object>();
        }
    }

    private void lazyCreateDeliveryAnnotations() {
        if (this.deliveryAnnotationsMap == null) {
            this.deliveryAnnotationsMap = new HashMap<Symbol, Object>();
        }
    }

    private void lazyCreateApplicationProperties() {
        if (this.applicationPropertiesMap == null) {
            this.applicationPropertiesMap = new HashMap<String, Object>();
        }
    }

    private void lazyCreateFooter() {
        if (this.footerMap == null) {
            this.footerMap = new HashMap<Symbol, Object>();
        }
    }
}

