/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.util;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.kura.linux.bluetooth.util.BluetoothSafeProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothProcessUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(BluetoothProcessUtil.class);
    private static final ExecutorService s_processExecutor = Executors.newSingleThreadExecutor();

    public static BluetoothSafeProcess exec(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        int count = st.countTokens();
        String[] cmdArray = new String[count];
        int i = 0;
        while (i < count) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return BluetoothProcessUtil.exec(cmdArray);
    }

    public static BluetoothSafeProcess exec(final String[] cmdarray) throws IOException {
        Future<BluetoothSafeProcess> futureSafeProcess = s_processExecutor.submit(new Callable<BluetoothSafeProcess>(){

            @Override
            public BluetoothSafeProcess call() throws Exception {
                Thread.currentThread().setName("SafeProcessExecutor");
                BluetoothSafeProcess safeProcess = new BluetoothSafeProcess();
                safeProcess.exec(cmdarray);
                return safeProcess;
            }
        });
        try {
            return futureSafeProcess.get();
        }
        catch (Exception e) {
            s_logger.error("Error waiting from SafeProcess output", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Deprecated
    public static void close(BluetoothSafeProcess proc) {
    }

    public static void destroy(BluetoothSafeProcess proc) {
        proc.destroy();
    }
}

