/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.le;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.bluetooth.BluetoothBeaconData;
import org.eclipse.kura.bluetooth.BluetoothBeaconScanListener;
import org.eclipse.kura.bluetooth.BluetoothDevice;
import org.eclipse.kura.bluetooth.BluetoothLeScanListener;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementData;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementScanListener;
import org.eclipse.kura.linux.bluetooth.BluetoothDeviceImpl;
import org.eclipse.kura.linux.bluetooth.util.BTSnoopListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcess;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeScanner
implements BluetoothProcessListener,
BTSnoopListener {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeScanner.class);
    private static final String MAC_REGEX = "^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$";
    public static final int SCAN_FAILED_INTERNAL_ERROR = 3;
    private static final String SIGINT = "2";
    private final Map<String, String> devices = new HashMap<String, String>();
    private List<BluetoothDevice> scanResult;
    private BluetoothProcess proc = null;
    private BluetoothProcess dumpProc = null;
    private BluetoothLeScanListener listener = null;
    private BluetoothBeaconScanListener beaconListener = null;
    private BluetoothAdvertisementScanListener advertisementListener = null;
    private boolean scanRunning = false;
    private String companyName;

    public void startScan(String name, BluetoothLeScanListener listener) {
        this.listener = listener;
        logger.info("Starting bluetooth le scan...");
        this.proc = BluetoothUtil.hcitoolCmd(name, "lescan", (BluetoothProcessListener)this);
        this.setScanRunning(true);
    }

    public void startAdvertisementScan(String name, String companyName, BluetoothAdvertisementScanListener listener) {
        this.advertisementListener = listener;
        this.companyName = companyName;
        logger.info("Starting bluetooth le advertisement scan...");
        this.proc = BluetoothUtil.hcitoolCmd(name, new String[]{"lescan-passive", "--duplicates"}, (BluetoothProcessListener)this);
        this.dumpProc = BluetoothUtil.btdumpCmd(name, this);
        this.setScanRunning(true);
    }

    public void startBeaconScan(String name, String companyName, BluetoothBeaconScanListener listener) {
        this.beaconListener = listener;
        this.companyName = companyName;
        logger.info("Starting bluetooth le beacon scan...");
        this.proc = BluetoothUtil.hcitoolCmd(name, new String[]{"lescan-passive", "--duplicates"}, (BluetoothProcessListener)this);
        this.dumpProc = BluetoothUtil.btdumpCmd(name, this);
        this.setScanRunning(true);
    }

    public void killScan() {
        if (this.proc != null) {
            logger.info("Killing hcitool...");
            BluetoothUtil.killCmd("hcitool", SIGINT);
            this.proc = null;
        } else {
            logger.info("Cannot Kill hcitool, m_proc = null ...");
        }
        if (this.dumpProc != null) {
            logger.info("Killing btdump...");
            this.dumpProc.destroyBTSnoop();
            this.dumpProc = null;
        } else {
            logger.info("Cannot Kill btdump, m_dump_proc = null ...");
        }
        this.setScanRunning(false);
    }

    @Override
    public void processInputStream(String string) {
        if (this.listener != null) {
            String[] lines;
            String[] stringArray = lines = string.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.processLine(line);
                ++n2;
            }
            this.scanResult = new ArrayList<BluetoothDevice>();
            for (Map.Entry<String, String> device : this.devices.entrySet()) {
                this.scanResult.add(new BluetoothDeviceImpl(device.getKey(), device.getValue()));
                logger.info("m_scanResult.add {} - {}", (Object)device.getKey(), (Object)device.getValue());
            }
            this.listener.onScanResults(this.scanResult);
        }
    }

    @Override
    public void processInputStream(int ch) {
    }

    @Override
    public void processBTSnoopRecord(byte[] record) {
        try {
            BluetoothAdvertisementData bAdData = BluetoothUtil.parseLEAdvertisement(record);
            if (bAdData != null && this.advertisementListener != null) {
                try {
                    this.advertisementListener.onAdvertisementDataReceived(bAdData);
                }
                catch (Exception e) {
                    logger.error("Scan listener threw exception", (Throwable)e);
                }
            }
            List<BluetoothBeaconData> beaconDatas = BluetoothUtil.parseLEAdvertisingReport(record, this.companyName);
            for (BluetoothBeaconData beaconData : beaconDatas) {
                try {
                    if (this.beaconListener == null) continue;
                    this.beaconListener.onBeaconDataReceived(beaconData);
                }
                catch (Exception e) {
                    logger.error("Scan listener threw exception", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error processing advertising report", (Throwable)e);
        }
    }

    @Override
    public void processErrorStream(String string) {
    }

    private void processLine(String line) {
        logger.info(line);
        if (line.contains("Set scan parameters failed:")) {
            logger.error("Error : {}", (Object)line);
        } else {
            String[] results = line.split("\\s", 2);
            if (results.length == 2) {
                String address = results[0].trim();
                String name = results[1].trim();
                if (address.matches(MAC_REGEX)) {
                    if (this.devices.containsKey(address)) {
                        if (!name.equals("(unknown)") && !this.devices.get(address).equals(name)) {
                            logger.debug("Updating device: {} - {}", (Object)address, (Object)name);
                            this.devices.put(address, name);
                        }
                    } else {
                        logger.debug("Device found: {} - {}", (Object)address, (Object)name);
                        this.devices.put(address, name);
                    }
                }
            }
        }
    }

    public boolean isScanRunning() {
        return this.scanRunning;
    }

    private void setScanRunning(boolean scanRunning) {
        this.scanRunning = scanRunning;
    }

    @Deprecated
    public boolean is_scanRunning() {
        return this.scanRunning;
    }

    @Deprecated
    public void set_scanRunning(boolean m_scanRunning) {
        this.scanRunning = m_scanRunning;
    }
}

