/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ip.provider.file;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.internal.ip.ProvisioningInfoProvider;
import org.eclipse.equinox.internal.ip.impl.Log;
import org.eclipse.equinox.internal.ip.impl.ProvisioningAgent;
import org.eclipse.equinox.internal.ip.provider.BaseProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.provisioning.ProvisioningService;

public class FileProvider
extends BaseProvider
implements ProvisioningInfoProvider {
    public static final String PROPS_FILE = "/props.txt";
    public static final String TEXT = "#[TEXT]";
    public static final String BINARY = "#[BINARY]";
    public static final String FILE_SUPPORT = "equinox.provisioning.file.provider.allowed";
    public static final String LOAD_ONCE = "equinox.provisioning.file.load.once";
    private Dictionary innerDict = new Hashtable();
    private File file;
    private static final byte[] ZERO_BYTE_ARRAY = new byte[1];
    static /* synthetic */ Class class$0;

    public void start(BundleContext bc) throws Exception {
        boolean filesupport = true;
        if (bc.getProperty(FILE_SUPPORT) != null && bc.getProperty(FILE_SUPPORT).equals("false")) {
            filesupport = false;
        }
        if (!filesupport) {
            Log.debug(this + " is not an allowed provider.");
            return;
        }
        this.file = bc.getDataFile("_mark123");
        boolean loadonce = true;
        if (bc.getProperty(LOAD_ONCE) != null && bc.getProperty(LOAD_ONCE).equals("false")) {
            loadonce = false;
        }
        if (this.file.exists() && loadonce) {
            Log.debug("File provider have loaded data already!");
            return;
        }
        super.start(bc);
    }

    public Dictionary init(ProvisioningService prvSrv) throws Exception {
        Hashtable<String, String> dictionary;
        block29: {
            InputStream inputStream;
            boolean loadonce = true;
            if (ProvisioningAgent.bc.getProperty(LOAD_ONCE) != null && ProvisioningAgent.bc.getProperty(LOAD_ONCE).equals("false")) {
                loadonce = false;
            }
            if (this.file.exists() && loadonce) {
                Log.debug("File provider have loaded data already!");
                return null;
            }
            String externalFileLocation = ProvisioningAgent.bc.getProperty("equinox.provisioning.file.provider.specfile.location");
            if (externalFileLocation == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.equinox.internal.ip.provider.file.FileProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                inputStream = clazz.getResourceAsStream(PROPS_FILE);
            } else {
                inputStream = new FileInputStream(externalFileLocation);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            dictionary = new Hashtable<String, String>(10, 1.0f);
            try {
                String line;
                ByteArrayOutputStream baos = null;
                byte[] buffer = null;
                boolean stringMode = true;
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("#")) {
                        InputStream is;
                        int i = line.indexOf(61);
                        if (i == -1) continue;
                        if (stringMode) {
                            ((Dictionary)dictionary).put(line.substring(0, i), line.substring(i + 1));
                            continue;
                        }
                        if (baos == null) {
                            baos = new ByteArrayOutputStream();
                            buffer = new byte[256];
                        }
                        String key = line.substring(0, i);
                        String entryName = line.substring(i + 1);
                        if (externalFileLocation == null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.equinox.internal.ip.provider.file.FileProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((is = clazz.getResourceAsStream(entryName)) == null && entryName.length() != 0 && entryName.charAt(0) != '/') {
                                Class<?> clazz2 = class$0;
                                if (clazz2 == null) {
                                    try {
                                        clazz2 = Class.forName("org.eclipse.equinox.internal.ip.provider.file.FileProvider");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                is = clazz2.getResourceAsStream(String.valueOf('/') + entryName);
                            }
                        } else {
                            is = new FileInputStream(entryName);
                        }
                        while ((i = is.read(buffer, 0, buffer.length)) != -1) {
                            baos.write(buffer, 0, i);
                        }
                        this.innerDict.put(key, baos.toByteArray());
                        baos.reset();
                        continue;
                    }
                    if (line.equalsIgnoreCase(TEXT)) {
                        stringMode = true;
                        continue;
                    }
                    if (!line.equalsIgnoreCase(BINARY)) continue;
                    stringMode = false;
                }
                if (this.file.exists()) break block29;
                FileOutputStream fos = new FileOutputStream(this.file);
                try {
                    fos.write(ZERO_BYTE_ARRAY);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                reader.close();
            }
        }
        return dictionary;
    }

    public Object get(Object key) {
        return this.innerDict.get(key);
    }

    public String toString() {
        return "File";
    }
}

