/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoServiceImpl
implements CryptoService {
    private static final Logger logger = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private static final String ALGORITHM = "AES";
    private static final byte[] SECRET_KEY = System.getProperty("org.eclipse.kura.core.crypto.secretKey", "rv;ipse329183!@#").getBytes();
    private String keystorePasswordPath;
    private SystemService systemService;

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    protected void activate() {
        if (this.systemService == null) {
            throw new IllegalStateException("Unable to get instance of: " + SystemService.class.getName());
        }
        this.keystorePasswordPath = String.valueOf(this.systemService.getKuraDataDirectory()) + File.separator + "store.save";
    }

    public char[] encryptAes(char[] value) throws KuraException {
        String encryptedValue = null;
        try {
            Key key = CryptoServiceImpl.generateKey();
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, key);
            byte[] encryptedBytes = c.doFinal(new String(value).getBytes());
            encryptedValue = this.base64Encode(encryptedBytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR);
        }
        catch (BadPaddingException badPaddingException) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR);
        }
        return encryptedValue.toCharArray();
    }

    private byte[] base64Decode(String internalStringValue) {
        return Base64.getDecoder().decode(internalStringValue);
    }

    private String base64Encode(byte[] encryptedBytes) {
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public char[] decryptAes(char[] encryptedValue) throws KuraException {
        Key key = CryptoServiceImpl.generateKey();
        try {
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, key);
            String internalStringValue = new String(encryptedValue);
            byte[] decodedValue = this.base64Decode(internalStringValue);
            if (encryptedValue.length > 0 && decodedValue.length == 0) {
                throw new KuraException(KuraErrorCode.DECODER_ERROR);
            }
            byte[] decryptedBytes = c.doFinal(decodedValue);
            String decryptedValue = new String(decryptedBytes);
            return decryptedValue.toCharArray();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR);
        }
        catch (BadPaddingException badPaddingException) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR);
        }
    }

    @Deprecated
    public String encryptAes(String value) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        char[] encryptedValue;
        block6: {
            encryptedValue = null;
            try {
                encryptedValue = this.encryptAes(value.toCharArray());
            }
            catch (KuraException e) {
                Throwable t = e.getCause();
                if (t instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)t;
                }
                if (t instanceof NoSuchPaddingException) {
                    throw (NoSuchPaddingException)t;
                }
                if (t instanceof InvalidKeyException) {
                    throw (InvalidKeyException)t;
                }
                if (t instanceof IllegalBlockSizeException) {
                    throw (IllegalBlockSizeException)t;
                }
                if (!(t instanceof BadPaddingException)) break block6;
                throw (BadPaddingException)t;
            }
        }
        return new String(encryptedValue);
    }

    @Deprecated
    public String decryptAes(String encryptedValue) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException, IllegalBlockSizeException, BadPaddingException {
        try {
            return new String(this.decryptAes(encryptedValue.toCharArray()));
        }
        catch (KuraException kuraException) {
            throw new IOException();
        }
    }

    public String sha1Hash(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest cript = MessageDigest.getInstance("SHA-1");
        cript.reset();
        cript.update(s.getBytes("UTF8"));
        byte[] encodedBytes = cript.digest();
        return this.base64Encode(encodedBytes);
    }

    public String encodeBase64(String stringValue) throws UnsupportedEncodingException {
        if (stringValue == null) {
            return null;
        }
        return this.base64Encode(stringValue.getBytes("UTF-8"));
    }

    public String decodeBase64(String encodedValue) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (encodedValue == null) {
            return null;
        }
        return new String(this.base64Decode(encodedValue), "UTF-8");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char[] getKeyStorePassword(String keyStorePath) {
        Properties props = new Properties();
        char[] password = null;
        FileInputStream fis = null;
        File f = new File(this.keystorePasswordPath);
        if (!f.exists()) {
            return "changeit".toCharArray();
        }
        try {
            try {
                fis = new FileInputStream(this.keystorePasswordPath);
                props.load(fis);
                Object value = props.get(keyStorePath);
                if (value == null) return password;
                String encryptedPassword = (String)value;
                password = this.decryptAes(encryptedPassword.toCharArray());
                return password;
            }
            catch (FileNotFoundException e) {
                logger.warn("File not found exception while getting keystore password - ", (Throwable)e);
                if (fis == null) return password;
                try {
                    fis.close();
                    return password;
                }
                catch (IOException e2) {
                    logger.warn("IOException while closing source - ", (Throwable)e2);
                }
                return password;
            }
            catch (IOException e) {
                logger.warn("IOException while getting keystore password - ", (Throwable)e);
                if (fis == null) return password;
                try {
                    fis.close();
                    return password;
                }
                catch (IOException e3) {
                    logger.warn("IOException while closing source - ", (Throwable)e3);
                }
                return password;
            }
            catch (KuraException e) {
                logger.warn("KuraException while getting keystore password - ", (Throwable)e);
                if (fis == null) return password;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                    return password;
                }
                catch (IOException e4) {
                    logger.warn("IOException while closing source - ", (Throwable)e4);
                }
                return password;
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.warn("IOException while closing source - ", (Throwable)e);
                }
            }
        }
    }

    public void setKeyStorePassword(String keyStorePath, char[] password) throws KuraException {
        Properties props = new Properties();
        char[] encryptedPassword = this.encryptAes(password);
        props.put(keyStorePath, new String(encryptedPassword));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream fos = new FileOutputStream(this.keystorePasswordPath);){
                props.store(fos, "Do not edit this file. It's automatically generated by Kura");
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[0]);
        }
    }

    @Deprecated
    public void setKeyStorePassword(String keyStorePath, String password) throws IOException {
        try {
            this.setKeyStorePassword(keyStorePath, password.toCharArray());
        }
        catch (KuraException e) {
            throw new IOException(e);
        }
    }

    public boolean isFrameworkSecure() {
        return false;
    }

    private static Key generateKey() {
        return new SecretKeySpec(SECRET_KEY, ALGORITHM);
    }
}

