/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.firewall;

import org.eclipse.kura.net.NetConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class FirewallNatConfig
implements NetConfig {
    private final String m_sourceInterface;
    private final String m_destinationInterface;
    private final String m_protocol;
    private final String m_source;
    private final String m_destination;
    private final boolean m_masquerade;

    public FirewallNatConfig(String srcIface, String dstIface, String protocol, String src, String dst, boolean masquerade) {
        this.m_sourceInterface = srcIface;
        this.m_destinationInterface = dstIface;
        this.m_protocol = protocol;
        this.m_source = src;
        this.m_destination = dst;
        this.m_masquerade = masquerade;
    }

    public String getSourceInterface() {
        return this.m_sourceInterface;
    }

    public String getDestinationInterface() {
        return this.m_destinationInterface;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getSource() {
        return this.m_source;
    }

    public String getDestination() {
        return this.m_destination;
    }

    public boolean isMasquerade() {
        return this.m_masquerade;
    }

    @Override
    public boolean isValid() {
        return this.m_destinationInterface != null && !this.m_destinationInterface.trim().isEmpty() && this.m_sourceInterface != null && !this.m_sourceInterface.trim().isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_destinationInterface == null ? 0 : this.m_destinationInterface.hashCode());
        result = 31 * result + (this.m_sourceInterface == null ? 0 : this.m_sourceInterface.hashCode());
        result = 31 * result + (this.m_protocol == null ? 0 : this.m_protocol.hashCode());
        result = 31 * result + (this.m_source == null ? 0 : this.m_source.hashCode());
        result = 31 * result + (this.m_destination == null ? 0 : this.m_destination.hashCode());
        result = 31 * result + (this.m_masquerade ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallNatConfig other = (FirewallNatConfig)obj;
        if (this.m_masquerade != other.m_masquerade) {
            return false;
        }
        if (this.m_sourceInterface == null) {
            if (other.m_sourceInterface != null) {
                return false;
            }
        } else {
            if (!this.m_sourceInterface.equals(other.m_sourceInterface)) {
                return false;
            }
            if (!this.m_protocol.equals(other.m_protocol)) {
                return false;
            }
        }
        if (this.m_destinationInterface == null ? other.m_destinationInterface != null : !this.m_destinationInterface.equals(other.m_destinationInterface)) {
            return false;
        }
        if (this.m_source == null ? other.m_source != null : !this.m_source.equals(other.m_source)) {
            return false;
        }
        return !(this.m_destination == null ? other.m_destination != null : !this.m_destination.equals(other.m_destination));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FirewallNatConfig [m_sourceInterface=");
        builder.append(this.m_sourceInterface);
        builder.append(", m_destinationInterface=");
        builder.append(this.m_destinationInterface);
        builder.append(", m_source=");
        builder.append(this.m_source);
        builder.append(", m_destination=");
        builder.append(this.m_destination);
        builder.append("]");
        return builder.toString();
    }
}

