/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.util.KuraBaseModel;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;

public class GwtWifiHotspotEntry
extends KuraBaseModel
implements Serializable {
    private static final Logger logger = Logger.getLogger(GwtWifiHotspotEntry.class.getSimpleName());
    private static final String FREQUENCY = "frequency";
    private static final String CHANNEL = "channel";
    private static final String SIGNAL_STRENGTH = "signalStrength";
    private static final long serialVersionUID = -7818472380334612955L;

    public String getSSID() {
        return (String)this.get("ssid");
    }

    public void setSSID(String ssid) {
        this.set("ssid", ssid);
    }

    public String getMacAddress() {
        return (String)this.get("macAddress");
    }

    public void setMacAddress(String macAddress) {
        this.set("macAddress", macAddress);
    }

    public Integer getSignalStrength() {
        if (this.get(SIGNAL_STRENGTH) != null) {
            return (Integer)this.get(SIGNAL_STRENGTH);
        }
        return 0;
    }

    public void setsignalStrength(int signalStrength) {
        this.set(SIGNAL_STRENGTH, signalStrength);
    }

    public Integer getChannel() {
        if (this.get(CHANNEL) != null) {
            return (Integer)this.get(CHANNEL);
        }
        return 0;
    }

    public void setChannel(int channel) {
        this.set(CHANNEL, channel);
    }

    public Integer getFrequency() {
        if (this.get(FREQUENCY) != null) {
            return (Integer)this.get(FREQUENCY);
        }
        return 0;
    }

    public void setFrequency(int frequency) {
        this.set(FREQUENCY, frequency);
    }

    public String getSecurity() {
        return (String)this.get("security");
    }

    public void setSecurity(String security) {
        this.set("security", security);
    }

    public GwtWifiCiphers getPairwiseCiphersEnum() {
        GwtWifiCiphers ciphers = GwtWifiCiphers.netWifiCiphers_NONE;
        try {
            ciphers = GwtWifiCiphers.valueOf(this.getPairwiseCiphers());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error getting pairwise ciphers.", e);
        }
        return ciphers;
    }

    public String getPairwiseCiphers() {
        return (String)this.get("pairwiseCiphers");
    }

    public void setPairwiseCiphers(String pairwiseCiphers) {
        this.set("pairwiseCiphers", pairwiseCiphers);
    }

    public GwtWifiCiphers getGroupCiphersEnum() {
        GwtWifiCiphers ciphers = GwtWifiCiphers.netWifiCiphers_NONE;
        try {
            ciphers = GwtWifiCiphers.valueOf(this.getGroupCiphers());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error getting group ciphers.", e);
        }
        return ciphers;
    }

    public String getGroupCiphers() {
        return (String)this.get("groupCiphers");
    }

    public void setGroupCiphers(String groupCiphers) {
        this.set("groupCiphers", groupCiphers);
    }
}

