/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.web.shared.model.GwtBaseModel;

public class GwtWifiChannelModel
extends GwtBaseModel {
    private static final long serialVersionUID = -1471520645150788770L;
    private static final String BAND2400MHZ = "2.4 GHz";
    private static final int FIRST_2400MHZ_CHANNEL = 1;
    private static final int LAST_2400MHZ_CHANNEL = 13;

    public GwtWifiChannelModel() {
    }

    public GwtWifiChannelModel(String name, int channel, int frequency, String band) {
        this.set("name", name);
        this.set("channel", channel);
        this.set("frequency", frequency);
        this.set("band", band);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public int getChannel() {
        Integer iChannel = (Integer)this.get("channel");
        return iChannel;
    }

    public int getFrequency() {
        Integer iFrequency = (Integer)this.get("frequency");
        return iFrequency;
    }

    public String getBand() {
        return (String)this.get("band");
    }

    public void setBand(String band) {
        this.set("band", band);
    }

    public static List<GwtWifiChannelModel> getChannels() {
        ArrayList<GwtWifiChannelModel> alCannels = new ArrayList<GwtWifiChannelModel>();
        int i = 1;
        while (i <= 13) {
            alCannels.add(new GwtWifiChannelModel(GwtWifiChannelModel.formChannelName(i), i, GwtWifiChannelModel.getCannelFrequencyMHz(i), BAND2400MHZ));
            ++i;
        }
        return alCannels;
    }

    public String toString() {
        return this.getName();
    }

    private static String formChannelName(int channel) {
        StringBuffer sb = new StringBuffer();
        sb.append("Channel ");
        sb.append(channel);
        return sb.toString();
    }

    private static int getCannelFrequencyMHz(int channel) {
        int frequency = -1;
        if (channel >= 1 && channel <= 13) {
            frequency = 2407 + channel * 5;
        }
        return frequency;
    }
}

