/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;

public interface WritableBuffer {
    public void put(byte var1);

    public void putFloat(float var1);

    public void putDouble(double var1);

    public void put(byte[] var1, int var2, int var3);

    public void putShort(short var1);

    public void putInt(int var1);

    public void putLong(long var1);

    public boolean hasRemaining();

    public int remaining();

    public int position();

    public void position(int var1);

    public void put(ByteBuffer var1);

    public int limit();

    public static class ByteBufferWrapper
    implements WritableBuffer {
        private final ByteBuffer _buf;

        public ByteBufferWrapper(ByteBuffer buf) {
            this._buf = buf;
        }

        @Override
        public void put(byte b) {
            this._buf.put(b);
        }

        @Override
        public void putFloat(float f) {
            this._buf.putFloat(f);
        }

        @Override
        public void putDouble(double d) {
            this._buf.putDouble(d);
        }

        @Override
        public void put(byte[] src, int offset, int length) {
            this._buf.put(src, offset, length);
        }

        @Override
        public void putShort(short s) {
            this._buf.putShort(s);
        }

        @Override
        public void putInt(int i) {
            this._buf.putInt(i);
        }

        @Override
        public void putLong(long l) {
            this._buf.putLong(l);
        }

        @Override
        public boolean hasRemaining() {
            return this._buf.hasRemaining();
        }

        @Override
        public int remaining() {
            return this._buf.remaining();
        }

        @Override
        public int position() {
            return this._buf.position();
        }

        @Override
        public void position(int position) {
            this._buf.position(position);
        }

        @Override
        public void put(ByteBuffer src) {
            this._buf.put(src);
        }

        @Override
        public int limit() {
            return this._buf.limit();
        }

        public String toString() {
            return String.format("[pos: %d, limit: %d, remaining:%d]", this._buf.position(), this._buf.limit(), this._buf.remaining());
        }

        public static ByteBufferWrapper allocate(int size) {
            ByteBuffer allocated = ByteBuffer.allocate(size);
            return new ByteBufferWrapper(allocated);
        }
    }
}

