/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire;

import java.util.Objects;
import org.eclipse.kura.internal.wire.WireGraphServiceImpl;
import org.eclipse.kura.wire.WireComponent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WireComponentTrackerCustomizer
implements ServiceTrackerCustomizer<WireComponent, WireComponent> {
    private static final Logger logger = LoggerFactory.getLogger(WireComponentTrackerCustomizer.class);
    private final BundleContext context;
    private final WireGraphServiceImpl wireGraphService;

    WireComponentTrackerCustomizer(BundleContext context, WireGraphServiceImpl wireGraphService) {
        Objects.requireNonNull(context, "Bundle context cannot be null");
        Objects.requireNonNull(wireGraphService, "Wire Graph Service cannot be null");
        this.wireGraphService = wireGraphService;
        this.context = context;
    }

    public WireComponent addingService(ServiceReference<WireComponent> reference) {
        WireComponent service = (WireComponent)this.context.getService(reference);
        logger.debug("Adding Wire Components....");
        this.wireGraphService.createWires();
        logger.debug("Adding Wire Components....Done");
        return service;
    }

    public void modifiedService(ServiceReference<WireComponent> reference, WireComponent service) {
    }

    public void removedService(ServiceReference<WireComponent> reference, WireComponent service) {
        this.context.ungetService(reference);
    }
}

