/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.emulator.gpio;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.kura.emulator.gpio.EmulatedPin;
import org.eclipse.kura.gpio.GPIOService;
import org.eclipse.kura.gpio.KuraGPIODirection;
import org.eclipse.kura.gpio.KuraGPIOMode;
import org.eclipse.kura.gpio.KuraGPIOPin;
import org.eclipse.kura.gpio.KuraGPIOTrigger;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GpioServiceImpl
implements GPIOService {
    private static final Logger s_logger = LoggerFactory.getLogger(GpioServiceImpl.class);
    private static final HashMap<Integer, String> pins = new HashMap();

    protected void activate(ComponentContext componentContext) {
        s_logger.debug("activating emulated GPIOService");
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.debug("deactivating emulated GPIOService");
    }

    public KuraGPIOPin getPinByName(String pinName) {
        return new EmulatedPin(pinName);
    }

    public KuraGPIOPin getPinByName(String pinName, KuraGPIODirection direction, KuraGPIOMode mode, KuraGPIOTrigger trigger) {
        return new EmulatedPin(pinName, direction, mode, trigger);
    }

    public KuraGPIOPin getPinByTerminal(int terminal) {
        return new EmulatedPin(terminal);
    }

    public KuraGPIOPin getPinByTerminal(int terminal, KuraGPIODirection direction, KuraGPIOMode mode, KuraGPIOTrigger trigger) {
        return new EmulatedPin(terminal, direction, mode, trigger);
    }

    public Map<Integer, String> getAvailablePins() {
        pins.clear();
        int i = 1;
        while (i < 11) {
            pins.put(i, "Pin#" + String.valueOf(i));
            ++i;
        }
        return pins;
    }
}

