/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import javax.jms.JMSException;
import org.apache.qpid.jms.provider.ProviderConstants;

public class JmsMessageSupport {
    public static final String JMS_DESTINATION = "JMSDestination";
    public static final String JMS_REPLYTO = "JMSReplyTo";
    public static final String JMS_TYPE = "JMSType";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String JMS_MESSAGEID = "JMSMessageID";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_CORRELATIONID = "JMSCorrelationID";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_DELIVERYTIME = "JMSDeliveryTime";
    public static final String JMSX_GROUPID = "JMSXGroupID";
    public static final String JMSX_GROUPSEQ = "JMSXGroupSeq";
    public static final String JMSX_DELIVERY_COUNT = "JMSXDeliveryCount";
    public static final String JMSX_USERID = "JMSXUserID";
    public static final String JMS_AMQP_ACK_TYPE = "JMS_AMQP_ACK_TYPE";
    public static final int ACCEPTED = 1;
    public static final int REJECTED = 2;
    public static final int RELEASED = 3;
    public static final int MODIFIED_FAILED = 4;
    public static final int MODIFIED_FAILED_UNDELIVERABLE = 5;

    public static ProviderConstants.ACK_TYPE lookupAckTypeForDisposition(int dispositionType) throws JMSException {
        switch (dispositionType) {
            case 1: {
                return ProviderConstants.ACK_TYPE.ACCEPTED;
            }
            case 2: {
                return ProviderConstants.ACK_TYPE.REJECTED;
            }
            case 3: {
                return ProviderConstants.ACK_TYPE.RELEASED;
            }
            case 4: {
                return ProviderConstants.ACK_TYPE.MODIFIED_FAILED;
            }
            case 5: {
                return ProviderConstants.ACK_TYPE.MODIFIED_FAILED_UNDELIVERABLE;
            }
        }
        throw new JMSException("Unable to determine ack type for disposition: " + dispositionType);
    }
}

