/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server;

import io.moquette.interception.InterceptHandler;
import io.moquette.proto.messages.PublishMessage;
import io.moquette.server.DefaultMoquetteSslContextCreator;
import io.moquette.server.ServerAcceptor;
import io.moquette.server.config.FilesystemConfig;
import io.moquette.server.config.IConfig;
import io.moquette.server.config.MemoryConfig;
import io.moquette.server.netty.NettyAcceptor;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.impl.SimpleMessaging;
import io.moquette.spi.security.IAuthenticator;
import io.moquette.spi.security.IAuthorizator;
import io.moquette.spi.security.ISslContextCreator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private ServerAcceptor m_acceptor;
    private volatile boolean m_initialized;
    private ProtocolProcessor m_processor;

    public static void main(String[] args) throws IOException {
        final Server server = new Server();
        server.startServer();
        System.out.println("Server started, version 0.8.1");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                server.stopServer();
            }
        });
    }

    public void startServer() throws IOException {
        FilesystemConfig config = new FilesystemConfig();
        this.startServer(config);
    }

    public void startServer(File configFile) throws IOException {
        LOG.info("Using m_config file: " + configFile.getAbsolutePath());
        FilesystemConfig config = new FilesystemConfig(configFile);
        this.startServer(config);
    }

    public void startServer(Properties configProps) throws IOException {
        MemoryConfig config = new MemoryConfig(configProps);
        this.startServer(config);
    }

    public void startServer(IConfig config) throws IOException {
        this.startServer(config, null);
    }

    public void startServer(IConfig config, List<? extends InterceptHandler> handlers) throws IOException {
        this.startServer(config, handlers, null, null, null);
    }

    public void startServer(IConfig config, List<? extends InterceptHandler> handlers, ISslContextCreator sslCtxCreator, IAuthenticator authenticator, IAuthorizator authorizator) throws IOException {
        String handlerProp;
        if (handlers == null) {
            handlers = Collections.emptyList();
        }
        if ((handlerProp = System.getProperty("intercept.handler")) != null) {
            config.setProperty("intercept.handler", handlerProp);
        }
        LOG.info("Persistent store file: " + config.getProperty("persistent_store"));
        ProtocolProcessor processor = SimpleMessaging.getInstance().init(config, handlers, authenticator, authorizator);
        if (sslCtxCreator == null) {
            sslCtxCreator = new DefaultMoquetteSslContextCreator(config);
        }
        this.m_acceptor = new NettyAcceptor();
        this.m_acceptor.initialize(processor, config, sslCtxCreator);
        this.m_processor = processor;
        this.m_initialized = true;
    }

    public void internalPublish(PublishMessage msg) {
        if (!this.m_initialized) {
            throw new IllegalStateException("Can't publish on a server is not yet started");
        }
        this.m_processor.internalPublish(msg);
    }

    public void stopServer() {
        LOG.info("Server stopping...");
        this.m_acceptor.close();
        SimpleMessaging.getInstance().shutdown();
        this.m_initialized = false;
        LOG.info("Server stopped");
    }
}

